import { Range, TextEdit } from "vscode-languageserver-types";
import { SyntaxKind } from "../../index.js";
export function createChangeToEdit(start, end, changeTo) {
    return TextEdit.replace(Range.create(start, end), changeTo);
}
export function getEdgeStr(op) {
    return op === SyntaxKind.DirectedEdgeOp ? "->" : "--";
}
export function getGraphKeywordStr(g) {
    return g === SyntaxKind.DigraphKeyword ? "digraph" : "graph";
}
export function getOppositeKind(g) {
    return g === SyntaxKind.DigraphKeyword ? SyntaxKind.GraphKeyword : SyntaxKind.DigraphKeyword;
}
export function getOppositeEdgeOp(g) {
    return g === SyntaxKind.DirectedEdgeOp
        ? SyntaxKind.UndirectedEdgeOp
        : SyntaxKind.DirectedEdgeOp;
}
export function getAllowedOp(g) {
    return g === SyntaxKind.DigraphKeyword
        ? SyntaxKind.DirectedEdgeOp
        : SyntaxKind.UndirectedEdgeOp;
}
//# sourceMappingURL=common.js.map