/**
 * ./src/classes/families/fedora.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import fs from 'node:fs';
import { exec, shx } from '../../lib/utils.js';
import Utils from '../utils.js';
/**
 * Utils: general porpourse utils
 * @remarks all the utilities
 */
export default class Fedora {
    static packs4calamares = ['calamares'];
    /**
     *
     */
    static async calamaresInstall(verbose = true) {
        const echo = Utils.setEcho(verbose);
        try {
            await exec(`dnf install -y calamares`, echo);
        }
        catch {
            Utils.error(`cannot install calamares`);
        }
    }
    /**
     *
     * calamaresPolicies
     */
    static async calamaresPolicies(verbose = false) {
        // nothing
    }
    /**
     *
     */
    static async calamaresRemove(verbose = true) {
        const echo = Utils.setEcho(verbose);
        let success = false;
        try {
            await exec('dnf -y remove calamares', echo);
            success = true;
        }
        catch {
            Utils.error(`Cannot remove calamares`);
        }
        if (success && fs.existsSync('/etc/calamares')) {
            await exec('rm /etc/calamares -rf', echo);
        }
        return success;
    }
    /**
     * check if it's installed wayland
     * @returns true if wayland
     */
    static isInstalledWayland() {
        return this.packageIsInstalled('xorg-x11-server-Xwayland*');
    }
    /**
     * check if it's installed xorg
     * @returns true if xorg is installed
     */
    static isInstalledXorg() {
        return this.packageIsInstalled('xorg-x11-server-Xorg.x86_64');
    }
    /**
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static async packageAvailable(packageName) {
        let available = false;
        const cmd = `/usr/bin/dnf list --available ${packageName} | grep Package:`;
        const stdout = shx.exec(cmd, { silent: true }).stdout.trim();
        if (stdout.includes(packageName)) {
            available = true;
        }
        return available;
    }
    /**
     * Install the package packageName
     * @param packageName {string} Pacchetto da installare
     * @returns {boolean} True if success
     */
    static async packageInstall(packageName) {
        let retVal = false;
        if (shx.exec('/usr/bin/dnf install ' + packageName, { silent: true }).code === 0) {
            retVal = true;
        }
        return retVal;
    }
    /**
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static packageIsInstalled(packageName) {
        let installed = false;
        const cmd = `/usr/bin/dnf list --installed ${packageName}`;
        const stdout = shx.exec(cmd, { silent: true }).stdout.trim();
        if (stdout.includes(packageName)) {
            installed = true;
        }
        return installed;
    }
}
