/**
 * ./src/classes/pacman.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IDistro, IRemix } from '../interfaces/index.js';
/**
 * Utils: general porpouse utils
 * @remarks all the utilities
 */
export default class Pacman {
    static debs4calamares: string[];
    distro: IDistro;
    remix: IRemix;
    /**
     * autocompleteInstall()
     * @param verbose
     */
    static autocompleteInstall(): Promise<void>;
    /**
     * autocompleteRemove
     * @param verbose
     */
    static autocompleteRemove(verbose?: boolean): Promise<void>;
    /**
     * return true if calamares is installed
     */
    static calamaresExists(): boolean;
    /**
     *
     */
    static calamaresInstall(verbose?: boolean): Promise<void>;
    /**
     * calamaresPolicies
     */
    static calamaresPolicies(verbose?: boolean): Promise<void>;
    /**
     *
     */
    static calamaresRemove(verbose?: boolean): Promise<boolean>;
    /**
     *
     * @param cmd
     */
    static commandIsInstalled(cmd: string): boolean;
    /**
     * Restituisce VERO se i file di configurazione SONO presenti
     */
    static configurationCheck(): boolean;
    /**
     *
     */
    static configurationFresh(): Promise<void>;
    /**
     * Creazione del file di configurazione /etc/penguins-eggs
     */
    static configurationInstall(links?: boolean, verbose?: boolean): Promise<void>;
    /**
     * Rimozione dei file di configurazione
     */
    static configurationRemove(verbose?: boolean): Promise<void>;
    /**
     * Ritorna vero se machine-id è uguale
     */
    static configurationMachineNew(verbose?: boolean): Promise<boolean>;
    /**
     *
     * @returns
     */
    static distro(): IDistro;
    /**
     * distroTemplateCheck
     */
    static distroTemplateCheck(): boolean;
    /**
     *
     */
    static distroTemplateInstall(verbose?: boolean): Promise<void>;
    /**
     * Controlla se calamares è installabile
     * @returns
     */
    static isCalamaresAvailable(): boolean;
    /**
     *
     * @returns true se GUI
     */
    static isInstalledGui(): boolean;
    /**
     * check if it's installed wayland
     * @returns true if wayland
     */
    static isInstalledWayland(): boolean;
    /**
     * check if it's installed xorg
     * @returns
     */
    static isInstalledXorg(): boolean;
    /**
     * Check if the system is just CLI
     */
    static isRunningCli(): boolean;
    /**
     * Check if the system is GUI able
     */
    static isRunningGui(): boolean;
    /**
     * Constrolla se è operante wayland
     */
    static isRunningWayland(): boolean;
    /**
     * controlla se è operante xserver-xorg-core
     */
    static isRunningXorg(): boolean;
    /**
     * Check se la macchina ha grub adatto ad efi
     * Forse conviene spostarlo in pacman
     */
    static isUefi(): boolean;
    /**
     * Installa manPage
     */
    static manpageInstall(): Promise<void>;
    /**
     * manpageRemove
     */
    static manpageRemove(): Promise<void>;
    /**
     *
     * @param debPackage
     * @returns
     */
    static packageAptLast(debPackage: string): Promise<string>;
    /**
     * Install the package packageName
     * @param packageName {string} Pacchetto Debian da installare
     * @returns {boolean} True if success
     */
    static packageInstall(packageName: string): Promise<boolean>;
    /**
     * restuisce VERO se il pacchetto è installato
     * @param debPackage
     */
    static packageIsInstalled(packageName: string): boolean;
    /**
     *
     * @param packageNpm
     * @returns
     */
    static packageNpmLast(packageNpm?: string): Promise<string>;
}
