/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.schema.options;

import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Logger;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectNamesType;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectsType;
import schemacrawler.tools.command.text.schema.options.HideDependantDatabaseObjectsType;
import schemacrawler.tools.command.text.schema.options.PortableType;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptions;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.text.options.BaseTextOptionsBuilder;

public abstract class BaseSchemaTextOptionsBuilder<B extends BaseSchemaTextOptionsBuilder<B, O>, O extends SchemaTextOptions>
extends BaseTextOptionsBuilder<BaseSchemaTextOptionsBuilder<B, O>, O> {
    private static final Logger LOGGER = Logger.getLogger(BaseSchemaTextOptionsBuilder.class.getName());
    private static final String SHOW_ORDINAL_NUMBERS = "schemacrawler.format.show_ordinal_numbers";
    private static final String SHOW_STANDARD_COLUMN_TYPE_NAMES = "schemacrawler.format.show_standard_column_type_names";
    private static final String HIDE_TABLE_ROW_COUNTS = "schemacrawler.format.hide_table_row_counts";
    private static final String HIDE_TRIGGER_ACTION_STATEMENTS = "schemacrawler.format.hide_trigger_action_statements";
    private static final String HIDE_REMARKS = "schemacrawler.format.hide_remarks";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_INDEXES = "schemacrawler.format.sort_alphabetically.table_indexes";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS = "schemacrawler.format.sort_alphabetically.table_foreignkeys";
    protected boolean isAlphabeticalSortForForeignKeys;
    protected boolean isAlphabeticalSortForIndexes;
    protected boolean isHideRemarks;
    protected boolean isShowOrdinalNumbers;
    protected boolean isShowStandardColumnTypeNames;
    protected boolean isHideTableRowCounts;
    protected boolean isHideTriggerActionStatements;
    protected final Map<HideDatabaseObjectsType, Boolean> hideDatabaseObjects = new EnumMap<HideDatabaseObjectsType, Boolean>(HideDatabaseObjectsType.class);
    protected final Map<HideDependantDatabaseObjectsType, Boolean> hideDependantDatabaseObjects = new EnumMap<HideDependantDatabaseObjectsType, Boolean>(HideDependantDatabaseObjectsType.class);
    protected final Map<HideDatabaseObjectNamesType, Boolean> hideNames = new EnumMap<HideDatabaseObjectNamesType, Boolean>(HideDatabaseObjectNamesType.class);

    @Override
    public B fromConfig(Config config) {
        boolean isHidden;
        if (config == null) {
            return (B)this;
        }
        super.fromConfig(config);
        this.isShowStandardColumnTypeNames = config.getBooleanValue(SHOW_STANDARD_COLUMN_TYPE_NAMES);
        this.isShowOrdinalNumbers = config.getBooleanValue(SHOW_ORDINAL_NUMBERS);
        this.isHideTableRowCounts = config.getBooleanValue(HIDE_TABLE_ROW_COUNTS);
        this.isHideTriggerActionStatements = config.getBooleanValue(HIDE_TRIGGER_ACTION_STATEMENTS);
        this.isHideRemarks = config.getBooleanValue(HIDE_REMARKS);
        this.isAlphabeticalSortForForeignKeys = config.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS);
        this.isAlphabeticalSortForIndexes = config.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_INDEXES);
        for (HideDatabaseObjectsType hideDatabaseObjectsType : HideDatabaseObjectsType.values()) {
            isHidden = config.getBooleanValue(hideDatabaseObjectsType.getKey());
            this.hideDatabaseObjects.put(hideDatabaseObjectsType, isHidden);
        }
        for (Enum enum_ : HideDependantDatabaseObjectsType.values()) {
            isHidden = config.getBooleanValue(((HideDependantDatabaseObjectsType)enum_).getKey());
            this.hideDependantDatabaseObjects.put((HideDependantDatabaseObjectsType)enum_, isHidden);
        }
        for (Enum enum_ : HideDatabaseObjectNamesType.values()) {
            isHidden = config.getBooleanValue(((HideDatabaseObjectNamesType)enum_).getKey());
            this.hideNames.put((HideDatabaseObjectNamesType)enum_, isHidden);
        }
        this.fromConfigCommandLineOverride(config);
        return (B)this;
    }

    @Override
    public B fromOptions(O options) {
        if (options == null) {
            return (B)this;
        }
        super.fromOptions(options);
        this.isShowStandardColumnTypeNames = ((SchemaTextOptions)options).isShowStandardColumnTypeNames();
        this.isShowOrdinalNumbers = ((SchemaTextOptions)options).isShowOrdinalNumbers();
        this.isHideTableRowCounts = ((SchemaTextOptions)options).isHideTableRowCounts();
        this.isHideTriggerActionStatements = ((SchemaTextOptions)options).isHideTriggerActionStatements();
        this.isHideRemarks = ((SchemaTextOptions)options).isHideRemarks();
        this.isAlphabeticalSortForForeignKeys = ((SchemaTextOptions)options).isAlphabeticalSortForForeignKeys();
        this.isAlphabeticalSortForIndexes = ((SchemaTextOptions)options).isAlphabeticalSortForIndexes();
        for (HideDatabaseObjectsType hideDatabaseObjectsType : HideDatabaseObjectsType.values()) {
            this.hideDatabaseObjects.put(hideDatabaseObjectsType, ((SchemaTextOptions)options).is(hideDatabaseObjectsType));
        }
        for (Enum enum_ : HideDependantDatabaseObjectsType.values()) {
            this.hideDependantDatabaseObjects.put((HideDependantDatabaseObjectsType)enum_, ((SchemaTextOptions)options).is((HideDependantDatabaseObjectsType)enum_));
        }
        for (Enum enum_ : HideDatabaseObjectNamesType.values()) {
            this.hideNames.put((HideDatabaseObjectNamesType)enum_, ((SchemaTextOptions)options).is((HideDatabaseObjectNamesType)enum_));
        }
        return (B)this;
    }

    public final B hideRowCounts() {
        return this.hideRowCounts(true);
    }

    public final B hideRowCounts(boolean value) {
        this.isHideTableRowCounts = value;
        return (B)this;
    }

    public final B noAlternateKeyNames() {
        return this.noAlternateKeyNames(true);
    }

    public final B noAlternateKeyNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideAlternateKeyNames, value);
        return (B)this;
    }

    public final B noAlternateKeys() {
        return this.noAlternateKeys(true);
    }

    public final B noAlternateKeys(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hideAlternateKeys, value);
        return (B)this;
    }

    public final B noConstraintNames() {
        return this.noConstraintNames(true);
    }

    public final B noConstraintNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideTableConstraintNames, value);
        return (B)this;
    }

    public final B noForeignKeyNames() {
        return this.noForeignKeyNames(true);
    }

    public final B noForeignKeyNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideForeignKeyNames, value);
        return (B)this;
    }

    public final B noForeignKeys() {
        return this.noForeignKeys(true);
    }

    public final B noForeignKeys(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hideForeignKeys, value);
        return (B)this;
    }

    public final B noIndexes() {
        return this.noIndexes(true);
    }

    public final B noIndexes(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hideIndexes, value);
        return (B)this;
    }

    public final B noIndexNames() {
        return this.noIndexNames(true);
    }

    public final B noIndexNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideIndexNames, value);
        return (B)this;
    }

    public final B noPrimaryKeyNames() {
        return this.noPrimaryKeyNames(true);
    }

    public final B noPrimaryKeyNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hidePrimaryKeyNames, value);
        return (B)this;
    }

    public final B noPrimaryKeys() {
        return this.noPrimaryKeys(true);
    }

    public final B noPrimaryKeys(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hidePrimaryKeys, value);
        return (B)this;
    }

    public final B noRemarks() {
        return this.noRemarks(true);
    }

    public final B noRemarks(boolean value) {
        this.isHideRemarks = value;
        return (B)this;
    }

    public final B noRoutineParameters() {
        return this.noRoutineParameters(true);
    }

    public final B noRoutineParameters(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hideRoutineParameters, value);
        return (B)this;
    }

    public final B noRoutines() {
        return this.noRoutines(true);
    }

    public final B noRoutines(boolean value) {
        this.hideDatabaseObjects.put(HideDatabaseObjectsType.hideRoutines, value);
        return (B)this;
    }

    public final B noRoutineSpecificNames() {
        return this.noRoutineSpecificNames(true);
    }

    public final B noRoutineSpecificNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideRoutineSpecificNames, value);
        return (B)this;
    }

    public final B noSchemas() {
        return this.noSchemas(true);
    }

    public final B noSchemas(boolean value) {
        this.hideDatabaseObjects.put(HideDatabaseObjectsType.hideSchemas, value);
        return (B)this;
    }

    public final B noSequences() {
        return this.noSequences(true);
    }

    public final B noSequences(boolean value) {
        this.hideDatabaseObjects.put(HideDatabaseObjectsType.hideSequences, value);
        return (B)this;
    }

    public final B noSynonyms() {
        return this.noSynonyms(true);
    }

    public final B noSynonyms(boolean value) {
        this.hideDatabaseObjects.put(HideDatabaseObjectsType.hideSynonyms, value);
        return (B)this;
    }

    public final B noTableColumns() {
        return this.noTableColumns(true);
    }

    public final B noTableColumns(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hideTableColumns, value);
        return (B)this;
    }

    public final B noTableConstraints() {
        return this.noTableConstraints(true);
    }

    public final B noTableConstraints(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hideTableConstraints, value);
        return (B)this;
    }

    public final B noTables() {
        return this.noTables(true);
    }

    public final B noTables(boolean value) {
        this.hideDatabaseObjects.put(HideDatabaseObjectsType.hideTables, value);
        return (B)this;
    }

    public final B noTriggerActionStatements() {
        return this.noTriggerActionStatements(true);
    }

    public final B noTriggerActionStatements(boolean value) {
        this.isHideTriggerActionStatements = value;
        return (B)this;
    }

    public final B noTriggerNames() {
        return this.noTriggerNames(true);
    }

    public final B noTriggerNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideTriggerNames, value);
        return (B)this;
    }

    public final B noTriggers() {
        return this.noTriggers(true);
    }

    public final B noTriggers(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hideTriggers, value);
        return (B)this;
    }

    public final B noWeakAssociationNames() {
        return this.noWeakAssociationNames(true);
    }

    public final B noWeakAssociationNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideWeakAssociationNames, value);
        return (B)this;
    }

    public final B noWeakAssociations() {
        return this.noWeakAssociations(true);
    }

    public final B noWeakAssociations(boolean value) {
        this.hideDependantDatabaseObjects.put(HideDependantDatabaseObjectsType.hideWeakAssociations, value);
        return (B)this;
    }

    public final B portable(PortableType value) {
        this.withPortableNames(false);
        this.withPortableBroad(false);
        if (value != null && value != PortableType.none) {
            this.withPortableNames(true);
            if (value == PortableType.broad) {
                this.withPortableBroad(true);
            }
        }
        return (B)this;
    }

    public final B showOrdinalNumbers() {
        return this.showOrdinalNumbers(true);
    }

    public final B showOrdinalNumbers(boolean value) {
        this.isShowOrdinalNumbers = value;
        return (B)this;
    }

    public final B showStandardColumnTypeNames() {
        return this.showStandardColumnTypeNames(true);
    }

    public final B showStandardColumnTypeNames(boolean value) {
        this.isShowStandardColumnTypeNames = value;
        return (B)this;
    }

    public final B sortForeignKeys() {
        return this.sortForeignKeys(true);
    }

    public final B sortForeignKeys(boolean value) {
        this.isAlphabeticalSortForForeignKeys = value;
        return (B)this;
    }

    public final B sortIndexes() {
        return this.sortIndexes(true);
    }

    public final B sortIndexes(boolean value) {
        this.isAlphabeticalSortForIndexes = value;
        return (B)this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        config.put(SHOW_STANDARD_COLUMN_TYPE_NAMES, (Object)this.isShowStandardColumnTypeNames);
        config.put(SHOW_ORDINAL_NUMBERS, (Object)this.isShowOrdinalNumbers);
        config.put(HIDE_TABLE_ROW_COUNTS, (Object)this.isHideTableRowCounts);
        config.put(HIDE_TRIGGER_ACTION_STATEMENTS, (Object)this.isHideTriggerActionStatements);
        config.put(HIDE_REMARKS, (Object)this.isHideRemarks);
        config.put(SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS, (Object)this.isAlphabeticalSortForForeignKeys);
        config.put(SC_SORT_ALPHABETICALLY_TABLE_INDEXES, (Object)this.isAlphabeticalSortForIndexes);
        for (HideDatabaseObjectsType hideDatabaseObjectsType : HideDatabaseObjectsType.values()) {
            config.put(hideDatabaseObjectsType.getKey(), (Object)this.hideDatabaseObjects.getOrDefault((Object)hideDatabaseObjectsType, false));
        }
        for (Enum enum_ : HideDependantDatabaseObjectsType.values()) {
            config.put(((HideDependantDatabaseObjectsType)enum_).getKey(), (Object)this.hideDependantDatabaseObjects.getOrDefault(enum_, false));
        }
        for (Enum enum_ : HideDatabaseObjectNamesType.values()) {
            config.put(((HideDatabaseObjectNamesType)enum_).getKey(), (Object)this.hideNames.getOrDefault(enum_, false));
        }
        return config;
    }

    private void fromConfigCommandLineOverride(Config config) {
        String noremarksKey = "no-remarks";
        if (config.containsKey("no-remarks")) {
            this.noRemarks(config.getBooleanValue("no-remarks"));
        }
        String portableKey = "portable";
        if (config.containsKey("portable")) {
            PortableType portableType = (PortableType)config.getEnumValue("portable", (Enum)PortableType.none);
            this.portable(portableType);
        }
    }

    private void withPortableBroad(boolean value) {
        this.isShowStandardColumnTypeNames = value;
        this.isHideTriggerActionStatements = value;
    }

    private void withPortableNames(boolean value) {
        for (HideDatabaseObjectNamesType databaseObjectNamesType : HideDatabaseObjectNamesType.values()) {
            this.hideNames.put(databaseObjectNamesType, value);
        }
        this.isShowUnqualifiedNames = value;
    }
}

