/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.ioresource.BaseInputResource;

public class ClasspathInputResource
extends BaseInputResource {
    private URL url;

    public ClasspathInputResource(String classpathResource) throws IOException {
        Objects.requireNonNull(classpathResource, "No classpath resource provided");
        this.url = IOUtility.locateResource(classpathResource);
        if (this.url == null) {
            IOException e = new IOException(String.format("Cannot read classpath resource, <%s>", classpathResource));
            throw e;
        }
    }

    @Override
    public InputStream openNewInputStream() throws IOException {
        InputStream inputStream = this.url.openStream();
        return inputStream;
    }

    public String toString() {
        return this.url.toExternalForm();
    }
}

