/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.graph;

import us.fatehi.utility.graph.Vertex;

public final class DirectedEdge<T> {
    private final Vertex<T> from;
    private final Vertex<T> to;

    DirectedEdge(Vertex<T> from, Vertex<T> to) {
        this.from = from;
        this.to = to;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectedEdge other = (DirectedEdge)obj;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.to == null) {
            return other.to == null;
        }
        return this.to.equals(other.to);
    }

    public Vertex<T> getFrom() {
        return this.from;
    }

    public Vertex<T> getTo() {
        return this.to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean isFrom(Vertex<T> vertex) {
        return vertex != null && vertex.equals(this.from);
    }

    public boolean isTo(Vertex<T> vertex) {
        return vertex != null && vertex.equals(this.to);
    }

    public String toString() {
        return this.from + " -> " + this.to;
    }
}

