/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.BindValue;
import com.mysql.cj.CancelQueryTask;
import com.mysql.cj.ClientPreparedQuery;
import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeQueryBindValue;
import com.mysql.cj.NativeQueryBindings;
import com.mysql.cj.NativeSession;
import com.mysql.cj.PlaceholderPurpose;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.Query;
import com.mysql.cj.QueryBindings;
import com.mysql.cj.QueryInfo;
import com.mysql.cj.QueryReturnType;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.FeatureNotAvailableException;
import com.mysql.cj.exceptions.StatementIsClosedException;
import com.mysql.cj.jdbc.CloseOption;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.JdbcPreparedStatement;
import com.mysql.cj.jdbc.MysqlParameterMetadata;
import com.mysql.cj.jdbc.MysqlSQLXML;
import com.mysql.cj.jdbc.ParameterBindings;
import com.mysql.cj.jdbc.ParameterBindingsImpl;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.exceptions.MySQLStatementCancelledException;
import com.mysql.cj.jdbc.exceptions.MySQLTimeoutException;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.result.ResultSetInternalMethods;
import com.mysql.cj.jdbc.result.ResultSetMetaData;
import com.mysql.cj.protocol.ColumnDefinition;
import com.mysql.cj.protocol.Message;
import com.mysql.cj.protocol.a.NativePacketPayload;
import com.mysql.cj.result.Field;
import com.mysql.cj.util.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class ClientPreparedStatement
extends StatementImpl
implements JdbcPreparedStatement {
    protected boolean batchHasPlainStatements = false;
    protected MysqlParameterMetadata parameterMetaData;
    private java.sql.ResultSetMetaData pstmtResultMetaData;
    protected String batchedValuesClause;
    private boolean doPingInstead;
    private boolean compensateForOnDuplicateKeyUpdate = false;
    protected int rewrittenBatchSize = 0;

    protected static ClientPreparedStatement getInstance(JdbcConnection conn, String sql, String db) throws SQLException {
        return new ClientPreparedStatement(conn, sql, db);
    }

    protected static ClientPreparedStatement getInstance(JdbcConnection conn, String sql, String db, QueryInfo cachedQueryInfo) throws SQLException {
        return new ClientPreparedStatement(conn, sql, db, cachedQueryInfo);
    }

    @Override
    protected void initQuery() {
        this.query = new ClientPreparedQuery(this.session);
    }

    protected ClientPreparedStatement(JdbcConnection conn, String db) throws SQLException {
        super(conn, db);
        this.setPoolable(true);
        this.compensateForOnDuplicateKeyUpdate = this.session.getPropertySet().getBooleanProperty(PropertyKey.compensateOnDuplicateKeyUpdateCounts).getValue();
    }

    public ClientPreparedStatement(JdbcConnection conn, String sql, String db) throws SQLException {
        this(conn, sql, db, null);
    }

    public ClientPreparedStatement(JdbcConnection conn, String sql, String db, QueryInfo cachedQueryInfo) throws SQLException {
        this(conn, db);
        try {
            ((PreparedQuery)this.query).checkNullOrEmptyQuery(sql);
            ((PreparedQuery)this.query).setOriginalSql(sql);
            ((PreparedQuery)this.query).setQueryInfo(cachedQueryInfo != null ? cachedQueryInfo : new QueryInfo(sql, this.session, this.charEncoding));
        }
        catch (CJException e) {
            throw SQLExceptionsMapping.translateException(e, this.exceptionInterceptor);
        }
        this.doPingInstead = sql.startsWith("/* ping */");
        this.initializeFromQueryInfo();
    }

    @Override
    public QueryBindings getQueryBindings() {
        return ((PreparedQuery)this.query).getQueryBindings();
    }

    public String toString() {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getClass().getName());
            buf.append(": ");
            buf.append(((PreparedQuery)this.query).asSql());
            return buf.toString();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                QueryBindings queryBindings = ((PreparedQuery)this.query).getQueryBindings();
                queryBindings.checkAllParametersSet();
                this.query.addBatch(queryBindings.clone());
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.batchHasPlainStatements = true;
                super.addBatch(sql);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.batchHasPlainStatements = false;
                super.clearBatch();
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                for (BindValue bv : ((PreparedQuery)this.query).getQueryBindings().getBindValues()) {
                    bv.reset();
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected boolean checkReadOnlySafeStatement() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                boolean bl = QueryInfo.isReadOnlySafeQuery(((PreparedQuery)this.query).getOriginalSql(), this.session.getServerSession().isNoBackslashEscapesSet()) || !this.connection.isReadOnly();
                return bl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean execute() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected long[] executeBatchInternal() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected long[] executePreparedBatchAsMultiStatement(long batchTimeout) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                long[] lArray;
                Statement batchedStatement;
                CancelQueryTask timeoutTask;
                boolean multiQueriesEnabled;
                JdbcConnection locallyScopedConn;
                block37: {
                    int numValuesPerBatch;
                    if (this.batchedValuesClause == null) {
                        this.batchedValuesClause = ((PreparedQuery)this.query).getOriginalSql() + ";";
                    }
                    locallyScopedConn = this.connection;
                    multiQueriesEnabled = locallyScopedConn.getPropertySet().getBooleanProperty(PropertyKey.allowMultiQueries).getValue();
                    timeoutTask = null;
                    this.clearWarnings();
                    int numBatchedArgs = this.query.getBatchedArgs().size();
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(numBatchedArgs);
                    }
                    if (numBatchedArgs < (numValuesPerBatch = ((PreparedQuery)this.query).computeBatchSize(numBatchedArgs))) {
                        numValuesPerBatch = numBatchedArgs;
                    }
                    batchedStatement = null;
                    int batchedParamIndex = 1;
                    int numberToExecuteAsMultiValue = 0;
                    int batchCounter = 0;
                    int updateCountCounter = 0;
                    long[] updateCounts = new long[numBatchedArgs * this.getQueryInfo().getNumberOfQueries()];
                    SQLException sqlEx = null;
                    try {
                        if (!multiQueriesEnabled) {
                            ((NativeSession)locallyScopedConn.getSession()).enableMultiQueries();
                        }
                        batchedStatement = this.retrieveGeneratedKeys ? locallyScopedConn.prepareStatement(this.generateMultiStatementForBatch(numValuesPerBatch), 1).unwrap(PreparedStatement.class) : locallyScopedConn.prepareStatement(this.generateMultiStatementForBatch(numValuesPerBatch)).unwrap(PreparedStatement.class);
                        timeoutTask = this.startQueryTimer((StatementImpl)batchedStatement, batchTimeout);
                        numberToExecuteAsMultiValue = numBatchedArgs < numValuesPerBatch ? numBatchedArgs : numBatchedArgs / numValuesPerBatch;
                        int numberArgsToExecute = numberToExecuteAsMultiValue * numValuesPerBatch;
                        for (int i = 0; i < numberArgsToExecute; ++i) {
                            if (i != 0 && i % numValuesPerBatch == 0) {
                                try {
                                    batchedStatement.execute();
                                }
                                catch (SQLException ex) {
                                    sqlEx = this.handleExceptionForBatch(batchCounter, numValuesPerBatch, updateCounts, ex);
                                }
                                updateCountCounter = this.processMultiCountsAndKeys((StatementImpl)batchedStatement, updateCountCounter, updateCounts);
                                batchedStatement.clearParameters();
                                batchedParamIndex = 1;
                            }
                            batchedParamIndex = this.setOneBatchedParameterSet((PreparedStatement)batchedStatement, batchedParamIndex, this.query.getBatchedArgs().get(batchCounter++));
                        }
                        try {
                            batchedStatement.execute();
                        }
                        catch (SQLException ex) {
                            sqlEx = this.handleExceptionForBatch(batchCounter - 1, numValuesPerBatch, updateCounts, ex);
                        }
                        updateCountCounter = this.processMultiCountsAndKeys((StatementImpl)batchedStatement, updateCountCounter, updateCounts);
                        batchedStatement.clearParameters();
                        numValuesPerBatch = numBatchedArgs - batchCounter;
                        if (timeoutTask != null) {
                            ((JdbcPreparedStatement)batchedStatement).checkCancelTimeout();
                        }
                    }
                    finally {
                        if (batchedStatement != null) {
                            batchedStatement.close();
                            batchedStatement = null;
                        }
                    }
                    if (numValuesPerBatch > 0) {
                        Statement statement = batchedStatement = this.retrieveGeneratedKeys ? locallyScopedConn.prepareStatement(this.generateMultiStatementForBatch(numValuesPerBatch), 1) : locallyScopedConn.prepareStatement(this.generateMultiStatementForBatch(numValuesPerBatch));
                        if (timeoutTask != null) {
                            timeoutTask.setQueryToCancel((Query)((Object)batchedStatement));
                        }
                        batchedParamIndex = 1;
                        while (batchCounter < numBatchedArgs) {
                            batchedParamIndex = this.setOneBatchedParameterSet((PreparedStatement)batchedStatement, batchedParamIndex, this.query.getBatchedArgs().get(batchCounter++));
                        }
                        try {
                            batchedStatement.execute();
                        }
                        catch (SQLException ex) {
                            sqlEx = this.handleExceptionForBatch(batchCounter - 1, numValuesPerBatch, updateCounts, ex);
                        }
                        updateCountCounter = this.processMultiCountsAndKeys((StatementImpl)batchedStatement, updateCountCounter, updateCounts);
                        batchedStatement.clearParameters();
                    }
                    if (timeoutTask != null) {
                        this.stopQueryTimer(timeoutTask, true, true);
                        timeoutTask = null;
                    }
                    if (sqlEx != null) {
                        throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.exceptionInterceptor);
                    }
                    lArray = updateCounts;
                    if (batchedStatement == null) break block37;
                    batchedStatement.close();
                }
                this.stopQueryTimer(timeoutTask, false, false);
                this.resetCancelledState();
                if (!multiQueriesEnabled) {
                    ((NativeSession)locallyScopedConn.getSession()).disableMultiQueries();
                }
                this.clearBatch();
                return lArray;
                {
                    catch (Throwable throwable) {
                        try {
                            if (batchedStatement != null) {
                                batchedStatement.close();
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            this.stopQueryTimer(timeoutTask, false, false);
                            this.resetCancelledState();
                            if (!multiQueriesEnabled) {
                                ((NativeSession)locallyScopedConn.getSession()).disableMultiQueries();
                            }
                            this.clearBatch();
                            throw throwable2;
                        }
                    }
                }
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected int setOneBatchedParameterSet(PreparedStatement batchedStatement, int batchedParamIndex, Object paramSet) throws SQLException {
        BindValue[] bindValues = ((QueryBindings)paramSet).getBindValues();
        QueryBindings batchedStatementBindings = ((PreparedQuery)((ClientPreparedStatement)batchedStatement).getQuery()).getQueryBindings();
        for (int j = 0; j < bindValues.length; ++j) {
            batchedStatementBindings.setFromBindValue(batchedParamIndex++ - 1, bindValues[j]);
        }
        return batchedParamIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateMultiStatementForBatch(int numBatches) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                String origSql = ((PreparedQuery)this.query).getOriginalSql();
                StringBuilder newStatementSql = new StringBuilder((origSql.length() + 1) * numBatches);
                newStatementSql.append(origSql);
                for (int i = 0; i < numBatches - 1; ++i) {
                    newStatementSql.append(';');
                    newStatementSql.append(origSql);
                }
                String string = newStatementSql.toString();
                return string;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected long[] executeBatchWithMultiValuesClause(long batchTimeout) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                long[] lArray;
                CancelQueryTask timeoutTask;
                ClientPreparedStatement batchedStatement;
                block34: {
                    int numValuesPerBatch;
                    JdbcConnection locallyScopedConn = this.connection;
                    int numBatchedArgs = this.query.getBatchedArgs().size();
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(numBatchedArgs);
                    }
                    if (numBatchedArgs < (numValuesPerBatch = ((PreparedQuery)this.query).computeBatchSize(numBatchedArgs))) {
                        numValuesPerBatch = numBatchedArgs;
                    }
                    batchedStatement = null;
                    int batchedParamIndex = 1;
                    long updateCountRunningTotal = 0L;
                    int numberToExecuteAsMultiValue = 0;
                    int batchCounter = 0;
                    timeoutTask = null;
                    SQLException sqlEx = null;
                    long[] updateCounts = new long[numBatchedArgs];
                    try {
                        batchedStatement = this.prepareBatchedInsertSQL(locallyScopedConn, numValuesPerBatch);
                        timeoutTask = this.startQueryTimer(batchedStatement, batchTimeout);
                        numberToExecuteAsMultiValue = numBatchedArgs < numValuesPerBatch ? numBatchedArgs : numBatchedArgs / numValuesPerBatch;
                        int numberArgsToExecute = numberToExecuteAsMultiValue * numValuesPerBatch;
                        for (int i = 0; i < numberArgsToExecute; ++i) {
                            if (i != 0 && i % numValuesPerBatch == 0) {
                                try {
                                    updateCountRunningTotal += batchedStatement.executeLargeUpdate();
                                }
                                catch (SQLException ex) {
                                    sqlEx = this.handleExceptionForBatch(batchCounter - 1, numValuesPerBatch, updateCounts, ex);
                                }
                                this.getBatchedGeneratedKeys(batchedStatement);
                                batchedStatement.clearParameters();
                                batchedParamIndex = 1;
                            }
                            batchedParamIndex = this.setOneBatchedParameterSet(batchedStatement, batchedParamIndex, this.query.getBatchedArgs().get(batchCounter++));
                        }
                        try {
                            updateCountRunningTotal += batchedStatement.executeLargeUpdate();
                        }
                        catch (SQLException ex) {
                            sqlEx = this.handleExceptionForBatch(batchCounter - 1, numValuesPerBatch, updateCounts, ex);
                        }
                        this.getBatchedGeneratedKeys(batchedStatement);
                        numValuesPerBatch = numBatchedArgs - batchCounter;
                    }
                    finally {
                        if (batchedStatement != null) {
                            batchedStatement.close();
                            batchedStatement = null;
                        }
                    }
                    if (numValuesPerBatch > 0) {
                        batchedStatement = this.prepareBatchedInsertSQL(locallyScopedConn, numValuesPerBatch);
                        if (timeoutTask != null) {
                            timeoutTask.setQueryToCancel(batchedStatement);
                        }
                        batchedParamIndex = 1;
                        while (batchCounter < numBatchedArgs) {
                            batchedParamIndex = this.setOneBatchedParameterSet(batchedStatement, batchedParamIndex, this.query.getBatchedArgs().get(batchCounter++));
                        }
                        try {
                            updateCountRunningTotal += batchedStatement.executeLargeUpdate();
                        }
                        catch (SQLException ex) {
                            sqlEx = this.handleExceptionForBatch(batchCounter - 1, numValuesPerBatch, updateCounts, ex);
                        }
                        this.getBatchedGeneratedKeys(batchedStatement);
                    }
                    if (sqlEx != null) {
                        throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.exceptionInterceptor);
                    }
                    if (numBatchedArgs > 1) {
                        long updCount = updateCountRunningTotal > 0L ? -2L : 0L;
                        for (int j = 0; j < numBatchedArgs; ++j) {
                            updateCounts[j] = updCount;
                        }
                    } else {
                        updateCounts[0] = updateCountRunningTotal;
                    }
                    lArray = updateCounts;
                    if (batchedStatement == null) break block34;
                    batchedStatement.close();
                }
                this.stopQueryTimer(timeoutTask, false, false);
                this.resetCancelledState();
                return lArray;
                {
                    catch (Throwable throwable) {
                        try {
                            if (batchedStatement != null) {
                                batchedStatement.close();
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            this.stopQueryTimer(timeoutTask, false, false);
                            this.resetCancelledState();
                            throw throwable2;
                        }
                    }
                }
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] executeBatchSerially(long batchTimeout) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (this.connection == null) {
                    this.checkClosed();
                }
                long[] updateCounts = null;
                if (this.query.getBatchedArgs() != null) {
                    int nbrCommands = this.query.getBatchedArgs().size();
                    updateCounts = new long[nbrCommands];
                    for (int i = 0; i < nbrCommands; ++i) {
                        updateCounts[i] = -3L;
                    }
                    SQLException sqlEx = null;
                    CancelQueryTask timeoutTask = null;
                    try {
                        timeoutTask = this.startQueryTimer(this, batchTimeout);
                        if (this.retrieveGeneratedKeys) {
                            this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                        }
                        int batchCommandIndex = ((PreparedQuery)this.query).getBatchCommandIndex();
                        for (batchCommandIndex = 0; batchCommandIndex < nbrCommands; ++batchCommandIndex) {
                            ((PreparedQuery)this.query).setBatchCommandIndex(batchCommandIndex);
                            Object arg = this.query.getBatchedArgs().get(batchCommandIndex);
                            try {
                                if (arg instanceof String) {
                                    updateCounts[batchCommandIndex] = this.executeUpdateInternal((String)arg, true, this.retrieveGeneratedKeys);
                                    this.getBatchedGeneratedKeys(this.results.getFirstCharOfQuery() == 'I' && this.containsOnDuplicateKeyInString((String)arg) ? 1 : 0);
                                    continue;
                                }
                                QueryBindings queryBindings = (QueryBindings)arg;
                                updateCounts[batchCommandIndex] = this.executeUpdateInternal(queryBindings, true);
                                this.getBatchedGeneratedKeys(this.containsOnDuplicateKeyUpdate() ? 1 : 0);
                                continue;
                            }
                            catch (SQLException ex) {
                                updateCounts[batchCommandIndex] = -3L;
                                if (this.continueBatchOnError && !(ex instanceof MySQLTimeoutException) && !(ex instanceof MySQLStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                                    sqlEx = ex;
                                    continue;
                                }
                                long[] newUpdateCounts = new long[batchCommandIndex];
                                System.arraycopy(updateCounts, 0, newUpdateCounts, 0, batchCommandIndex);
                                throw SQLError.createBatchUpdateException(ex, newUpdateCounts, this.exceptionInterceptor);
                            }
                        }
                        if (sqlEx != null) {
                            throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.exceptionInterceptor);
                        }
                    }
                    catch (NullPointerException npe) {
                        try {
                            this.checkClosed();
                        }
                        catch (StatementIsClosedException connectionClosedEx) {
                            int batchCommandIndex = ((PreparedQuery)this.query).getBatchCommandIndex();
                            updateCounts[batchCommandIndex] = -3L;
                            long[] newUpdateCounts = new long[batchCommandIndex];
                            System.arraycopy(updateCounts, 0, newUpdateCounts, 0, batchCommandIndex);
                            throw SQLError.createBatchUpdateException(SQLExceptionsMapping.translateException(connectionClosedEx), newUpdateCounts, this.exceptionInterceptor);
                        }
                        throw npe;
                    }
                    finally {
                        ((PreparedQuery)this.query).setBatchCommandIndex(-1);
                        this.stopQueryTimer(timeoutTask, false, false);
                        this.resetCancelledState();
                    }
                }
                long[] lArray = updateCounts != null ? updateCounts : new long[]{};
                return lArray;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <M extends Message> ResultSetInternalMethods executeInternal(int maxRowsToRetrieve, M sendPacket, boolean createStreamingResultSet, boolean queryIsSelectOnly, ColumnDefinition metadata, boolean isBatch) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ResultSetInternalMethods rs;
                JdbcConnection locallyScopedConnection = this.connection;
                ((PreparedQuery)this.query).getQueryBindings().setNumberOfExecutions(((PreparedQuery)this.query).getQueryBindings().getNumberOfExecutions() + 1);
                CancelQueryTask timeoutTask = null;
                try {
                    timeoutTask = this.startQueryTimer(this, this.getTimeoutInMillis());
                    if (!isBatch) {
                        this.statementBegins();
                    }
                    rs = (ResultSetInternalMethods)((NativeSession)locallyScopedConnection.getSession()).execSQL(this, null, maxRowsToRetrieve, (NativePacketPayload)sendPacket, createStreamingResultSet, this.getResultSetFactory(), metadata, isBatch);
                    if (timeoutTask != null) {
                        this.stopQueryTimer(timeoutTask, true, true);
                        timeoutTask = null;
                    }
                }
                finally {
                    if (!isBatch) {
                        this.query.getStatementExecuting().set(false);
                    }
                    this.stopQueryTimer(timeoutTask, false, false);
                }
                ResultSetInternalMethods resultSetInternalMethods = rs;
                return resultSetInternalMethods;
            }
            catch (NullPointerException npe) {
                this.checkClosed();
                throw npe;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long executeUpdateInternal(boolean clearBatchedGeneratedKeysAndWarnings, boolean isBatch) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (clearBatchedGeneratedKeysAndWarnings) {
                    this.clearWarnings();
                    this.batchedGeneratedKeys = null;
                }
                long l = this.executeUpdateInternal(((PreparedQuery)this.query).getQueryBindings(), isBatch);
                return l;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Exception decompiling
     */
    protected long executeUpdateInternal(QueryBindings bindings, boolean isReallyBatch) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean containsOnDuplicateKeyUpdate() {
        return this.getQueryInfo().containsOnDuplicateKeyUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientPreparedStatement prepareBatchedInsertSQL(JdbcConnection localConn, int numBatches) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ClientPreparedStatement pstmt = new ClientPreparedStatement(localConn, "Rewritten batch of: " + ((PreparedQuery)this.query).getOriginalSql(), this.getCurrentDatabase(), this.getQueryInfo().getQueryInfoForBatch(numBatches));
                pstmt.setRetrieveGeneratedKeys(this.retrieveGeneratedKeys);
                pstmt.rewrittenBatchSize = numBatches;
                this.getQueryAttributesBindings().runThroughAll(a -> pstmt.setAttribute(a.getName(), a.getValue()));
                ClientPreparedStatement clientPreparedStatement = pstmt;
                return clientPreparedStatement;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected void setRetrieveGeneratedKeys(boolean flag) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.retrieveGeneratedKeys = flag;
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytesRepresentation(int parameterIndex) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                byte[] byArray = ((PreparedQuery)this.query).getQueryBindings().getBytesRepresentation(this.getCoreParameterIndex(parameterIndex));
                return byArray;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (!this.isResultSetProducingQuery()) {
                    java.sql.ResultSetMetaData resultSetMetaData = null;
                    return resultSetMetaData;
                }
                Statement mdStmt = null;
                ResultSet mdRs = null;
                if (this.pstmtResultMetaData == null) {
                    try {
                        mdStmt = new ClientPreparedStatement(this.connection, ((PreparedQuery)this.query).getOriginalSql(), this.getCurrentDatabase(), this.getQueryInfo());
                        mdStmt.setMaxRows(1);
                        List<PlaceholderPurpose> placeholderPurposes = this.getQueryInfo().getPlaceholderPurposes();
                        for (int i = 0; i < this.getQueryInfo().getNumberOfPlaceholders(); ++i) {
                            mdStmt.setObject(i + 1, placeholderPurposes.get(i) == PlaceholderPurpose.LIMIT_AND_OFFSET ? Integer.valueOf(0) : null);
                        }
                        boolean hadResults = mdStmt.execute();
                        if (hadResults) {
                            mdRs = mdStmt.getResultSet();
                            this.pstmtResultMetaData = mdRs.getMetaData();
                        } else {
                            this.pstmtResultMetaData = new ResultSetMetaData(this.session, new Field[0], this.session.getPropertySet().getBooleanProperty(PropertyKey.useOldAliasMetadataBehavior).getValue(), this.session.getPropertySet().getBooleanProperty(PropertyKey.yearIsDateType).getValue(), this.exceptionInterceptor);
                        }
                    }
                    finally {
                        SQLException sqlExRethrow = null;
                        if (mdRs != null) {
                            try {
                                mdRs.close();
                            }
                            catch (SQLException sqlEx) {
                                sqlExRethrow = sqlEx;
                            }
                            mdRs = null;
                        }
                        if (mdStmt != null) {
                            try {
                                mdStmt.close();
                            }
                            catch (SQLException sqlEx) {
                                sqlExRethrow = sqlEx;
                            }
                            mdStmt = null;
                        }
                        if (sqlExRethrow != null) {
                            throw sqlExRethrow;
                        }
                    }
                }
                java.sql.ResultSetMetaData resultSetMetaData = this.pstmtResultMetaData;
                return resultSetMetaData;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected boolean isResultSetProducingQuery() {
        QueryReturnType queryReturnType = this.getQueryInfo().getQueryReturnType();
        return queryReturnType == QueryReturnType.PRODUCES_RESULT_SET || queryReturnType == QueryReturnType.MAY_PRODUCE_RESULT_SET;
    }

    private boolean isNonResultSetProducingQuery() {
        QueryReturnType queryReturnType = this.getQueryInfo().getQueryReturnType();
        return queryReturnType == QueryReturnType.DOES_NOT_PRODUCE_RESULT_SET || queryReturnType == QueryReturnType.MAY_PRODUCE_RESULT_SET;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (this.parameterMetaData == null) {
                    this.parameterMetaData = this.session.getPropertySet().getBooleanProperty(PropertyKey.generateSimpleParameterMetadata).getValue() != false ? new MysqlParameterMetadata(((PreparedQuery)this.query).getParameterCount()) : new MysqlParameterMetadata(this.session, null, ((PreparedQuery)this.query).getParameterCount(), this.exceptionInterceptor);
                }
                MysqlParameterMetadata mysqlParameterMetadata = this.parameterMetaData;
                return mysqlParameterMetadata;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public QueryInfo getQueryInfo() {
        return ((PreparedQuery)this.query).getQueryInfo();
    }

    private void initializeFromQueryInfo() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                int parameterCount = this.getQueryInfo().getNumberOfPlaceholders();
                ((PreparedQuery)this.query).setParameterCount(parameterCount);
                ((PreparedQuery)this.query).setQueryBindings(new NativeQueryBindings(parameterCount, this.session, NativeQueryBindValue::new));
                this.clearParameters();
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNull(int paramIndex) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                boolean bl = ((PreparedQuery)this.query).getQueryBindings().getBindValues()[this.getCoreParameterIndex(paramIndex)].isNull();
                return bl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose(CloseOption ... options) throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.connection;
            if (locallyScopedConn == null) {
                return;
            }
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                QueryBindings qb;
                if (this.isClosed) {
                    return;
                }
                if (this.useUsageAdvisor && ((qb = ((PreparedQuery)this.query).getQueryBindings()) == null || qb.getNumberOfExecutions() <= 1)) {
                    this.session.getProfilerEventHandler().processEvent((byte)0, this.session, this, null, 0L, new Throwable(), Messages.getString("PreparedStatement.43"));
                }
                super.doClose(options);
                ((PreparedQuery)this.query).setOriginalSql(null);
                ((PreparedQuery)this.query).setQueryBindings(null);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getPreparedSql() {
        Lock connectionLock = this.checkClosed().getConnectionLock();
        connectionLock.lock();
        try {
            if (this.rewrittenBatchSize == 0) {
                String string = ((PreparedQuery)this.query).getOriginalSql();
                return string;
            }
            String string = this.getQueryInfo().getSqlForBatch();
            return string;
        }
        finally {
            connectionLock.unlock();
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            int count = super.getUpdateCount();
            if (this.containsOnDuplicateKeyUpdate() && this.compensateForOnDuplicateKeyUpdate && (count == 2 || count == 0)) {
                count = 1;
            }
            return count;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        try {
            return this.executeUpdateInternal(true, false);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ParameterBindings getParameterBindings() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ParameterBindingsImpl parameterBindingsImpl = new ParameterBindingsImpl((PreparedQuery)this.query, this.session, this.resultSetFactory);
                return parameterBindingsImpl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected int getParameterIndexOffset() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkBounds(int paramIndex, int parameterIndexOffset) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (paramIndex < 1) {
                    throw SQLError.createSQLException(Messages.getString("PreparedStatement.49") + paramIndex + Messages.getString("PreparedStatement.50"), "S1009", this.exceptionInterceptor);
                }
                if (paramIndex > ((PreparedQuery)this.query).getParameterCount()) {
                    throw SQLError.createSQLException(Messages.getString("PreparedStatement.51") + paramIndex + Messages.getString("PreparedStatement.52") + ((PreparedQuery)this.query).getParameterCount() + Messages.getString("PreparedStatement.53"), "S1009", this.exceptionInterceptor);
                }
                if (parameterIndexOffset == -1 && paramIndex == 1) {
                    throw SQLError.createSQLException(Messages.getString("PreparedStatement.63"), "S1009", this.exceptionInterceptor);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public final int getCoreParameterIndex(int paramIndex) throws SQLException {
        int parameterIndexOffset = this.getParameterIndexOffset();
        this.checkBounds(paramIndex, parameterIndexOffset);
        return paramIndex - 1 + parameterIndexOffset;
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setAsciiStream(this.getCoreParameterIndex(parameterIndex), x, -1);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setAsciiStream(this.getCoreParameterIndex(parameterIndex), x, length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setAsciiStream(this.getCoreParameterIndex(parameterIndex), x, (int)length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBigDecimal(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBinaryStream(this.getCoreParameterIndex(parameterIndex), x, -1);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBinaryStream(this.getCoreParameterIndex(parameterIndex), x, length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBinaryStream(this.getCoreParameterIndex(parameterIndex), x, (int)length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBlob(this.getCoreParameterIndex(i), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBinaryStream(this.getCoreParameterIndex(parameterIndex), inputStream, -1);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBinaryStream(this.getCoreParameterIndex(parameterIndex), inputStream, (int)length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBoolean(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setByte(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setBytes(this.getCoreParameterIndex(parameterIndex), x, true);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int parameterIndex, byte[] x, boolean escapeIfNeeded) throws SQLException {
        Lock connectionLock = this.checkClosed().getConnectionLock();
        connectionLock.lock();
        try {
            ((PreparedQuery)this.query).getQueryBindings().setBytes(this.getCoreParameterIndex(parameterIndex), x, escapeIfNeeded);
        }
        finally {
            connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setCharacterStream(this.getCoreParameterIndex(parameterIndex), reader, -1);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setCharacterStream(this.getCoreParameterIndex(parameterIndex), reader, length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setCharacterStream(this.getCoreParameterIndex(parameterIndex), reader, (int)length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setCharacterStream(this.getCoreParameterIndex(parameterIndex), reader, -1);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setCharacterStream(this.getCoreParameterIndex(parameterIndex), reader, (int)length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int i, Clob x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setClob(this.getCoreParameterIndex(i), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setDate(this.getCoreParameterIndex(parameterIndex), x, null);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setDate(this.getCoreParameterIndex(parameterIndex), x, cal);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setDouble(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            ((PreparedQuery)this.query).getQueryBindings().setFloat(this.getCoreParameterIndex(parameterIndex), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setInt(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setLong(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigInteger(int parameterIndex, BigInteger x) throws SQLException {
        Lock connectionLock = this.checkClosed().getConnectionLock();
        connectionLock.lock();
        try {
            ((PreparedQuery)this.query).getQueryBindings().setBigInteger(this.getCoreParameterIndex(parameterIndex), x);
        }
        finally {
            connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setNCharacterStream(this.getCoreParameterIndex(parameterIndex), value, -1L);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setNCharacterStream(this.getCoreParameterIndex(parameterIndex), reader, length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setNCharacterStream(this.getCoreParameterIndex(parameterIndex), reader, -1L);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setNCharacterStream(this.getCoreParameterIndex(parameterIndex), reader, length);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setNClob(this.getCoreParameterIndex(parameterIndex), value);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setNString(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setNull(this.getCoreParameterIndex(parameterIndex));
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setNull(this.getCoreParameterIndex(parameterIndex));
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setNull(int parameterIndex, MysqlType mysqlType) throws SQLException {
        this.setNull(parameterIndex, mysqlType.getJdbcType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object parameterObj) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setObject(this.getCoreParameterIndex(parameterIndex), parameterObj);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                try {
                    ((PreparedQuery)this.query).getQueryBindings().setObject(this.getCoreParameterIndex(parameterIndex), parameterObj, MysqlType.getByJdbcType(targetSqlType), -1);
                }
                catch (FeatureNotAvailableException nae) {
                    throw SQLError.createSQLFeatureNotSupportedException(Messages.getString("Statement.UnsupportedSQLType") + JDBCType.valueOf(targetSqlType), "S1C00", this.exceptionInterceptor);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object parameterObj, SQLType targetSqlType) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (targetSqlType instanceof MysqlType) {
                    ((PreparedQuery)this.query).getQueryBindings().setObject(this.getCoreParameterIndex(parameterIndex), parameterObj, (MysqlType)targetSqlType, -1);
                } else {
                    this.setObject(parameterIndex, parameterObj, targetSqlType.getVendorTypeNumber());
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType, int scale) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                try {
                    ((PreparedQuery)this.query).getQueryBindings().setObject(this.getCoreParameterIndex(parameterIndex), parameterObj, MysqlType.getByJdbcType(targetSqlType), scale);
                }
                catch (FeatureNotAvailableException nae) {
                    throw SQLError.createSQLFeatureNotSupportedException(Messages.getString("Statement.UnsupportedSQLType") + JDBCType.valueOf(targetSqlType), "S1C00", this.exceptionInterceptor);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (targetSqlType instanceof MysqlType) {
                    ((PreparedQuery)this.query).getQueryBindings().setObject(this.getCoreParameterIndex(parameterIndex), x, (MysqlType)targetSqlType, scaleOrLength);
                } else {
                    this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber(), scaleOrLength);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setShort(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        try {
            if (xmlObject == null) {
                this.setNull(parameterIndex, MysqlType.VARCHAR);
            } else {
                this.setCharacterStream(parameterIndex, ((MysqlSQLXML)xmlObject).serializeAsCharacterStream());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setString(this.getCoreParameterIndex(parameterIndex), x);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setTime(this.getCoreParameterIndex(parameterIndex), x, null);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setTime(this.getCoreParameterIndex(parameterIndex), x, cal);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setTimestamp(this.getCoreParameterIndex(parameterIndex), x, null, null, MysqlType.TIMESTAMP);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ((PreparedQuery)this.query).getQueryBindings().setTimestamp(this.getCoreParameterIndex(parameterIndex), x, cal, null, MysqlType.TIMESTAMP);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.setBinaryStream(parameterIndex, x, length);
            ((PreparedQuery)this.query).getQueryBindings().getBindValues()[this.getCoreParameterIndex(parameterIndex)].setMysqlType(MysqlType.TEXT);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setURL(int parameterIndex, URL arg) throws SQLException {
        try {
            if (arg == null) {
                this.setNull(parameterIndex, MysqlType.VARCHAR);
            } else {
                this.setString(parameterIndex, arg.toString());
                ((PreparedQuery)this.query).getQueryBindings().getBindValues()[this.getCoreParameterIndex(parameterIndex)].setMysqlType(MysqlType.VARCHAR);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private static /* synthetic */ String lambda$executeUpdateInternal$11() {
        return Thread.currentThread().getName();
    }

    private static /* synthetic */ Long lambda$executeUpdateInternal$10() {
        return Thread.currentThread().getId();
    }

    private /* synthetic */ String lambda$executeUpdateInternal$9() {
        return this.connection.getUser();
    }

    private static /* synthetic */ String lambda$executeQuery$8() {
        return Thread.currentThread().getName();
    }

    private static /* synthetic */ Long lambda$executeQuery$7() {
        return Thread.currentThread().getId();
    }

    private /* synthetic */ String lambda$executeQuery$6() {
        return this.connection.getUser();
    }

    private static /* synthetic */ String lambda$executeBatchInternal$5() {
        return Thread.currentThread().getName();
    }

    private static /* synthetic */ Long lambda$executeBatchInternal$4() {
        return Thread.currentThread().getId();
    }

    private /* synthetic */ String lambda$executeBatchInternal$3() {
        return this.connection.getUser();
    }

    private static /* synthetic */ String lambda$execute$2() {
        return Thread.currentThread().getName();
    }

    private static /* synthetic */ Long lambda$execute$1() {
        return Thread.currentThread().getId();
    }

    private /* synthetic */ String lambda$execute$0() {
        return this.connection.getUser();
    }
}

