/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ClumpletReader;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.BlobConfig;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.gds.ng.wire.InlineBlob;
import org.firebirdsql.jaybird.props.DatabaseConnectionProperties;
import org.firebirdsql.jdbc.FBBlobInputStream;
import org.firebirdsql.jdbc.FBBlobOutputStream;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public final class FBBlob
implements FirebirdBlob,
TransactionListener {
    private static final Logger logger = LoggerFactory.getLogger(FBBlob.class);
    private boolean isNew;
    private long blobId;
    private volatile GDSHelper gdsHelper;
    private FBObjectListener.BlobListener blobListener;
    private final Config config;
    private final Collection<FBBlobInputStream> inputStreams = Collections.synchronizedSet(new HashSet());
    private FBBlobOutputStream blobOut;
    private InlineBlob cachedInlineBlob;

    private FBBlob(GDSHelper c, boolean isNew, FBObjectListener.BlobListener blobListener, Config config) {
        this.gdsHelper = c;
        this.isNew = isNew;
        this.blobListener = blobListener != null ? blobListener : FBObjectListener.NoActionBlobListener.instance();
        IConnectionProperties connectionProperties = c.getConnectionProperties();
        this.config = config != null ? config : FBBlob.createConfig(0, connectionProperties.isUseStreamBlobs(), connectionProperties.getBlobBufferSize(), c.getCurrentDatabase().getDatatypeCoder());
    }

    @Deprecated
    public FBBlob(GDSHelper c, FBObjectListener.BlobListener blobListener) {
        this(c, true, blobListener, null);
    }

    public FBBlob(GDSHelper c, FBObjectListener.BlobListener blobListener, Config config) {
        this(c, true, blobListener, config);
    }

    @Deprecated
    public FBBlob(GDSHelper c) {
        this(c, null);
    }

    @Deprecated
    public FBBlob(GDSHelper c, long blobId, FBObjectListener.BlobListener blobListener) {
        this(c, blobId, blobListener, null);
    }

    public FBBlob(GDSHelper c, long blobId, FBObjectListener.BlobListener blobListener, Config config) {
        this(c, false, blobListener, config);
        this.blobId = blobId;
    }

    @Deprecated
    public FBBlob(GDSHelper c, long blobId) {
        this(c, blobId, null);
    }

    Config config() {
        return this.config;
    }

    FbBlob openBlob() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkClosed();
            if (this.isNew) {
                throw new FBSQLException("No Blob ID is available in new Blob object");
            }
            if (this.cachedInlineBlob != null) {
                InlineBlob copy = this.cachedInlineBlob.copy();
                copy.open();
                InlineBlob inlineBlob = copy;
                return inlineBlob;
            }
            FbBlob blob = this.gdsHelper.openBlob(this.blobId, this.config);
            if (blob instanceof InlineBlob) {
                this.cachedInlineBlob = (InlineBlob)blob;
            }
            FbBlob fbBlob = blob;
            return fbBlob;
        }
    }

    FbBlob createBlob() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkClosed();
            FbBlob fbBlob = this.gdsHelper.createBlob(this.config);
            return fbBlob;
        }
    }

    LockCloseable withLock() {
        GDSHelper gdsHelper = this.gdsHelper;
        if (gdsHelper != null) {
            return gdsHelper.withLock();
        }
        return LockCloseable.NO_OP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                SQLExceptionChainBuilder<FBSQLException> chain = new SQLExceptionChainBuilder<FBSQLException>();
                for (FBBlobInputStream blobIS : new ArrayList<FBBlobInputStream>(this.inputStreams)) {
                    try {
                        blobIS.close();
                    }
                    catch (IOException ex) {
                        chain.append(new FBSQLException(ex));
                    }
                }
                this.inputStreams.clear();
                if (this.blobOut != null) {
                    try {
                        this.blobOut.close();
                    }
                    catch (IOException ex) {
                        chain.append(new FBSQLException(ex));
                    }
                }
                if (chain.hasException()) {
                    throw chain.getException();
                }
            }
            finally {
                this.gdsHelper = null;
                this.blobListener = FBObjectListener.NoActionBlobListener.instance();
                this.blobOut = null;
                this.cachedInlineBlob = null;
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new FBDriverNotCapableException("Method getBinaryStream(long, long) is not supported");
    }

    /*
     * Exception decompiling
     */
    public byte[] getInfo(byte[] items, int bufferLength) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long length() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isSegmented() throws SQLException {
        byte[] info = this.getInfo(new byte[]{7, 1}, 20);
        ClumpletReader clumpletReader = new ClumpletReader(ClumpletReader.Kind.InfoResponse, info);
        if (!clumpletReader.find(7)) {
            throw new SQLException("Cannot determine BLOB type", "HY000");
        }
        return clumpletReader.getInt() == 0;
    }

    @Override
    public FirebirdBlob detach() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkClosed();
            FBBlob fBBlob = new FBBlob(this.gdsHelper, this.blobId, this.blobListener, this.config);
            return fBBlob;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkClosed();
            FBBlobInputStream blobstream = new FBBlobInputStream(this);
            this.inputStreams.add(blobstream);
            FBBlobInputStream fBBlobInputStream = blobstream;
            return fBBlobInputStream;
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(byte[], long) is not supported");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(Blob, long) is not supported");
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new FBDriverNotCapableException("Method truncate(long) is not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkClosed();
            this.blobListener.executionStarted(this);
            if (this.blobOut != null) {
                throw new FBSQLException("OutputStream already open. Only one blob output stream can be open at a time.");
            }
            if (pos < 1L) {
                throw new FBSQLException("You can't start before the beginning of the blob", "HY009");
            }
            if (this.isNew && pos > 1L) {
                throw new FBSQLException("Previous value was null, you must start at position 1", "HY009");
            }
            this.blobOut = new FBBlobOutputStream(this);
            if (pos > 1L) {
                throw new FBDriverNotCapableException("Offset start positions are not yet supported.");
            }
            FBBlobOutputStream fBBlobOutputStream = this.blobOut;
            return fBBlobOutputStream;
        }
    }

    public long getBlobId() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.isNew) {
                throw new FBSQLException("No Blob ID is available in new Blob object");
            }
            long l = this.blobId;
            return l;
        }
    }

    void setBlobId(long blobId) {
        try (LockCloseable ignored = this.withLock();){
            FbTransaction currentTransaction;
            this.blobId = blobId;
            if (this.isNew && this.gdsHelper != null && (currentTransaction = this.gdsHelper.getCurrentTransaction()) != null) {
                currentTransaction.addWeakTransactionListener(this);
            }
            this.isNew = false;
        }
    }

    public void copyBytes(byte[] bytes, int pos, int len) throws SQLException {
        try (LockCloseable ignored = this.withLock();
             OutputStream out = this.setBinaryStream(1L);){
            out.write(bytes, pos, len);
        }
        catch (IOException ex) {
            throw new FBSQLException(ex);
        }
    }

    int getBufferLength() {
        return this.config.blobBufferSize();
    }

    void notifyClosed(FBBlobInputStream stream) {
        this.inputStreams.remove(stream);
    }

    boolean isNew() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.isNew;
            return bl;
        }
    }

    public void copyStream(InputStream inputStream, long length) throws SQLException {
        if (length == -1L) {
            this.copyStream(inputStream);
            return;
        }
        try (LockCloseable ignored = this.withLock();
             OutputStream os = this.setBinaryStream(1L);){
            int chunk;
            byte[] buffer = new byte[(int)Math.min((long)this.getBufferLength(), length)];
            while (length > 0L && (chunk = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, length))) != -1) {
                os.write(buffer, 0, chunk);
                length -= (long)chunk;
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    public void copyStream(InputStream inputStream) throws SQLException {
        try (LockCloseable ignored = this.withLock();
             OutputStream os = this.setBinaryStream(1L);){
            int chunk;
            byte[] buffer = new byte[this.getBufferLength()];
            while ((chunk = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, chunk);
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    public void copyCharacterStream(Reader reader, long length, Encoding encoding) throws SQLException {
        if (length == -1L) {
            this.copyCharacterStream(reader, encoding);
            return;
        }
        try (LockCloseable ignored = this.withLock();
             OutputStream os = this.setBinaryStream(1L);
             Writer osw = encoding.createWriter(os);){
            this.copyTo(reader, osw, length);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException("Cannot set character stream because the encoding '" + encoding + "' is unsupported in the JVM. Please report this to the driver developers.");
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    private void copyTo(Reader reader, Writer osw, long length) throws IOException {
        int chunk;
        char[] buffer = new char[(int)Math.min((long)this.getBufferLength(), length)];
        while (length > 0L && (chunk = reader.read(buffer, 0, (int)Math.min((long)buffer.length, length))) != -1) {
            osw.write(buffer, 0, chunk);
            length -= (long)chunk;
        }
    }

    public void copyCharacterStream(Reader reader, long length) throws SQLException {
        if (length == -1L) {
            this.copyCharacterStream(reader);
            return;
        }
        try (LockCloseable ignored = this.withLock();
             OutputStream os = this.setBinaryStream(1L);
             Writer osw = this.config.createWriter(os);){
            this.copyTo(reader, osw, length);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    public void copyCharacterStream(Reader reader, Encoding encoding) throws SQLException {
        try (LockCloseable ignored = this.withLock();
             OutputStream os = this.setBinaryStream(1L);
             Writer osw = encoding.createWriter(os);){
            this.copyTo(reader, osw);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException("Cannot set character stream because the encoding '" + encoding + "' is unsupported in the JVM. Please report this to the driver developers.");
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    private void copyTo(Reader reader, Writer osw) throws IOException {
        int chunk;
        char[] buffer = new char[this.getBufferLength()];
        while ((chunk = reader.read(buffer, 0, buffer.length)) != -1) {
            osw.write(buffer, 0, chunk);
        }
    }

    public void copyCharacterStream(Reader reader) throws SQLException {
        try (LockCloseable ignored = this.withLock();
             OutputStream os = this.setBinaryStream(1L);
             Writer osw = this.config.createWriter(os);){
            this.copyTo(reader, osw);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    @Override
    public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        if (newState == TransactionState.COMMITTED || newState == TransactionState.ROLLED_BACK) {
            try (LockCloseable ignored = this.withLock();){
                this.free();
            }
            catch (SQLException e) {
                logger.error("Error calling free on blob during transaction end", e);
            }
        }
    }

    private void checkClosed() throws SQLException {
        if (this.gdsHelper == null) {
            throw FbExceptionBuilder.forException(337248295).toSQLException();
        }
    }

    public static Config createConfig(FieldDescriptor fieldDescriptor, DatabaseConnectionProperties connectionProperties) {
        return FBBlob.createConfig(fieldDescriptor.getSubType(), connectionProperties.isUseStreamBlobs(), connectionProperties.getBlobBufferSize(), fieldDescriptor.getDatatypeCoder());
    }

    public static Config createConfig(int subType, DatabaseConnectionProperties connectionProperties, DatatypeCoder datatypeCoder) {
        return FBBlob.createConfig(subType, connectionProperties.isUseStreamBlobs(), connectionProperties.getBlobBufferSize(), datatypeCoder);
    }

    public static Config createConfig(int subType, boolean useStreamBlob, int blobBufferSize, DatatypeCoder datatypeCoder) {
        return new Config(subType, useStreamBlob, blobBufferSize, datatypeCoder);
    }

    public static final class Config
    implements BlobConfig {
        private final boolean streamBlob;
        private final int subType;
        private final int blobBufferSize;
        private final DatatypeCoder datatypeCoder;

        private Config(int subType, boolean streamBlob, int blobBufferSize, DatatypeCoder datatypeCoder) {
            this.streamBlob = streamBlob;
            this.subType = subType;
            this.blobBufferSize = blobBufferSize;
            this.datatypeCoder = Objects.requireNonNull(datatypeCoder, "datatypeCoder");
        }

        public int blobBufferSize() {
            return this.blobBufferSize;
        }

        public Reader createReader(InputStream inputStream) {
            return this.datatypeCoder.createReader(inputStream);
        }

        public Writer createWriter(OutputStream outputStream) {
            return this.datatypeCoder.createWriter(outputStream);
        }

        @Override
        public void writeOutputConfig(BlobParameterBuffer blobParameterBuffer) {
            blobParameterBuffer.addArgument(3, this.streamBlob ? 1 : 0);
            blobParameterBuffer.addArgument(1, this.subType);
            blobParameterBuffer.addArgument(2, this.subType);
            if (this.subType == 1) {
                int characterSetId = this.datatypeCoder.getEncodingDefinition().getFirebirdCharacterSetId();
                blobParameterBuffer.addArgument(4, characterSetId);
                blobParameterBuffer.addArgument(5, characterSetId);
            }
        }

        @Override
        public void writeInputConfig(BlobParameterBuffer blobParameterBuffer) {
        }
    }
}

