/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import org.firebirdsql.gds.ng.fields.FieldDescriptor;

public final class JdbcTypeConverter {
    private JdbcTypeConverter() {
    }

    public static int toJdbcType(FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.isDbKey()) {
            return -8;
        }
        return JdbcTypeConverter.fromFirebirdToJdbcType(fieldDescriptor.getType(), fieldDescriptor.getSubType(), fieldDescriptor.getScale());
    }

    public static boolean isJdbcType(FieldDescriptor fieldDescriptor, int jdbcType) {
        return JdbcTypeConverter.toJdbcType(fieldDescriptor) == jdbcType;
    }

    public static int fromFirebirdToJdbcType(int firebirdType, int subtype, int scale) {
        switch (firebirdType &= 0xFFFFFFFE) {
            case 480: 
            case 496: 
            case 500: 
            case 530: 
            case 580: 
            case 32752: {
                if (subtype == 1 || subtype == 0 && scale < 0) {
                    return 2;
                }
                if (subtype == 2) {
                    return 3;
                }
                switch (firebirdType) {
                    case 500: {
                        return 5;
                    }
                    case 496: {
                        return 4;
                    }
                    case 580: {
                        return -5;
                    }
                    case 480: 
                    case 530: {
                        return 8;
                    }
                    case 32752: {
                        return 2;
                    }
                }
            }
            case 482: {
                return 6;
            }
            case 32760: 
            case 32762: {
                return -6001;
            }
            case 452: {
                if (subtype == 1) {
                    return -2;
                }
                return 1;
            }
            case 448: {
                if (subtype == 1) {
                    return -3;
                }
                return 12;
            }
            case 510: {
                return 93;
            }
            case 560: {
                return 92;
            }
            case 570: {
                return 91;
            }
            case 32748: 
            case 32754: {
                return 2014;
            }
            case 32750: 
            case 32756: {
                return 2013;
            }
            case 520: {
                if (subtype < 0) {
                    return 2004;
                }
                if (subtype == 1) {
                    return -1;
                }
                return -4;
            }
            case 32764: {
                return 16;
            }
            case 32766: {
                return 0;
            }
            case 540: {
                return 2003;
            }
        }
        return 1111;
    }

    public static int fromMetaDataToJdbcType(int metaDataType, int subtype, int scale) {
        return JdbcTypeConverter.fromFirebirdToJdbcType(JdbcTypeConverter.fromMetaDataToFirebirdType(metaDataType), subtype, scale);
    }

    public static int fromMetaDataToFirebirdType(int metaDataType) {
        switch (metaDataType) {
            case 7: {
                return 500;
            }
            case 8: {
                return 496;
            }
            case 16: {
                return 580;
            }
            case 24: {
                return 32760;
            }
            case 25: {
                return 32762;
            }
            case 26: {
                return 32752;
            }
            case 9: {
                return 550;
            }
            case 10: {
                return 482;
            }
            case 27: {
                return 480;
            }
            case 11: {
                return 530;
            }
            case 12: {
                return 570;
            }
            case 13: {
                return 560;
            }
            case 35: {
                return 510;
            }
            case 28: {
                return 32756;
            }
            case 29: {
                return 32754;
            }
            case 30: {
                return 32750;
            }
            case 31: {
                return 32748;
            }
            case 14: {
                return 452;
            }
            case 37: 
            case 40: {
                return 448;
            }
            case 261: {
                return 520;
            }
            case 23: {
                return 32764;
            }
        }
        return 32766;
    }
}

