/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.tools.executable.commandline.PluginCommandOption;
import schemacrawler.tools.executable.commandline.PluginCommandType;
import us.fatehi.utility.Nullable;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.PropertyName;

public class PluginCommand
implements Iterable<PluginCommandOption> {
    private final PluginCommandType type;
    private final Supplier<String[]> helpDescription;
    private final String helpHeader;
    private final String name;
    private final Supplier<String[]> helpFooter;
    private final Collection<PluginCommandOption> options;

    public static PluginCommand empty() {
        return new PluginCommand(PluginCommandType.unknown, "unknown", null, null, null);
    }

    public static PluginCommand newCatalogLoaderCommand(PropertyName name) {
        return PluginCommand.newPluginCommand(PluginCommandType.loader, name.getName(), "** " + name.getDescription());
    }

    public static PluginCommand newDatabasePluginCommand(DatabaseServerType dbServerType) {
        return PluginCommand.newPluginCommand(PluginCommandType.server, dbServerType.getDatabaseSystemIdentifier(), "** Connect to " + Utility.trimToEmpty((String)dbServerType.getDatabaseSystemName()));
    }

    public static PluginCommand newPluginCommand(PropertyName name) {
        return PluginCommand.newPluginCommand(PluginCommandType.command, name.getName(), "** " + name.getDescription());
    }

    public static PluginCommand newPluginCommand(PropertyName name, @Nullable Supplier<String[]> helpDescription, @Nullable Supplier<String[]> helpFooter) {
        return new PluginCommand(PluginCommandType.command, name.getName(), "** " + name.getDescription(), helpDescription, helpFooter);
    }

    private static PluginCommand newPluginCommand(PluginCommandType pluginType, String name, String helpHeader) {
        return new PluginCommand(pluginType, name, helpHeader, null, null);
    }

    private PluginCommand(PluginCommandType type, String name, String helpHeader, @Nullable Supplier<String[]> helpDescription, @Nullable Supplier<String[]> helpFooter) {
        this.type = Objects.requireNonNull(type, "No plugin command type provided");
        this.options = new ArrayList<PluginCommandOption>();
        this.name = Utility.trimToEmpty((String)name);
        this.helpHeader = Utility.trimToEmpty((String)helpHeader);
        this.helpDescription = helpDescription;
        this.helpFooter = helpFooter;
    }

    public PluginCommand addOption(String name, Class<?> valueClass, String ... helpText) {
        PluginCommandOption option = new PluginCommandOption(name, valueClass, helpText);
        this.options.add(option);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginCommand)) {
            return false;
        }
        PluginCommand that = (PluginCommand)o;
        return Objects.equals(this.name, that.name);
    }

    public Supplier<String[]> getHelpDescription() {
        if (this.helpDescription == null) {
            return () -> new String[0];
        }
        return this.helpDescription;
    }

    public Supplier<String[]> getHelpFooter() {
        return this.addStandardFooter(this.type, this.helpFooter);
    }

    public String getHelpHeader() {
        return this.helpHeader;
    }

    public String getName() {
        return this.type.toPluginCommandName(this.name);
    }

    public Collection<PluginCommandOption> getOptions() {
        return new ArrayList<PluginCommandOption>(this.options);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean hasHelpDescription() {
        return this.helpDescription != null;
    }

    public boolean hasHelpFooter() {
        return this.helpFooter != null || this.type != PluginCommandType.unknown;
    }

    public boolean isEmpty() {
        return this.type == PluginCommandType.unknown && this.options.isEmpty();
    }

    @Override
    public Iterator<PluginCommandOption> iterator() {
        return this.options.iterator();
    }

    public String toString() {
        return new StringJoiner(", ", PluginCommand.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("options=" + this.options).toString();
    }

    private Supplier<String[]> addStandardFooter(PluginCommandType type, Supplier<String[]> helpFooter) {
        String[] helpFooterArray = helpFooter == null ? null : helpFooter.get();
        ArrayList<String> newFooter = new ArrayList<String>();
        if (helpFooterArray != null && helpFooterArray.length > 0) {
            newFooter.addAll(Arrays.asList(helpFooterArray));
        }
        switch (type) {
            case command: {
                newFooter.add("Add command options to the `execute` command in the SchemaCrawler Shell");
                break;
            }
            case loader: {
                newFooter.add("Add loader options to the `load` command in the SchemaCrawler Shell");
                break;
            }
            case server: {
                newFooter.add("Add connection options to the `connect` command in the SchemaCrawler Shell");
                break;
            }
        }
        String[] newFooterArray = newFooter.toArray(new String[0]);
        return () -> newFooterArray;
    }
}

