'''OpenGL extension SUN.triangle_list

This module customises the behaviour of the 
OpenGL.raw.GL.SUN.triangle_list to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL has two chained triangle primitives, TRIANGLE_STRIP and
	TRIANGLE_FAN.  For multiple, consecutive triangle strips or
	triangle fans, the overhead of Begin and End, or separate calls to
	DrawArrays, can be significant depending on the number of triangles
	per strip or fan.
	
	Many surface tessellators produce triangle strips with very few
	triangles per strip before needing to restart a new strip.  Even
	sophisticated tessellators typically need to restart a new strip,
	or switch from a triangle strip to a triangle fan, many times
	within a single object.  Such tessellators can often produce a more
	efficient tessellation--one with fewer vertices--by mixing strips
	and fans within the same object.  The ability to switch from one to
	the other without restarting the strip or fan yields even more
	savings.  Unfortunately, the overhead of switching from a triangle
	strip to a triangle fan, or vice versa, can reduce, or even
	eliminate the benefit gained from reducing the number of vertices.
	
	A new triangle list primitive, along with an associated replacement
	code attribute, is defined by this extension to allow multiple
	triangle strips and fans to be specified within the same Begin/End
	pair or from a single call to DrawArrays.  The triangle list
	extension also provides the means to switch between triangle strips
	and triangle fans with or without restarting the strip or fan.
	
	TRIANGLE_LIST is a new primitive type (i.e., new Begin mode) that
	uses the ReplacementCodeSUN state attribute to determine whether the
	current vertex replaces the oldest vertex, as in a triangle strip,
	the middle vertex, as in a triangle fan, or restarts a new chained
	triangle list.  The first vertex of a new triangle list is
	implicitly treated as a RESTART.  The first three vertices complete
	the first triangle, after which the replacement codes of the vertex
	are used.  The two vertices immediately following a
	restart--including the implicit restart on the first vertex--are
	ignored.  The ReplacementCodeSUN attribute is part of the vertex
	state, and is only used by the TRIANGLE_LIST primitive.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SUN/triangle_list.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.SUN.triangle_list import *
from OpenGL.raw.GL.SUN.triangle_list import _EXTENSION_NAME

def glInitTriangleListSUN():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glReplacementCodeuivSUN.code size not checked against ''
glReplacementCodeuivSUN=wrapper.wrapper(glReplacementCodeuivSUN).setInputArraySize(
    'code', None
)
# INPUT glReplacementCodeusvSUN.code size not checked against ''
glReplacementCodeusvSUN=wrapper.wrapper(glReplacementCodeusvSUN).setInputArraySize(
    'code', None
)
# INPUT glReplacementCodeubvSUN.code size not checked against ''
glReplacementCodeubvSUN=wrapper.wrapper(glReplacementCodeubvSUN).setInputArraySize(
    'code', None
)
# INPUT glReplacementCodePointerSUN.pointer size not checked against 'type,stride'
glReplacementCodePointerSUN=wrapper.wrapper(glReplacementCodePointerSUN).setInputArraySize(
    'pointer', None
)
### END AUTOGENERATED SECTION