/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.compress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.compress.Slot;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public class SlotSet
implements Iterable<Slot> {
    private final List<Slot> all = new ArrayList<Slot>();

    public SlotSet filter(double start, double end) {
        SlotSet result = new SlotSet();
        for (Slot slot : this.all) {
            Slot intersec = slot.intersect(start, end);
            if (intersec == null) continue;
            result.all.add(intersec);
        }
        return result;
    }

    public void addAll(SlotSet other) {
        this.all.addAll(other.all);
    }

    public void addSlot(double start, double end) {
        ArrayList<Slot> collisions = new ArrayList<Slot>();
        Slot newSlot = new Slot(start, end);
        Iterator<Slot> it = this.all.iterator();
        while (it.hasNext()) {
            Slot s2 = it.next();
            if (!s2.intersect(newSlot)) continue;
            it.remove();
            collisions.add(s2);
        }
        for (Slot s2 : collisions) {
            newSlot = newSlot.merge(s2);
        }
        this.all.add(newSlot);
    }

    public SlotSet smaller(double margin) {
        SlotSet result = new SlotSet();
        for (Slot sl : this.all) {
            if (sl.size() <= 2.0 * margin) continue;
            result.addSlot(sl.getStart() + margin, sl.getEnd() - margin);
        }
        return result;
    }

    public String toString() {
        return this.all.toString();
    }

    public List<Slot> getSlots() {
        return Collections.unmodifiableList(this.all);
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.getSlots().iterator();
    }

    public SlotSet reverse() {
        SlotSet result = new SlotSet();
        Collections.sort(this.all);
        Slot last = null;
        for (Slot slot : this.all) {
            if (last != null) {
                result.addSlot(last.getEnd(), slot.getStart());
            }
            last = slot;
        }
        return result;
    }

    public void drawDebugX(UGraphic ug, double size) {
        for (Slot slot : this.all) {
            URectangle rect = URectangle.build(slot.getEnd() - slot.getStart(), size);
            ug.apply(UTranslate.dx(slot.getStart())).draw(rect);
        }
    }
}

