/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemSingleLineFactory
extends PSystemAbstractFactory {
    protected abstract AbstractPSystem executeLine(UmlSource var1, String var2, PreprocessingArtifact var3);

    protected PSystemSingleLineFactory() {
        super(DiagramType.UML);
    }

    @Override
    public final Diagram createSystem(UmlSource source, Previous previous, PreprocessingArtifact preprocessing) {
        if (source.getTotalLineCount() != 3) {
            return null;
        }
        IteratorCounter2 it = source.iterator2();
        if (source.isEmpty()) {
            LineLocation location = ((StringLocated)it.next()).getLocation();
            return this.buildEmptyError(source, location, it.getTrace(), preprocessing);
        }
        StringLocated startLine = (StringLocated)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine.getString())) {
            throw new UnsupportedOperationException();
        }
        if (!it.hasNext()) {
            return this.buildEmptyError(source, startLine.getLocation(), it.getTrace(), preprocessing);
        }
        StringLocated s2 = (StringLocated)it.next();
        if (StartUtils.isArobaseEndDiagram(s2.getString())) {
            return this.buildEmptyError(source, s2.getLocation(), it.getTrace(), preprocessing);
        }
        AbstractPSystem sys = this.executeLine(source, s2.getString(), preprocessing);
        if (sys == null) {
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", 0, s2.getLocation(), this.getUmlDiagramType());
            return PSystemErrorUtils.buildV2(source, err, null, it.getTrace(), preprocessing);
        }
        return sys;
    }

    @Override
    public final UmlDiagramType getUmlDiagramType() {
        return null;
    }
}

