/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedKeyWrapOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SEEDEngine;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class SEED {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("SEED");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB128;
    public static final Parameters CFB8;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters GCM;
    public static final AuthParameters CCM;
    public static final AuthParameters OCB;
    public static final AuthParameters EAX;
    public static final AuthParameters CMAC;
    public static final AuthParameters GMAC;
    public static final WrapParameters KW;
    public static final WrapParameters KWP;

    private SEED() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        if (SEED.invalidKeySize(validatedSymmetricKey)) {
            throw new IllegalKeyException("SEED key must be of length 128");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(ValidatedSymmetricKey validatedSymmetricKey) {
        return validatedSymmetricKey.getKeySizeInBits() != 128;
    }

    static {
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        ENGINE_PROVIDER = engineProvider;
        ECB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB128 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB128));
        CFB8 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        OFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OFB128));
        CTR = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        GCM = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GCM));
        CCM = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CCM));
        OCB = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OCB));
        EAX = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.EAX));
        CMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        GMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GMAC));
        KW = new WrapParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        KWP = new WrapParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.WRAPPAD));
    }

    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        protected AEADBlockCipher createAEADCipher(boolean bl, SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardAEADCipher(bl, SEED.validateKey(symmetricKey, authParameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (AuthenticationParametersWithIV)authParameters);
        }
    }

    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            super(generalAlgorithm, 16, byArray, n);
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, Utils.getDefaultMacSize(generalAlgorithm, 128));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            return new AuthParameters(generalAlgorithm, byArray, n);
        }
    }

    private static final class EngineProvider
    implements org.bouncycastle.crypto.internal.EngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new SEEDEngine(), new VariantKatTest<SEEDEngine>(){

                @Override
                public void evaluate(SEEDEngine sEEDEngine) {
                    byte[] byArray = Hex.decode("00112233445566778899aabbccddeeff");
                    byte[] byArray2 = Hex.decode("af527210eb79c7a023abf348e70c9045");
                    byte[] byArray3 = new byte[byArray.length];
                    KeyParameterImpl keyParameterImpl = new KeyParameterImpl(Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f"));
                    sEEDEngine.init(true, keyParameterImpl);
                    sEEDEngine.processBlock(byArray, 0, byArray3, 0);
                    if (!Arrays.areEqual(byArray2, byArray3)) {
                        this.fail("Failed self test on encryption");
                    }
                    sEEDEngine.init(false, keyParameterImpl);
                    sEEDEngine.processBlock(byArray3, 0, byArray3, 0);
                    if (!Arrays.areEqual(byArray, byArray3)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom secureRandom) {
            this(ALGORITHM, secureRandom);
        }

        public KeyGenerator(GeneralParameters generalParameters, SecureRandom secureRandom) {
            this((GeneralAlgorithm)generalParameters.getAlgorithm(), secureRandom);
        }

        private KeyGenerator(GeneralAlgorithm generalAlgorithm, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            this.keySizeInBits = 128;
            this.random = secureRandom;
        }

        @Override
        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean bl, SymmetricKey symmetricKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardWrapper(bl, SEED.validateKey(symmetricKey, wrapParameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)wrapParameters, wrapParameters.useInverse, secureRandom);
        }
    }

    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardMac(SEED.validateKey(symmetricKey, authParameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (GeneralAuthParameters)authParameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return Utils.bitsToBytes(authParameters.macLenInBits);
        }
    }

    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean bl, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardCipher(bl, SEED.validateKey(symmetricKey, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, secureRandom);
        }
    }

    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            super(generalAlgorithm, 16, generalAlgorithm.checkIv(byArray, 16));
        }

        Parameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null);
        }

        @Override
        protected Parameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new Parameters(generalAlgorithm, byArray);
        }
    }

    public static final class WrapParameters
    extends GeneralParameters<GeneralAlgorithm>
    implements ParametersWithIV {
        private final byte[] iv;
        private final boolean useInverse;

        WrapParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, false);
        }

        private WrapParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, boolean bl) {
            super(generalAlgorithm);
            if (byArray != null) {
                ((Mode)generalAlgorithm.basicVariation()).checkIv(byArray, this.getIvLength());
            }
            this.iv = byArray;
            this.useInverse = bl;
        }

        public WrapParameters withUsingInverseFunction(boolean bl) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(this.iv), bl);
        }

        public WrapParameters withIV(byte[] byArray) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(byArray), this.useInverse);
        }

        public WrapParameters withIV(SecureRandom secureRandom) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(this.getIvLength(), secureRandom), this.useInverse);
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        private int getIvLength() {
            return ((GeneralAlgorithm)this.getAlgorithm()).equals(KW.getAlgorithm()) ? 8 : 4;
        }
    }
}

