/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.testutils;

import java.util.Random;

public class ShingledData {
    public static double[][] generateShingledData(int size, int period, int dimensions, long seed) {
        double[][] answer = new double[size][];
        int entryIndex = 0;
        boolean filledShingleAtleastOnce = false;
        double[] history = new double[dimensions];
        int count = 0;
        double[] data = ShingledData.getData(size + dimensions - 1, period, 100.0, 5.0, seed);
        for (int j = 0; j < size + dimensions - 1; ++j) {
            history[entryIndex] = data[j];
            if ((entryIndex = (entryIndex + 1) % dimensions) == 0) {
                filledShingleAtleastOnce = true;
            }
            if (!filledShingleAtleastOnce) continue;
            answer[count++] = ShingledData.getShinglePoint(history, entryIndex, dimensions);
        }
        return answer;
    }

    private static double[] getShinglePoint(double[] recentPointsSeen, int indexOfOldestPoint, int shingleLength) {
        double[] shingledPoint = new double[shingleLength];
        int i = 0;
        for (int j = 0; j < shingleLength; ++j) {
            double point = recentPointsSeen[(j + indexOfOldestPoint) % shingleLength];
            shingledPoint[i++] = point;
        }
        return shingledPoint;
    }

    private static double[] getData(int num, int period, double amplitude, double noise, long seed) {
        double[] data = new double[num];
        Random noiseprg = new Random(seed);
        for (int i = 0; i < num; ++i) {
            data[i] = amplitude * Math.cos(Math.PI * 2 * (double)(i + 50) / (double)period) + noise * noiseprg.nextDouble();
            if (!(noiseprg.nextDouble() < 0.01)) continue;
            double change = noiseprg.nextDouble() < 0.5 ? 10.0 * noise : -10.0 * noise;
            int n = i;
            data[n] = data[n] + change;
            System.out.println(" timestamp " + i + " changing by " + change);
        }
        return data;
    }
}

