/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.infotheory;

import com.oracle.labs.mlrg.olcut.util.MutableLong;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.util.infotheory.impl.CachedPair;
import org.tribuo.util.infotheory.impl.CachedTriple;
import org.tribuo.util.infotheory.impl.PairDistribution;
import org.tribuo.util.infotheory.impl.TripleDistribution;
import org.tribuo.util.infotheory.impl.WeightCountTuple;
import org.tribuo.util.infotheory.impl.WeightedPairDistribution;
import org.tribuo.util.infotheory.impl.WeightedTripleDistribution;

public final class WeightedInformationTheory {
    private static final Logger logger = Logger.getLogger(WeightedInformationTheory.class.getName());
    public static final double SAMPLES_RATIO = 5.0;
    public static final int DEFAULT_MAP_SIZE = 20;
    public static final double LOG_2 = Math.log(2.0);
    public static final double LOG_E = Math.log(Math.E);
    public static double LOG_BASE = LOG_2;

    private WeightedInformationTheory() {
    }

    public static <T1, T2, T3> double jointMI(List<T1> first, List<T2> second, List<T3> target, List<Double> weights) {
        WeightedTripleDistribution<T1, T2, T3> tripleRV = WeightedTripleDistribution.constructFromLists(first, second, target, weights);
        return WeightedInformationTheory.jointMI(tripleRV);
    }

    public static <T1, T2, T3> double jointMI(WeightedTripleDistribution<T1, T2, T3> tripleRV) {
        Map<CachedTriple<T1, T2, T3>, WeightCountTuple> jointCount = tripleRV.getJointCount();
        Map<CachedPair<T1, T2>, WeightCountTuple> abCount = tripleRV.getABCount();
        Map<T3, WeightCountTuple> cCount = tripleRV.getCCount();
        double vectorLength = tripleRV.count;
        double jmi = 0.0;
        for (Map.Entry<CachedTriple<T1, T2, T3>, WeightCountTuple> e : jointCount.entrySet()) {
            double jointCurCount = e.getValue().count;
            double jointCurWeight = e.getValue().weight;
            double prob = jointCurCount / vectorLength;
            CachedPair<T1, T2> pair = e.getKey().getAB();
            double abCurCount = abCount.get(pair).count;
            double cCurCount = cCount.get(e.getKey().getC()).count;
            jmi += jointCurWeight * prob * Math.log(vectorLength * jointCurCount / (abCurCount * cCurCount));
        }
        jmi /= LOG_BASE;
        double stateRatio = vectorLength / (double)jointCount.size();
        if (stateRatio < 5.0) {
            logger.log(Level.INFO, "Joint MI estimate of {0} had samples/state ratio of {1}", new Object[]{jmi, stateRatio});
        }
        return jmi;
    }

    public static <T1, T2, T3> double jointMI(TripleDistribution<T1, T2, T3> rv, Map<?, Double> weights, VariableSelector vs) {
        double vecLength = rv.count;
        Map<CachedTriple<T1, T2, T3>, MutableLong> jointCount = rv.getJointCount();
        Map<CachedPair<T1, T2>, MutableLong> abCount = rv.getABCount();
        Map<T3, MutableLong> cCount = rv.getCCount();
        double jmi = 0.0;
        for (Map.Entry<CachedTriple<T1, T2, T3>, MutableLong> e : jointCount.entrySet()) {
            double jointCurCount = e.getValue().doubleValue();
            double prob = jointCurCount / vecLength;
            CachedPair<T1, T2> pair = new CachedPair<T1, T2>(e.getKey().getA(), e.getKey().getB());
            double abCurCount = abCount.get(pair).doubleValue();
            double cCurCount = cCount.get(e.getKey().getC()).doubleValue();
            double weight = 1.0;
            switch (vs) {
                case FIRST: {
                    Double boxedWeight = weights.get(e.getKey().getA());
                    weight = boxedWeight == null ? 1.0 : boxedWeight;
                    break;
                }
                case SECOND: {
                    Double boxedWeight = weights.get(e.getKey().getB());
                    weight = boxedWeight == null ? 1.0 : boxedWeight;
                    break;
                }
                case THIRD: {
                    Double boxedWeight = weights.get(e.getKey().getC());
                    weight = boxedWeight == null ? 1.0 : boxedWeight;
                }
            }
            jmi += weight * prob * Math.log(vecLength * jointCurCount / (abCurCount * cCurCount));
        }
        jmi /= LOG_BASE;
        double stateRatio = vecLength / (double)jointCount.size();
        if (stateRatio < 5.0) {
            logger.log(Level.INFO, "Joint MI estimate of {0} had samples/state ratio of {1}, with {2} observations and {3} states", new Object[]{jmi, stateRatio, vecLength, jointCount.size()});
        }
        return jmi;
    }

    public static <T1, T2, T3> double conditionalMI(List<T1> first, List<T2> second, List<T3> condition, List<Double> weights) {
        if (first.size() == second.size() && first.size() == condition.size() && first.size() == weights.size()) {
            WeightedTripleDistribution<T1, T2, T3> tripleRV = WeightedTripleDistribution.constructFromLists(first, second, condition, weights);
            return WeightedInformationTheory.conditionalMI(tripleRV);
        }
        throw new IllegalArgumentException("Weighted Conditional Mutual Information requires four vectors the same length. first.size() = " + first.size() + ", second.size() = " + second.size() + ", condition.size() = " + condition.size() + ", weights.size() = " + weights.size());
    }

    public static <T1, T2, T3> double conditionalMI(WeightedTripleDistribution<T1, T2, T3> tripleRV) {
        Map<CachedTriple<T1, T2, T3>, WeightCountTuple> jointCount = tripleRV.getJointCount();
        Map<CachedPair<T1, T3>, WeightCountTuple> acCount = tripleRV.getACCount();
        Map<CachedPair<T2, T3>, WeightCountTuple> bcCount = tripleRV.getBCCount();
        Map<T3, WeightCountTuple> cCount = tripleRV.getCCount();
        double vectorLength = tripleRV.count;
        double cmi = 0.0;
        for (Map.Entry<CachedTriple<T1, T2, T3>, WeightCountTuple> e : jointCount.entrySet()) {
            double weight = e.getValue().weight;
            double jointCurCount = e.getValue().count;
            double prob = jointCurCount / vectorLength;
            CachedPair<T1, T3> acPair = e.getKey().getAC();
            CachedPair<T2, T3> bcPair = e.getKey().getBC();
            double acCurCount = acCount.get(acPair).count;
            double bcCurCount = bcCount.get(bcPair).count;
            double cCurCount = cCount.get(e.getKey().getC()).count;
            cmi += weight * prob * Math.log(cCurCount * jointCurCount / (acCurCount * bcCurCount));
        }
        cmi /= LOG_BASE;
        double stateRatio = vectorLength / (double)jointCount.size();
        if (stateRatio < 5.0) {
            logger.log(Level.INFO, "Conditional MI estimate of {0} had samples/state ratio of {1}", new Object[]{cmi, stateRatio});
        }
        return cmi;
    }

    public static <T1, T2, T3> double conditionalMI(TripleDistribution<T1, T2, T3> rv, Map<?, Double> weights, VariableSelector vs) {
        Map<CachedTriple<T1, T2, T3>, MutableLong> jointCount = rv.getJointCount();
        Map<CachedPair<T1, T3>, MutableLong> acCount = rv.getACCount();
        Map<CachedPair<T2, T3>, MutableLong> bcCount = rv.getBCCount();
        Map<T3, MutableLong> cCount = rv.getCCount();
        double vectorLength = rv.count;
        double cmi = 0.0;
        for (Map.Entry<CachedTriple<T1, T2, T3>, MutableLong> e : jointCount.entrySet()) {
            double jointCurCount = e.getValue().doubleValue();
            double prob = jointCurCount / vectorLength;
            CachedPair<T1, T3> acPair = new CachedPair<T1, T3>(e.getKey().getA(), e.getKey().getC());
            CachedPair<T2, T3> bcPair = new CachedPair<T2, T3>(e.getKey().getB(), e.getKey().getC());
            double acCurCount = acCount.get(acPair).doubleValue();
            double bcCurCount = bcCount.get(bcPair).doubleValue();
            double cCurCount = cCount.get(e.getKey().getC()).doubleValue();
            double weight = 1.0;
            switch (vs) {
                case FIRST: {
                    Double boxedWeight = weights.get(e.getKey().getA());
                    weight = boxedWeight == null ? 1.0 : boxedWeight;
                    break;
                }
                case SECOND: {
                    Double boxedWeight = weights.get(e.getKey().getB());
                    weight = boxedWeight == null ? 1.0 : boxedWeight;
                    break;
                }
                case THIRD: {
                    Double boxedWeight = weights.get(e.getKey().getC());
                    weight = boxedWeight == null ? 1.0 : boxedWeight;
                }
            }
            cmi += weight * prob * Math.log(cCurCount * jointCurCount / (acCurCount * bcCurCount));
        }
        cmi /= LOG_BASE;
        double stateRatio = vectorLength / (double)jointCount.size();
        if (stateRatio < 5.0) {
            logger.log(Level.INFO, "Conditional MI estimate of {0} had samples/state ratio of {1}", new Object[]{cmi, stateRatio});
        }
        return cmi;
    }

    public static <T1, T2> double mi(ArrayList<T1> first, ArrayList<T2> second, ArrayList<Double> weights) {
        if (first.size() == second.size() && first.size() == weights.size()) {
            WeightedPairDistribution<T1, T2> countPair = WeightedPairDistribution.constructFromLists(first, second, weights);
            return WeightedInformationTheory.mi(countPair);
        }
        throw new IllegalArgumentException("Weighted Mutual Information requires three vectors the same length. first.size() = " + first.size() + ", second.size() = " + second.size() + ", weights.size() = " + weights.size());
    }

    public static <T1, T2> double mi(WeightedPairDistribution<T1, T2> jointDist) {
        double vectorLength = jointDist.count;
        double mi = 0.0;
        Map<CachedPair<T1, T2>, WeightCountTuple> countDist = jointDist.getJointCounts();
        Map<T1, WeightCountTuple> firstCountDist = jointDist.getFirstCount();
        Map<T2, WeightCountTuple> secondCountDist = jointDist.getSecondCount();
        for (Map.Entry<CachedPair<T1, T2>, WeightCountTuple> e : countDist.entrySet()) {
            double weight = e.getValue().weight;
            double jointCount = e.getValue().count;
            double prob = jointCount / vectorLength;
            double firstCount = firstCountDist.get((Object)e.getKey().getA()).count;
            double secondCount = secondCountDist.get((Object)e.getKey().getB()).count;
            mi += weight * prob * Math.log(vectorLength * jointCount / (firstCount * secondCount));
        }
        mi /= LOG_BASE;
        double stateRatio = vectorLength / (double)countDist.size();
        if (stateRatio < 5.0) {
            logger.log(Level.INFO, "MI estimate of {0} had samples/state ratio of {1}", new Object[]{mi, stateRatio});
        }
        return mi;
    }

    public static <T1, T2> double mi(PairDistribution<T1, T2> pairDist, Map<?, Double> weights, VariableSelector vs) {
        if (vs == VariableSelector.THIRD) {
            throw new IllegalArgumentException("MI only has two variables");
        }
        Map countDist = pairDist.jointCounts;
        Map firstCountDist = pairDist.firstCount;
        Map secondCountDist = pairDist.secondCount;
        double vectorLength = pairDist.count;
        double mi = 0.0;
        boolean error = false;
        for (Map.Entry e : countDist.entrySet()) {
            double secondProb;
            double jointCount = e.getValue().doubleValue();
            double prob = jointCount / vectorLength;
            double top = vectorLength * jointCount;
            double firstProb = firstCountDist.get(e.getKey().getA()).doubleValue();
            double bottom = firstProb * (secondProb = secondCountDist.get(e.getKey().getB()).doubleValue());
            double ratio = top / bottom;
            double logRatio = Math.log(ratio);
            if (Double.isNaN(logRatio) || Double.isNaN(prob) || Double.isNaN(mi)) {
                logger.log(Level.WARNING, "State = " + e.getKey().toString());
                logger.log(Level.WARNING, "mi = " + mi + " prob = " + prob + " top = " + top + " bottom = " + bottom + " ratio = " + ratio + " logRatio = " + logRatio);
                error = true;
            }
            double weight = 1.0;
            switch (vs) {
                case FIRST: {
                    Double boxedWeight = weights.get(e.getKey().getA());
                    weight = boxedWeight == null ? 1.0 : boxedWeight;
                    break;
                }
                case SECOND: {
                    Double boxedWeight = weights.get(e.getKey().getB());
                    weight = boxedWeight == null ? 1.0 : boxedWeight;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("VariableSelector.THIRD not allowed in a two variable calculation.");
                }
            }
            mi += weight * prob * logRatio;
        }
        mi /= LOG_BASE;
        double stateRatio = vectorLength / (double)countDist.size();
        if (stateRatio < 5.0) {
            logger.log(Level.INFO, "MI estimate of {0} had samples/state ratio of {1}", new Object[]{mi, stateRatio});
        }
        if (error) {
            logger.log(Level.SEVERE, "NanFound ", new IllegalStateException("NaN found"));
        }
        return mi;
    }

    public static <T1, T2> double jointEntropy(ArrayList<T1> first, ArrayList<T2> second, ArrayList<Double> weights) {
        if (first.size() == second.size() && first.size() == weights.size()) {
            double vectorLength = first.size();
            double jointEntropy = 0.0;
            WeightedPairDistribution<T1, T2> pairDist = WeightedPairDistribution.constructFromLists(first, second, weights);
            Map<CachedPair<T1, T2>, WeightCountTuple> countDist = pairDist.getJointCounts();
            for (Map.Entry<CachedPair<T1, T2>, WeightCountTuple> e : countDist.entrySet()) {
                double prob = (double)e.getValue().count / vectorLength;
                double weight = e.getValue().weight;
                jointEntropy -= weight * prob * Math.log(prob);
            }
            jointEntropy /= LOG_BASE;
            double stateRatio = vectorLength / (double)countDist.size();
            if (stateRatio < 5.0) {
                logger.log(Level.INFO, "Weighted Joint Entropy estimate of {0} had samples/state ratio of {1}", new Object[]{jointEntropy, stateRatio});
            }
            return jointEntropy;
        }
        throw new IllegalArgumentException("Weighted Joint Entropy requires three vectors the same length. first.size() = " + first.size() + ", second.size() = " + second.size() + ", weights.size() = " + weights.size());
    }

    public static <T1, T2> double weightedConditionalEntropy(ArrayList<T1> vector, ArrayList<T2> condition, ArrayList<Double> weights) {
        if (vector.size() == condition.size() && vector.size() == weights.size()) {
            double vectorLength = vector.size();
            double condEntropy = 0.0;
            WeightedPairDistribution<T1, T2> pairDist = WeightedPairDistribution.constructFromLists(vector, condition, weights);
            Map<CachedPair<T1, T2>, WeightCountTuple> countDist = pairDist.getJointCounts();
            Map<T2, WeightCountTuple> conditionCountDist = pairDist.getSecondCount();
            for (Map.Entry<CachedPair<T1, T2>, WeightCountTuple> e : countDist.entrySet()) {
                double prob = (double)e.getValue().count / vectorLength;
                double condProb = (double)conditionCountDist.get((Object)e.getKey().getB()).count / vectorLength;
                double weight = e.getValue().weight;
                condEntropy -= weight * prob * Math.log(prob / condProb);
            }
            condEntropy /= LOG_BASE;
            double stateRatio = vectorLength / (double)countDist.size();
            if (stateRatio < 5.0) {
                logger.log(Level.INFO, "Weighted Conditional Entropy estimate of {0} had samples/state ratio of {1}", new Object[]{condEntropy, stateRatio});
            }
            return condEntropy;
        }
        throw new IllegalArgumentException("Weighted Conditional Entropy requires three vectors the same length. vector.size() = " + vector.size() + ", condition.size() = " + condition.size() + ", weights.size() = " + weights.size());
    }

    public static <T> double weightedEntropy(ArrayList<T> vector, ArrayList<Double> weights) {
        if (vector.size() == weights.size()) {
            double vectorLength = vector.size();
            double entropy = 0.0;
            Map<T, WeightCountTuple> countDist = WeightedInformationTheory.calculateWeightedCountDist(vector, weights);
            for (Map.Entry<T, WeightCountTuple> e : countDist.entrySet()) {
                long count = e.getValue().count;
                double weight = e.getValue().weight;
                double prob = (double)count / vectorLength;
                entropy -= weight * prob * Math.log(prob);
            }
            entropy /= LOG_BASE;
            double stateRatio = vectorLength / (double)countDist.size();
            if (stateRatio < 5.0) {
                logger.log(Level.INFO, "Weighted Entropy estimate of {0} had samples/state ratio of {1}", new Object[]{entropy, stateRatio});
            }
            return entropy;
        }
        throw new IllegalArgumentException("Weighted Entropy requires two vectors the same length. vector.size() = " + vector.size() + ",weights.size() = " + weights.size());
    }

    public static <T> Map<T, WeightCountTuple> calculateWeightedCountDist(ArrayList<T> vector, ArrayList<Double> weights) {
        LinkedHashMap<Object, WeightCountTuple> dist = new LinkedHashMap<Object, WeightCountTuple>(20);
        for (int i = 0; i < vector.size(); ++i) {
            T e = vector.get(i);
            Double weight = weights.get(i);
            WeightCountTuple curVal = dist.computeIfAbsent(e, k -> new WeightCountTuple());
            ++curVal.count;
            curVal.weight += weight.doubleValue();
        }
        WeightedInformationTheory.normaliseWeights(dist);
        return dist;
    }

    public static <T> void normaliseWeights(Map<T, WeightCountTuple> map) {
        for (Map.Entry<T, WeightCountTuple> e : map.entrySet()) {
            WeightCountTuple tuple = e.getValue();
            tuple.weight /= (double)tuple.count;
        }
    }

    public static enum VariableSelector {
        FIRST,
        SECOND,
        THIRD;

    }
}

