/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncementDirection;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncementState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayRouteTableAnnouncement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayRouteTableAnnouncement> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableAnnouncementId").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::transitGatewayRouteTableAnnouncementId)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::transitGatewayRouteTableAnnouncementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableAnnouncementId").unmarshallLocationName("transitGatewayRouteTableAnnouncementId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::transitGatewayId)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::coreNetworkId)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").unmarshallLocationName("coreNetworkId").build()}).build();
    private static final SdkField<String> PEER_TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerTransitGatewayId").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::peerTransitGatewayId)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::peerTransitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerTransitGatewayId").unmarshallLocationName("peerTransitGatewayId").build()}).build();
    private static final SdkField<String> PEER_CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerCoreNetworkId").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::peerCoreNetworkId)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::peerCoreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerCoreNetworkId").unmarshallLocationName("peerCoreNetworkId").build()}).build();
    private static final SdkField<String> PEERING_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeeringAttachmentId").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::peeringAttachmentId)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::peeringAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringAttachmentId").unmarshallLocationName("peeringAttachmentId").build()}).build();
    private static final SdkField<String> ANNOUNCEMENT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnnouncementDirection").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::announcementDirectionAsString)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::announcementDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnouncementDirection").unmarshallLocationName("announcementDirection").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableId").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::transitGatewayRouteTableId)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::transitGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId").unmarshallLocationName("transitGatewayRouteTableId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::stateAsString)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::creationTime)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TransitGatewayRouteTableAnnouncement.getter(TransitGatewayRouteTableAnnouncement::tags)).setter(TransitGatewayRouteTableAnnouncement.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, CORE_NETWORK_ID_FIELD, PEER_TRANSIT_GATEWAY_ID_FIELD, PEER_CORE_NETWORK_ID_FIELD, PEERING_ATTACHMENT_ID_FIELD, ANNOUNCEMENT_DIRECTION_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, STATE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayRouteTableAnnouncement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transitGatewayRouteTableAnnouncementId;
    private final String transitGatewayId;
    private final String coreNetworkId;
    private final String peerTransitGatewayId;
    private final String peerCoreNetworkId;
    private final String peeringAttachmentId;
    private final String announcementDirection;
    private final String transitGatewayRouteTableId;
    private final String state;
    private final Instant creationTime;
    private final List<Tag> tags;

    private TransitGatewayRouteTableAnnouncement(BuilderImpl builder) {
        this.transitGatewayRouteTableAnnouncementId = builder.transitGatewayRouteTableAnnouncementId;
        this.transitGatewayId = builder.transitGatewayId;
        this.coreNetworkId = builder.coreNetworkId;
        this.peerTransitGatewayId = builder.peerTransitGatewayId;
        this.peerCoreNetworkId = builder.peerCoreNetworkId;
        this.peeringAttachmentId = builder.peeringAttachmentId;
        this.announcementDirection = builder.announcementDirection;
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    public final String transitGatewayRouteTableAnnouncementId() {
        return this.transitGatewayRouteTableAnnouncementId;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String peerTransitGatewayId() {
        return this.peerTransitGatewayId;
    }

    public final String peerCoreNetworkId() {
        return this.peerCoreNetworkId;
    }

    public final String peeringAttachmentId() {
        return this.peeringAttachmentId;
    }

    public final TransitGatewayRouteTableAnnouncementDirection announcementDirection() {
        return TransitGatewayRouteTableAnnouncementDirection.fromValue(this.announcementDirection);
    }

    public final String announcementDirectionAsString() {
        return this.announcementDirection;
    }

    public final String transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    public final TransitGatewayRouteTableAnnouncementState state() {
        return TransitGatewayRouteTableAnnouncementState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableAnnouncementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerTransitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerCoreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.announcementDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRouteTableAnnouncement)) {
            return false;
        }
        TransitGatewayRouteTableAnnouncement other = (TransitGatewayRouteTableAnnouncement)obj;
        return Objects.equals(this.transitGatewayRouteTableAnnouncementId(), other.transitGatewayRouteTableAnnouncementId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.peerTransitGatewayId(), other.peerTransitGatewayId()) && Objects.equals(this.peerCoreNetworkId(), other.peerCoreNetworkId()) && Objects.equals(this.peeringAttachmentId(), other.peeringAttachmentId()) && Objects.equals(this.announcementDirectionAsString(), other.announcementDirectionAsString()) && Objects.equals(this.transitGatewayRouteTableId(), other.transitGatewayRouteTableId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayRouteTableAnnouncement").add("TransitGatewayRouteTableAnnouncementId", (Object)this.transitGatewayRouteTableAnnouncementId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("CoreNetworkId", (Object)this.coreNetworkId()).add("PeerTransitGatewayId", (Object)this.peerTransitGatewayId()).add("PeerCoreNetworkId", (Object)this.peerCoreNetworkId()).add("PeeringAttachmentId", (Object)this.peeringAttachmentId()).add("AnnouncementDirection", (Object)this.announcementDirectionAsString()).add("TransitGatewayRouteTableId", (Object)this.transitGatewayRouteTableId()).add("State", (Object)this.stateAsString()).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRouteTableAnnouncementId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableAnnouncementId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "PeerTransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.peerTransitGatewayId()));
            }
            case "PeerCoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.peerCoreNetworkId()));
            }
            case "PeeringAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.peeringAttachmentId()));
            }
            case "AnnouncementDirection": {
                return Optional.ofNullable(clazz.cast(this.announcementDirectionAsString()));
            }
            case "TransitGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayRouteTableAnnouncementId", TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("PeerTransitGatewayId", PEER_TRANSIT_GATEWAY_ID_FIELD);
        map.put("PeerCoreNetworkId", PEER_CORE_NETWORK_ID_FIELD);
        map.put("PeeringAttachmentId", PEERING_ATTACHMENT_ID_FIELD);
        map.put("AnnouncementDirection", ANNOUNCEMENT_DIRECTION_FIELD);
        map.put("TransitGatewayRouteTableId", TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRouteTableAnnouncement, T> g) {
        return obj -> g.apply((TransitGatewayRouteTableAnnouncement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayRouteTableAnnouncementId;
        private String transitGatewayId;
        private String coreNetworkId;
        private String peerTransitGatewayId;
        private String peerCoreNetworkId;
        private String peeringAttachmentId;
        private String announcementDirection;
        private String transitGatewayRouteTableId;
        private String state;
        private Instant creationTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRouteTableAnnouncement model) {
            this.transitGatewayRouteTableAnnouncementId(model.transitGatewayRouteTableAnnouncementId);
            this.transitGatewayId(model.transitGatewayId);
            this.coreNetworkId(model.coreNetworkId);
            this.peerTransitGatewayId(model.peerTransitGatewayId);
            this.peerCoreNetworkId(model.peerCoreNetworkId);
            this.peeringAttachmentId(model.peeringAttachmentId);
            this.announcementDirection(model.announcementDirection);
            this.transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            this.state(model.state);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
        }

        public final String getTransitGatewayRouteTableAnnouncementId() {
            return this.transitGatewayRouteTableAnnouncementId;
        }

        public final void setTransitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
        }

        @Override
        public final Builder transitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
            return this;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getPeerTransitGatewayId() {
            return this.peerTransitGatewayId;
        }

        public final void setPeerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
        }

        @Override
        public final Builder peerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
            return this;
        }

        public final String getPeerCoreNetworkId() {
            return this.peerCoreNetworkId;
        }

        public final void setPeerCoreNetworkId(String peerCoreNetworkId) {
            this.peerCoreNetworkId = peerCoreNetworkId;
        }

        @Override
        public final Builder peerCoreNetworkId(String peerCoreNetworkId) {
            this.peerCoreNetworkId = peerCoreNetworkId;
            return this;
        }

        public final String getPeeringAttachmentId() {
            return this.peeringAttachmentId;
        }

        public final void setPeeringAttachmentId(String peeringAttachmentId) {
            this.peeringAttachmentId = peeringAttachmentId;
        }

        @Override
        public final Builder peeringAttachmentId(String peeringAttachmentId) {
            this.peeringAttachmentId = peeringAttachmentId;
            return this;
        }

        public final String getAnnouncementDirection() {
            return this.announcementDirection;
        }

        public final void setAnnouncementDirection(String announcementDirection) {
            this.announcementDirection = announcementDirection;
        }

        @Override
        public final Builder announcementDirection(String announcementDirection) {
            this.announcementDirection = announcementDirection;
            return this;
        }

        @Override
        public final Builder announcementDirection(TransitGatewayRouteTableAnnouncementDirection announcementDirection) {
            this.announcementDirection(announcementDirection == null ? null : announcementDirection.toString());
            return this;
        }

        public final String getTransitGatewayRouteTableId() {
            return this.transitGatewayRouteTableId;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayRouteTableAnnouncementState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransitGatewayRouteTableAnnouncement build() {
            return new TransitGatewayRouteTableAnnouncement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayRouteTableAnnouncement> {
        public Builder transitGatewayRouteTableAnnouncementId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder coreNetworkId(String var1);

        public Builder peerTransitGatewayId(String var1);

        public Builder peerCoreNetworkId(String var1);

        public Builder peeringAttachmentId(String var1);

        public Builder announcementDirection(String var1);

        public Builder announcementDirection(TransitGatewayRouteTableAnnouncementDirection var1);

        public Builder transitGatewayRouteTableId(String var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayRouteTableAnnouncementState var1);

        public Builder creationTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

