/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.summarization;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class GenericMultiCenter<R>
implements ICluster<R> {
    public static int DEFAULT_NUMBER_OF_REPRESENTATIVES = 5;
    public static double DEFAULT_SHRINKAGE = 0.0;
    int numberOfRepresentatives = DEFAULT_NUMBER_OF_REPRESENTATIVES;
    double shrinkage = DEFAULT_SHRINKAGE;
    ArrayList<Weighted<R>> representatives = new ArrayList();
    double weight;
    double sumOfRadius;
    double previousWeight = 0.0;
    double previousSumOFRadius = 0.0;

    GenericMultiCenter(R coordinate, float weight, double shrinkage, int numberOfRepresentatives) {
        this.representatives.add(new Weighted<R>(coordinate, weight));
        this.weight = weight;
        this.numberOfRepresentatives = numberOfRepresentatives;
        this.shrinkage = shrinkage;
    }

    public static <R> GenericMultiCenter<R> initialize(R coordinate, float weight, double shrinkage, int numberOfRepresentatives) {
        CommonUtils.checkArgument(shrinkage >= 0.0 && shrinkage <= 1.0, " parameter has to be in [0,1]");
        CommonUtils.checkArgument(numberOfRepresentatives > 0 && numberOfRepresentatives <= 100, " the number of representatives has to be in (0,100]");
        return new GenericMultiCenter<R>(coordinate, weight, shrinkage, numberOfRepresentatives);
    }

    @Override
    public void addPoint(int index, float weight, double dist, R point, BiFunction<R, R, Double> distance) {
        Weighted<R> closest = this.representatives.get(0);
        if (this.representatives.size() > 1) {
            double newDist = distance.apply(point, this.representatives.get((int)0).index);
            for (int i = 1; i < this.representatives.size(); ++i) {
                double t = distance.apply(point, this.representatives.get((int)i).index);
                if (!(t < newDist)) continue;
                newDist = t;
                closest = this.representatives.get(i);
            }
        }
        closest.weight += weight;
        this.weight += (double)weight;
        this.sumOfRadius += (double)weight * dist;
    }

    @Override
    public void reset() {
        this.previousWeight = this.weight;
        this.weight = 0.0;
        for (int i = 0; i < this.representatives.size(); ++i) {
            this.representatives.get((int)i).weight = 0.0f;
        }
        this.previousSumOFRadius = this.sumOfRadius;
        this.sumOfRadius = 0.0;
    }

    @Override
    public double averageRadius() {
        return this.weight > 0.0 ? this.sumOfRadius / this.weight : 0.0;
    }

    @Override
    public double extentMeasure() {
        return this.weight > 0.0 ? 0.5 * this.sumOfRadius / ((double)this.numberOfRepresentatives * this.weight) : 0.0;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public double recompute(Function<Integer, R> getPoint, boolean flag, BiFunction<R, R, Double> distanceFunction) {
        return 0.0;
    }

    @Override
    public void absorb(ICluster<R> other, BiFunction<R, R, Double> distance) {
        ArrayList<Weighted<R>> savedRepresentatives = this.representatives;
        savedRepresentatives.addAll(other.getRepresentatives());
        this.representatives = new ArrayList();
        int maxIndex = 0;
        float weight = ((Weighted)savedRepresentatives.get((int)0)).weight;
        for (int i = 1; i < savedRepresentatives.size(); ++i) {
            if (!(weight < ((Weighted)savedRepresentatives.get((int)i)).weight)) continue;
            weight = ((Weighted)savedRepresentatives.get((int)i)).weight;
            maxIndex = i;
        }
        this.representatives.add((Weighted)savedRepresentatives.get(maxIndex));
        savedRepresentatives.remove(maxIndex);
        this.sumOfRadius += other.extentMeasure() * other.getWeight();
        this.weight += other.getWeight();
        while (savedRepresentatives.size() > 0 && this.representatives.size() < this.numberOfRepresentatives) {
            double farthestWeightedDistance = 0.0;
            int farthestIndex = Integer.MAX_VALUE;
            for (int j = 0; j < savedRepresentatives.size(); ++j) {
                if (!(((Weighted)savedRepresentatives.get((int)j)).weight > weight / (float)(2 * this.numberOfRepresentatives))) continue;
                double newWeightedDist = distance.apply(this.representatives.get((int)0).index, ((Weighted)savedRepresentatives.get((int)j)).index) * (double)((Weighted)savedRepresentatives.get((int)j)).weight;
                CommonUtils.checkArgument(newWeightedDist >= 0.0, " weights or distances cannot be negative");
                for (int i = 1; i < this.representatives.size(); ++i) {
                    CommonUtils.checkArgument((newWeightedDist = Math.min(newWeightedDist, distance.apply(this.representatives.get((int)i).index, ((Weighted)savedRepresentatives.get((int)j)).index)) * (double)((Weighted)savedRepresentatives.get((int)j)).weight) >= 0.0, " weights or distances cannot be negative");
                }
                if (!(newWeightedDist > farthestWeightedDistance)) continue;
                farthestWeightedDistance = newWeightedDist;
                farthestIndex = j;
            }
            if (farthestWeightedDistance == 0.0) break;
            this.representatives.add((Weighted)savedRepresentatives.get(farthestIndex));
            savedRepresentatives.remove(farthestIndex);
        }
        for (Weighted weighted : savedRepresentatives) {
            double dist = distance.apply(weighted.index, this.representatives.get((int)0).index);
            CommonUtils.checkArgument(dist >= 0.0, "distance cannot be negative");
            double minDist = dist;
            int minIndex = 0;
            for (int i = 1; i < this.representatives.size(); ++i) {
                double newDist = distance.apply(this.representatives.get((int)i).index, weighted.index);
                CommonUtils.checkArgument(newDist >= 0.0, "distance cannot be negative");
                if (!(newDist < minDist)) continue;
                minDist = newDist;
                minIndex = i;
            }
            this.representatives.get((int)minIndex).weight += weighted.weight;
            this.sumOfRadius += (double)weighted.weight * ((1.0 - this.shrinkage) * minDist + dist * this.shrinkage);
        }
    }

    @Override
    public double distance(R point, BiFunction<R, R, Double> distanceFunction) {
        double dist = distanceFunction.apply(this.representatives.get((int)0).index, point);
        CommonUtils.checkArgument(dist >= 0.0, "distance cannot be negative");
        double newDist = dist;
        for (int i = 1; i < this.representatives.size(); ++i) {
            CommonUtils.checkArgument((newDist = Math.min(newDist, distanceFunction.apply(this.representatives.get((int)i).index, point))) >= 0.0, "distance cannot be negative");
        }
        return (1.0 - this.shrinkage) * newDist + this.shrinkage * dist;
    }

    @Override
    public double distance(ICluster<R> other, BiFunction<R, R, Double> distanceFunction) {
        List<Weighted<R>> representatives = other.getRepresentatives();
        double dist = distanceFunction.apply(this.representatives.get((int)0).index, representatives.get((int)0).index);
        CommonUtils.checkArgument(dist >= 0.0, "distance cannot be negative");
        double newDist = dist;
        for (int i = 1; i < this.representatives.size(); ++i) {
            for (int j = 1; j < representatives.size(); ++j) {
                CommonUtils.checkArgument((newDist = Math.min(newDist, distanceFunction.apply(this.representatives.get((int)i).index, representatives.get((int)j).index))) >= 0.0, "distance cannot be negative");
            }
        }
        return (1.0 - this.shrinkage) * newDist + this.shrinkage * dist;
    }

    @Override
    public List<Weighted<R>> getRepresentatives() {
        return this.representatives;
    }
}

