/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.dataprocessor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.dataprocessor.ImputationMethod;

public class ImputationOption
implements Writeable,
ToXContent {
    public static final String METHOD_FIELD = "method";
    public static final String DEFAULT_FILL_FIELD = "default_fill";
    private final ImputationMethod method;
    private final Map<String, Double> defaultFill;

    public ImputationOption(ImputationMethod method, Map<String, Double> defaultFill) {
        this.method = method;
        this.defaultFill = defaultFill;
    }

    public ImputationOption(ImputationMethod method) {
        this(method, null);
    }

    public ImputationOption(StreamInput in) throws IOException {
        this.method = (ImputationMethod)in.readEnum(ImputationMethod.class);
        this.defaultFill = in.readBoolean() ? in.readMap(StreamInput::readString, StreamInput::readDouble) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.method);
        if (this.defaultFill == null || this.defaultFill.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.defaultFill, StreamOutput::writeString, StreamOutput::writeDouble);
        }
    }

    public static ImputationOption parse(XContentParser parser) throws IOException {
        ImputationMethod method = ImputationMethod.ZERO;
        HashMap<String, Double> defaultFill = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "method": {
                    method = ImputationMethod.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "default_fill": {
                    defaultFill = new HashMap<String, Double>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        String featureName = null;
                        Double fillValue = null;
                        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            String fillFieldName = parser.currentName();
                            parser.nextToken();
                            switch (fillFieldName) {
                                case "feature_name": {
                                    featureName = parser.text();
                                    continue block18;
                                }
                                case "data": {
                                    fillValue = parser.doubleValue();
                                    continue block18;
                                }
                            }
                            parser.skipChildren();
                        }
                        defaultFill.put(featureName, fillValue);
                    }
                    break;
                }
            }
        }
        return new ImputationOption(method, defaultFill);
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        builder.field(METHOD_FIELD, (Object)this.method);
        if (this.defaultFill != null && !this.defaultFill.isEmpty()) {
            builder.startArray(DEFAULT_FILL_FIELD);
            for (Map.Entry<String, Double> fill : this.defaultFill.entrySet()) {
                builder.startObject();
                builder.field("feature_name", fill.getKey());
                builder.field("data", fill.getValue());
                builder.endObject();
            }
            builder.endArray();
        }
        return xContentBuilder.endObject();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImputationOption other = (ImputationOption)o;
        return this.method == other.method && Objects.equals(this.defaultFill, other.defaultFill);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.defaultFill});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(METHOD_FIELD, (Object)this.method).append(DEFAULT_FILL_FIELD, this.defaultFill).toString();
    }

    public ImputationMethod getMethod() {
        return this.method;
    }

    public Map<String, Double> getDefaultFill() {
        return this.defaultFill;
    }
}

