/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.WorkloadGroup;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.monitor.jvm.JvmStats;
import org.opensearch.monitor.process.ProcessProbe;
import org.opensearch.search.backpressure.trackers.NodeDuressTrackers;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskResourceTrackingService;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.wlm.MutableWorkloadGroupFragment;
import org.opensearch.wlm.ResourceType;
import org.opensearch.wlm.WlmMode;
import org.opensearch.wlm.WorkloadGroupTask;
import org.opensearch.wlm.WorkloadGroupsStateAccessor;
import org.opensearch.wlm.WorkloadManagementSettings;
import org.opensearch.wlm.cancellation.WorkloadGroupTaskCancellationService;
import org.opensearch.wlm.stats.WorkloadGroupState;
import org.opensearch.wlm.stats.WorkloadGroupStats;
import org.opensearch.wlm.tracker.WorkloadGroupResourceUsageTrackerService;

public class WorkloadGroupService
extends AbstractLifecycleComponent
implements ClusterStateListener,
TaskResourceTrackingService.TaskCompletionListener {
    private static final Logger logger = LogManager.getLogger(WorkloadGroupService.class);
    private final WorkloadGroupTaskCancellationService taskCancellationService;
    private volatile Scheduler.Cancellable scheduledFuture;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final WorkloadManagementSettings workloadManagementSettings;
    private Set<WorkloadGroup> activeWorkloadGroups;
    private final Set<WorkloadGroup> deletedWorkloadGroups;
    private final NodeDuressTrackers nodeDuressTrackers;
    private final WorkloadGroupsStateAccessor workloadGroupsStateAccessor;

    public WorkloadGroupService(WorkloadGroupTaskCancellationService taskCancellationService, ClusterService clusterService, ThreadPool threadPool, WorkloadManagementSettings workloadManagementSettings, WorkloadGroupsStateAccessor workloadGroupsStateAccessor) {
        this(taskCancellationService, clusterService, threadPool, workloadManagementSettings, new NodeDuressTrackers(Map.of(ResourceType.CPU, new NodeDuressTrackers.NodeDuressTracker(() -> workloadManagementSettings.getNodeLevelCpuCancellationThreshold() < (double)ProcessProbe.getInstance().getProcessCpuPercent() / 100.0, workloadManagementSettings::getDuressStreak), ResourceType.MEMORY, new NodeDuressTrackers.NodeDuressTracker(() -> workloadManagementSettings.getNodeLevelMemoryCancellationThreshold() <= (double)JvmStats.jvmStats().getMem().getHeapUsedPercent() / 100.0, workloadManagementSettings::getDuressStreak))), workloadGroupsStateAccessor, new HashSet<WorkloadGroup>(), new HashSet<WorkloadGroup>());
    }

    public WorkloadGroupService(WorkloadGroupTaskCancellationService taskCancellationService, ClusterService clusterService, ThreadPool threadPool, WorkloadManagementSettings workloadManagementSettings, NodeDuressTrackers nodeDuressTrackers, WorkloadGroupsStateAccessor workloadGroupsStateAccessor, Set<WorkloadGroup> activeWorkloadGroups, Set<WorkloadGroup> deletedWorkloadGroups) {
        this.taskCancellationService = taskCancellationService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.workloadManagementSettings = workloadManagementSettings;
        this.nodeDuressTrackers = nodeDuressTrackers;
        this.activeWorkloadGroups = activeWorkloadGroups;
        this.deletedWorkloadGroups = deletedWorkloadGroups;
        this.workloadGroupsStateAccessor = workloadGroupsStateAccessor;
        activeWorkloadGroups.forEach(workloadGroup -> this.workloadGroupsStateAccessor.addNewWorkloadGroup(workloadGroup.get_id()));
        this.workloadGroupsStateAccessor.addNewWorkloadGroup(WorkloadGroupTask.DEFAULT_WORKLOAD_GROUP_ID_SUPPLIER.get());
        this.clusterService.addListener(this);
    }

    void doRun() {
        if (this.workloadManagementSettings.getWlmMode() == WlmMode.DISABLED) {
            return;
        }
        this.taskCancellationService.cancelTasks(this.nodeDuressTrackers::isNodeInDuress, this.activeWorkloadGroups, this.deletedWorkloadGroups);
        this.taskCancellationService.pruneDeletedWorkloadGroups(this.deletedWorkloadGroups);
    }

    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                this.doRun();
            }
            catch (Exception e) {
                logger.debug("Exception occurred in Query Sandbox service", (Throwable)e);
            }
        }, this.workloadManagementSettings.getWorkloadGroupServiceRunInterval(), "generic");
    }

    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    protected void doClose() throws IOException {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        Metadata previousMetadata = event.previousState().metadata();
        Metadata currentMetadata = event.state().metadata();
        Map<String, WorkloadGroup> previousWorkloadGroups = previousMetadata.workloadGroups();
        Map<String, WorkloadGroup> currentWorkloadGroups = currentMetadata.workloadGroups();
        for (String workloadGroupName : currentWorkloadGroups.keySet()) {
            if (previousWorkloadGroups.containsKey(workloadGroupName)) continue;
            WorkloadGroup newWorkloadGroup = currentWorkloadGroups.get(workloadGroupName);
            this.workloadGroupsStateAccessor.addNewWorkloadGroup(newWorkloadGroup.get_id());
        }
        for (String workloadGroupName : previousWorkloadGroups.keySet()) {
            if (currentWorkloadGroups.containsKey(workloadGroupName)) continue;
            WorkloadGroup deletedWorkloadGroup = previousWorkloadGroups.get(workloadGroupName);
            this.deletedWorkloadGroups.add(deletedWorkloadGroup);
            this.workloadGroupsStateAccessor.removeWorkloadGroup(deletedWorkloadGroup.get_id());
        }
        this.activeWorkloadGroups = new HashSet<WorkloadGroup>(currentMetadata.workloadGroups().values());
    }

    public void incrementFailuresFor(String workloadGroupId) {
        WorkloadGroupState workloadGroupState = this.workloadGroupsStateAccessor.getWorkloadGroupState(workloadGroupId);
        if (workloadGroupState == null) {
            return;
        }
        workloadGroupState.failures.inc();
    }

    public WorkloadGroupStats nodeStats(Set<String> workloadGroupIds, Boolean requestedBreached) {
        HashMap<String, WorkloadGroupStats.WorkloadGroupStatsHolder> statsHolderMap = new HashMap<String, WorkloadGroupStats.WorkloadGroupStatsHolder>();
        Map<String, WorkloadGroupState> existingStateMap = this.workloadGroupsStateAccessor.getWorkloadGroupStateMap();
        if (!workloadGroupIds.contains("_all")) {
            for (String id : workloadGroupIds) {
                if (existingStateMap.containsKey(id)) continue;
                throw new ResourceNotFoundException("WorkloadGroup with id " + id + " does not exist", new Object[0]);
            }
        }
        if (existingStateMap != null) {
            existingStateMap.forEach((workloadGroupId, currentState) -> {
                boolean shouldInclude;
                boolean bl = shouldInclude = workloadGroupIds.contains("_all") || workloadGroupIds.contains(workloadGroupId);
                if (shouldInclude && (requestedBreached == null || requestedBreached.booleanValue() == this.resourceLimitBreached((String)workloadGroupId, (WorkloadGroupState)currentState))) {
                    statsHolderMap.put((String)workloadGroupId, WorkloadGroupStats.WorkloadGroupStatsHolder.from(currentState));
                }
            });
        }
        return new WorkloadGroupStats(statsHolderMap);
    }

    public boolean resourceLimitBreached(String id, WorkloadGroupState currentState) {
        WorkloadGroup workloadGroup = this.clusterService.state().metadata().workloadGroups().get(id);
        if (workloadGroup == null) {
            throw new ResourceNotFoundException("WorkloadGroup with id " + id + " does not exist", new Object[0]);
        }
        for (ResourceType resourceType : WorkloadGroupResourceUsageTrackerService.TRACKED_RESOURCES) {
            double lastRecordedUsage;
            double threshold;
            if (!workloadGroup.getResourceLimits().containsKey((Object)resourceType) || !((threshold = this.getNormalisedRejectionThreshold(workloadGroup.getResourceLimits().get((Object)resourceType), resourceType)) < (lastRecordedUsage = currentState.getResourceState().get((Object)resourceType).getLastRecordedUsage()))) continue;
            return true;
        }
        return false;
    }

    public void rejectIfNeeded(String workloadGroupId) {
        if (this.workloadManagementSettings.getWlmMode() != WlmMode.ENABLED) {
            return;
        }
        if (workloadGroupId == null || workloadGroupId.equals(WorkloadGroupTask.DEFAULT_WORKLOAD_GROUP_ID_SUPPLIER.get())) {
            return;
        }
        WorkloadGroupState workloadGroupState = this.workloadGroupsStateAccessor.getWorkloadGroupState(workloadGroupId);
        if (workloadGroupState == null) {
            return;
        }
        Optional<WorkloadGroup> optionalWorkloadGroup = this.activeWorkloadGroups.stream().filter(x -> x.get_id().equals(workloadGroupId)).findFirst();
        if (optionalWorkloadGroup.isPresent() && optionalWorkloadGroup.get().getResiliencyMode() == MutableWorkloadGroupFragment.ResiliencyMode.SOFT && !this.nodeDuressTrackers.isNodeInDuress()) {
            return;
        }
        optionalWorkloadGroup.ifPresent(workloadGroup -> {
            boolean reject = false;
            StringBuilder reason = new StringBuilder();
            for (ResourceType resourceType : WorkloadGroupResourceUsageTrackerService.TRACKED_RESOURCES) {
                double lastRecordedUsage;
                double threshold;
                if (!workloadGroup.getResourceLimits().containsKey((Object)resourceType) || !((threshold = this.getNormalisedRejectionThreshold(workloadGroup.getResourceLimits().get((Object)resourceType), resourceType)) < (lastRecordedUsage = workloadGroupState.getResourceState().get((Object)resourceType).getLastRecordedUsage()))) continue;
                reject = true;
                reason.append((Object)resourceType).append(" limit is breaching for ENFORCED type WorkloadGroup: (").append(threshold).append(" < ").append(lastRecordedUsage).append("). ");
                workloadGroupState.getResourceState().get((Object)((Object)((Object)resourceType))).rejections.inc();
                break;
            }
            if (reject) {
                workloadGroupState.totalRejections.inc();
                throw new OpenSearchRejectedExecutionException("WorkloadGroup " + workloadGroupId + " is already contended. " + reason.toString());
            }
        });
    }

    private double getNormalisedRejectionThreshold(double limit, ResourceType resourceType) {
        if (resourceType == ResourceType.CPU) {
            return limit * this.workloadManagementSettings.getNodeLevelCpuRejectionThreshold();
        }
        if (resourceType == ResourceType.MEMORY) {
            return limit * this.workloadManagementSettings.getNodeLevelMemoryRejectionThreshold();
        }
        throw new IllegalArgumentException(String.valueOf((Object)resourceType) + " is not supported in WLM yet");
    }

    public Set<WorkloadGroup> getActiveWorkloadGroups() {
        return this.activeWorkloadGroups;
    }

    public Set<WorkloadGroup> getDeletedWorkloadGroups() {
        return this.deletedWorkloadGroups;
    }

    public boolean shouldSBPHandle(Task t) {
        WorkloadGroupTask task = (WorkloadGroupTask)t;
        boolean isInvalidWorkloadGroupTask = true;
        if (task.isWorkloadGroupSet() && !WorkloadGroupTask.DEFAULT_WORKLOAD_GROUP_ID_SUPPLIER.get().equals(task.getWorkloadGroupId())) {
            isInvalidWorkloadGroupTask = this.activeWorkloadGroups.stream().noneMatch(workloadGroup -> workloadGroup.get_id().equals(task.getWorkloadGroupId()));
        }
        return this.workloadManagementSettings.getWlmMode() != WlmMode.ENABLED || isInvalidWorkloadGroupTask;
    }

    @Override
    public void onTaskCompleted(Task task) {
        String workloadGroupId;
        if (!(task instanceof WorkloadGroupTask) || !((WorkloadGroupTask)task).isWorkloadGroupSet()) {
            return;
        }
        WorkloadGroupTask workloadGroupTask = (WorkloadGroupTask)task;
        String finalWorkloadGroupId = workloadGroupId = workloadGroupTask.getWorkloadGroupId();
        boolean exists = this.activeWorkloadGroups.stream().anyMatch(workloadGroup -> workloadGroup.get_id().equals(finalWorkloadGroupId));
        if (!exists) {
            workloadGroupId = WorkloadGroupTask.DEFAULT_WORKLOAD_GROUP_ID_SUPPLIER.get();
        }
        this.workloadGroupsStateAccessor.getWorkloadGroupState((String)workloadGroupId).totalCompletions.inc();
    }
}

