/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DelegatingDynamicMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Method", "UnboundMethod"}, overrides={RubyMethod.class, RubyUnboundMethod.class})
public abstract class AbstractRubyMethod
extends RubyObject
implements DataType {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected CacheEntry entry;
    protected DynamicMethod method;
    protected RubyModule sourceModule;

    protected AbstractRubyMethod(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public DynamicMethod getMethod() {
        return this.method;
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity(ThreadContext context) {
        return Convert.asFixnum(context, this.method.getSignature().arityValue());
    }

    @Deprecated
    public RubyFixnum arity() {
        return this.arity(this.getCurrentContext());
    }

    @Deprecated(since="9.4-")
    public final IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.op_eql(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, this.equals(other));
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public abstract AbstractRubyMethod rbClone();

    @JRubyMethod(name={"name"})
    public IRubyObject name(ThreadContext context) {
        return Convert.asSymbol(context, this.methodName);
    }

    public String getMethodName() {
        return this.methodName;
    }

    @JRubyMethod(name={"owner"})
    public IRubyObject owner(ThreadContext context) {
        if (this.method instanceof PartialDelegatingMethod) {
            return this.method.getImplementationClass();
        }
        return this.implementationModule.getOrigin();
    }

    @JRubyMethod(name={"source_location"})
    public IRubyObject source_location(ThreadContext context) {
        String filename2 = this.getFilename();
        return filename2 != null ? Create.newArray(context, (IRubyObject)Create.newString(context, filename2), (IRubyObject)Convert.asFixnum(context, this.getLine())) : context.nil;
    }

    @Deprecated(since="10.0")
    public RubyBoolean public_p(ThreadContext context) {
        return context.runtime.newBoolean(this.method.getVisibility().isPublic());
    }

    @Deprecated(since="10.0")
    public RubyBoolean protected_p(ThreadContext context) {
        return context.runtime.newBoolean(this.method.getVisibility().isProtected());
    }

    @Deprecated(since="10.0")
    public RubyBoolean private_p(ThreadContext context) {
        return context.runtime.newBoolean(this.method.getVisibility().isPrivate());
    }

    public String getFilename() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return TraceType.maskInternalFiles(poser.getFile());
        }
        return null;
    }

    public int getLine() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getLine() + 1;
        }
        return -1;
    }

    @JRubyMethod(name={"parameters"})
    public IRubyObject parameters(ThreadContext context) {
        return Helpers.methodToParameters(context, this);
    }

    protected IRubyObject super_method(ThreadContext context, IRubyObject receiver2, RubyModule superClass) {
        if (superClass == null) {
            return context.nil;
        }
        String searchName = this.method.getRealMethod().getName();
        CacheEntry entry = superClass.searchWithCache(searchName);
        if (entry.method == UndefinedMethod.INSTANCE || entry.method.getDefinedClass().getMethods().get(entry.method.getName()) == UndefinedMethod.INSTANCE) {
            return context.nil;
        }
        if (receiver2 == null) {
            return RubyUnboundMethod.newUnboundMethod(entry.sourceModule, this.methodName, superClass, this.originName, entry);
        }
        return RubyMethod.newMethod(entry.sourceModule, this.methodName, superClass, this.originName, entry, receiver2);
    }

    @JRubyMethod
    public IRubyObject original_name(ThreadContext context) {
        String string2;
        DynamicMethod dynamicMethod = this.method;
        if (dynamicMethod instanceof AliasMethod) {
            AliasMethod alias = (AliasMethod)dynamicMethod;
            string2 = alias.getOldName();
        } else {
            string2 = this.method.getName();
        }
        return Convert.asSymbol(context, string2);
    }

    public IRubyObject inspect(IRubyObject receiver2) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyString str = Create.newString(context, "#<");
        String sharp = "#";
        str.catString(this.getType().getName(context)).catString(": ");
        RubyModule mklass = this.originModule;
        RubyModule definedClass = this.method instanceof AliasMethod || this.method instanceof DelegatingDynamicMethod ? this.method.getRealMethod().getDefinedClass() : this.method.getDefinedClass();
        if (definedClass.isIncluded()) {
            definedClass = definedClass.getMetaClass();
        }
        if (receiver2 == null) {
            str.catWithCodeRange(AbstractRubyMethod.inspect(context, definedClass).convertToString());
        } else if (mklass.isSingleton()) {
            RubyBasicObject attached = ((MetaClass)mklass).getAttached();
            if (receiver2 == null) {
                str.catWithCodeRange(AbstractRubyMethod.inspect(context, mklass).convertToString());
            } else if (receiver2 == attached) {
                str.catWithCodeRange(AbstractRubyMethod.inspect(context, attached).convertToString());
                sharp = ".";
            } else {
                str.catWithCodeRange(AbstractRubyMethod.inspect(context, receiver2).convertToString());
                str.catString("(");
                str.catWithCodeRange(AbstractRubyMethod.inspect(context, attached).convertToString());
                str.catString(")");
                sharp = ".";
            }
        } else {
            if (receiver2 instanceof RubyClass) {
                str.catString("#<");
                str.cat(mklass.rubyName(context));
                str.catString(":");
                str.cat(((RubyClass)receiver2).rubyName(context));
                str.catString(">");
            } else {
                str.cat(mklass.rubyName(context));
            }
            if (definedClass != mklass) {
                str.catString("(");
                str.cat(definedClass.rubyName(context));
                str.catString(")");
            }
        }
        str.catString(sharp);
        str.cat(Convert.asSymbol(context, this.methodName).asString());
        if (!this.methodName.equals(this.method.getName())) {
            str.catString("(");
            str.cat(Convert.asSymbol(context, this.method.getRealMethod().getName()).asString());
            str.catString(")");
        }
        if (this.method.isNotImplemented()) {
            str.catString(" (not-implemented)");
        }
        str.catString("(");
        ArgumentDescriptor[] descriptors = Helpers.methodToArgumentDescriptors(context, this.method);
        if (descriptors.length > 0) {
            RubyString desc = descriptors[0].asParameterName(context);
            str.cat(desc);
            for (int i2 = 1; i2 < descriptors.length; ++i2) {
                desc = descriptors[i2].asParameterName(context);
                str.catString(", ");
                str.cat(desc);
            }
        }
        str.catString(")");
        String fileName = this.getFilename();
        if (fileName != null) {
            str.catString(" ");
            str.catString(fileName).cat(58).catString("" + this.getLine());
        }
        str.catString(">");
        return str;
    }
}

