<?php
/**
 * $Horde: horde/util/cacheview.php,v 1.2 2003/06/19 18:48:15 chuck Exp $
 *
 * Copyright 2002-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Cache.php';

$cid = Horde::getFormData('cid');
if (empty($cid)) {
    _cacheError();
}

$cache = &Horde_Cache::singleton($conf['cache']['driver']);
$cdata = unserialize($cache->getData($cid, "_cacheError('$cid')", $conf['cache']['default_lifetime']));

$browser->downloadHeaders('cacheObject', $cdata['ctype'], true, strlen($cdata['data']));
echo $cdata['data'];

/**
 * Output an error if no CID was specified or the data wasn't in the
 * cache.
 */
function _cacheError($cid = null)
{
    if (!is_null($cid)) {
        Horde::logMessage('CID ' . $cid . ' not found in the cache, unable to display.', __FILE__, __LINE__, PEAR_LOG_ERR);
    }
    exit;
}
