<?php
/**
 * $Horde: turba/deleteobject.php,v 1.18 2003/05/22 19:42:42 chuck Exp $
 *
 * Turba: Copyright 2000-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';

$source = Horde::getFormData('source');
$driver = &Turba_Source::singleton($source, $cfgSources[$source]);

$key = Horde::getFormData('key');
if ($driver->removeObject($key)) {
    if (!empty($_SESSION['turba_search_results'])) {
        require_once TURBA_BASE . '/lib/List.php';
        require_once TURBA_BASE . '/lib/Object.php';
        $list = Turba_List::unserialize($_SESSION['turba_search_results']);
        $list->remove($key);
        $_SESSION['turba_search_results'] = $list->serialize();
    }
    if (Horde::getFormData('url')) {
        header('Location: ' . Horde::getFormData('url'));
    } else {
        header('Location: ' . Horde::url($prefs->getValue('initial_page'), true));
    }
} else {
    $notification->push(_("There was an error deleting this entry. Contact your system administrator for further help."), 'horde.error');

    $title = _("Deletion failed");
    $js_onLoad = null;
    require TURBA_TEMPLATES . '/common-header.inc';
    Turba::menu();
    require TURBA_TEMPLATES . '/common-footer.inc';
}
