#!/usr/local/bin/php
<?php
// $Horde: horde/scripts/rpc-test.php,v 1.4 2003/02/14 01:32:03 jan Exp $

define('HORDE_BASE', dirname(__FILE__) . '/..');
$_SERVER['SERVER_NAME'] = 'localhost';
$_SERVER['SERVER_PORT'] = 80;
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/RPC.php';

if (!isset($argv) || count($argv) < 2) {
    die("Can't read arguments.\n");
}

$testno = $argv[1];
$user   = @$argv[2];
$pass   = @$argv[3];

switch ($testno) {

case 0:
    $response = RPC::request('xmlrpc', Horde::url('rpc.php', true, -1),
                             'system.listMethods', null,
                             array('user' => $user, 'pass' => $pass));
    break;

case 1:
    $response = RPC::request('xmlrpc', Horde::url('rpc.php', true, -1),
                             'system.describeMethods', array('tasks.list'),
                             array('user' => $user, 'pass' => $pass));
    break;

case 2:
    $response = RPC::request('xmlrpc', Horde::url('rpc.php', true, -1),
                             'tasks.list', array(0),
                             array('user' => $user, 'pass' => $pass));
    break;

case 3:
    $response = RPC::request('xmlrpc', 'http://dev.horde.org/horde/rpc.php',
                             'system.listMethods', null,
                             array('user' => $user, 'pass' => $pass));
    break;

case 4:
    $response = RPC::request('xmlrpc', 'http://pear.php.net/xmlrpc.php',
                             'package.listAll');
    break;

case 5:
    $response = RPC::request('soap', 'http://api.google.com/search/beta2',
                             'doGoogleSearch',
                             array('key' => '5a/mF/FQFHKTD4vgNxfFeODwtLdifPPq',
                                   'q' => 'Horde IMP',
                                   'start' => 0,
                                   'maxResults' => 10,
                                   'filter' => true,
                                   'restrict' => '',
                                   'safeSearch' => false,
                                   'lr' => '',
                                   'ie' => 'iso-8859-1',
                                   'oe' => 'iso-8859-1'),
                             array('namespace' => 'urn:GoogleSearch'));

}

if (PEAR::isError($response)) {
    echo "===error======\n";
    echo $response->getMessage();
    echo "\n";
    echo $response->getUserInfo();
    echo "\n==============\n";
} else {
    echo "===value======\n";
    var_dump($response);
    echo "==============\n";
}
