<?php
/**
 * $Horde: mnemo/view.php,v 1.12 2003/06/16 23:12:10 chuck Exp $
 *
 * Copyright 2001-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';

/* If we aren't provided with a note,  redirect to the notepad view. */
$memo_id = Horde::getFormData('memo');
$memolist_id = Horde::getFormData('memolist');
if (!isset($memo_id)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

$share = $GLOBALS['mnemo_shares']->getShare($memolist_id);
if (is_a($share, 'PEAR_Error')) {
    $notification->push(sprintf(_("There was an error viewing this notepad: %s"), $share->getMessage()), 'horde.error');
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
} elseif (!$share->hasPermission(Auth::getAuth(), _PERMS_READ)) {
    $notification->push(sprintf(_("You do not have permission to view the notepad %s."), $share->getShareName()), 'horde.error');
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Get the current note. */
$memo = Mnemo::getMemo($memolist_id, $memo_id);

/* Set the page title to the current note's name, if it exists. */
$title = (!$memo) ? $memo['desc'] : _("Note Details");

require MNEMO_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    include_once $registry->getParam('templates', 'horde') . '/javascript/print.js';
} else {
    $print_link = Horde::addParameter('view.php', 'memo', $memo_id);
    $print_link = Horde::addParameter($print_link, 'memolist', $memolist_id);
    $print_link = Horde::addParameter($print_link, 'print', 'true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        include_once $registry->getParam('templates', 'horde') . '/javascript/open_print_win.js';
    }

    Mnemo::menu();
}

/* If the requested note doesn't exist, display an error message. */
if (!$memo) {
    include MNEMO_TEMPLATES . '/view/no-memo.inc';
} else {
    include MNEMO_TEMPLATES . '/view/headers.inc';
    include MNEMO_TEMPLATES . '/view/description.inc';
    if (!$print_view) {
        include MNEMO_TEMPLATES . '/view/navbar.inc';
    }
}

require MNEMO_TEMPLATES . '/common-footer.inc';
