<?php
/**
 * $Horde: mnemo/memo.php,v 1.15 2003/06/16 03:31:03 chuck Exp $
 *
 * Copyright 2002-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';

/* Redirect to the notepad view if no action has been requested. */
$memo_id = Horde::getFormData('memo');
$memolist_id = Horde::getFormData('memolist');
$actionID = Horde::getFormData('actionID');
if (is_null($actionID)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Run through the action handlers. */
switch($actionID) {
case MNEMO_ADD_MEMO:
    /* Set up the note attributes. */
    $memolist_id = $prefs->getValue('default_notepad');
    $memo_id = null;
    $memo_body = '';

    if (($memo_category = $prefs->getValue('default_note_category')) == null) {
        $memo_category = 0;
    }

    $title = _("Adding A New Note");
    break;

case MNEMO_MODIFY_MEMO:
    /* Get the current note. */
    $memo = Mnemo::getMemo($memolist_id, $memo_id);

    if ($memo) {
        /* Set up the note attributes. */
        $memo_body = $memo['body'];
        $memo_category = $memo['category'];
        $title = sprintf(_("Modifying %s"), $memo['desc']);
    } else {
        $title = _("Unknown note");
        $memo_body = '';
        $memo_category = '';
    }
    break;

case MNEMO_SAVE_MEMO:
    /* Get the form values. */
    $memo_id = Horde::getFormData('memo');
    $memo_body = Horde::getFormData('memo_body');
    $memo_category = Horde::getFormData('memo_category');
    $memolist_original = Horde::getFormData('memolist_original');
    $notepad_target = Horde::getFormData('notepad_target');

    $share = $GLOBALS['mnemo_shares']->getShare($notepad_target);
    if (is_a($share, 'PEAR_Error') || !$share->hasPermission(Auth::getAuth(), _PERMS_EDIT)) {
        $notification->push(sprintf(_("Access denied saving note to %s."), $share->getShareName()), 'horde.error');
    } else {
        if ($memo_category == '*new*') {
            $new_category = Horde::getFormData('new_category');
            $memo_category = Mnemo::addCategory($new_category);
            if ($memo_category == 0) {
                $notification->push(sprintf(_("Unable to create the category: %s"), $new_category), 'horde.warning');
            }
        }

        /* If $memo_id is set, we're modifying an existing note.
         * Otherwise, we're adding a new note with the provided
         * attributes. */
        if (!empty($memo_id) && Mnemo::getMemo($memolist_original, $memo_id)) {
            if ($memolist_original != $notepad_target) {
                /* Saving to a different notepad */
                $share = $GLOBALS['mnemo_shares']->getShare($memolist_original);

                if (!is_a($share, 'PEAR_Error') && $share->hasPermission(Auth::getAuth(), _PERMS_DELETE)) {
                    $storage = &Mnemo_Driver::factory($conf['storage']['driver'], $memolist_original,
                                                      $conf['storage']['params']);
                    $storage->retrieve();
                    $storage->deleteMemo($memo_id);

                    if (is_a($storage->store(), 'PEAR_Error')) {
                        $notification->push(_("There was an error removing the note."), 'horde.warning');
                    }

                    $storage = &Mnemo_Driver::factory($conf['storage']['driver'], $notepad_target,
                                                      $conf['storage']['params']);
                    $storage->retrieve();
                    $memo_id = $storage->addMemo($memo_body, $memo_category);
                } else {
                    $notification->push(_("Access denied removing the note."), 'horde.warning');
                }
            } else {
                /* Modifying the note on the same notepad */
                $storage = &Mnemo_Driver::factory($conf['storage']['driver'], $notepad_target,
                                                  $conf['storage']['params']);
                $storage->retrieve();

                $storage->modifyMemo($memo_id, 'body', $memo_body);
                $storage->modifyMemo($memo_id, 'category', $memo_category);
                $storage->setMemoDescription($memo_id);
            }
        } else {
            /* Creating a new note */
            $storage = &Mnemo_Driver::factory($conf['storage']['driver'], $notepad_target,
                                              $conf['storage']['params']);
            $storage->retrieve();
            $memo_id = $storage->addMemo($memo_body, $memo_category);
        }

        /* Store the changes. */
        $result = $storage->store();
        if (is_a($result, 'PEAR_Error')) {
            $notification->push(_("There was an error saving the note."), 'horde.warning');
        }
    }

    /* Return to the notepad view. */
    $memourl = Horde::addParameter('view.php', 'memo=' . $memo_id);
    $memourl = Horde::addParameter($memourl, 'memolist=' . $notepad_target);
    header('Location: ' . Horde::applicationUrl($memourl, true));
    exit;
    break;

case MNEMO_DELETE_MEMOS:
    /* Delete the note if we're provided with a valid note ID. */
    $memo_id = Horde::getFormData('memo');
    $memolist_id = Horde::getFormData('memolist');

    if (!is_null($memo_id) && Mnemo::getMemo($memolist_id, $memo_id)) {
        $share = $GLOBALS['mnemo_shares']->getShare($memolist_id);
        if (!is_a($share, 'PEAR_Error') && $share->hasPermission(Auth::getAuth(), _PERMS_DELETE)) {
            $storage = &Mnemo_Driver::factory($conf['storage']['driver'], $memolist_id,
                                              $conf['storage']['params']);
            $storage->retrieve();
            $storage->deleteMemo($memo_id);

            if (is_a($storage->store(), 'PEAR_Error')) {
                $notification->push(_("There was an error removing the note."), 'horde.warning');
            } else {
                $notification->push(_("The note was deleted."), 'horde.success');
            }
        } else {
            $notification->push(_("Access denied deleting note."), 'horde.warning');
        }
    }

    /* Return to the notepad. */
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
    break;

default:
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}


require MNEMO_TEMPLATES . '/common-header.inc';
Mnemo::menu();
require MNEMO_TEMPLATES . '/memo/memo.inc';
require MNEMO_TEMPLATES . '/common-footer.inc';
