<?php

/**
 * Horde Mnemo driver for the Kolab IMAP server.
 * Based on code by Adriaan Putter <kougom@yahoo.com>
 *
 * Copyright (C) 2003 Code Fusion, cc.
 * Written by Stuart Bing <s.binge@codefusion.co.za>
 *
 * Created 2003-08-20
 * Last Modified 2003-08-29 by Stuart Bing
 */

require_once(HORDE_BASE . '/lib/Kolab.php');
require_once(HORDE_BASE . '/lib/iCalendar.php');

class Mnemo_Driver_kolab extends Mnemo_Driver {

  var $_params = array();
  var $_folder;
  var $_server;

  function Mnemo_Driver_kolab($user, $params)
  {
    $this->type = 'kolab';
    $this->_user = $user;
    $this->_params = $params;
    $this->_folder = $params['folder'];
    $this->_server = $params['server'];
  }

  function retrieve()
  {
    $imap = Kolab::OpenImapConnection($this->_server, $this->_folder);
    if (!$imap) return PEAR::raiseError('Unable to open IMAP connection.');

    $this->_memos = array();

    $mod = false;
    $msgs = Kolab::GetMessageList($imap);
    for ($i = 0; $i < count($msgs); $i++)
    {
      $body = imap_body($imap, $msgs[$i]);
      $desc = explode(MIME_NL, $body);
      $body = str_replace(MIME_NL, "\n", $body);

      $headers = Kolab::GetMessageHeaders($imap, $msgs[$i]);
      $cat = Kolab::GetHeaderValue($headers, X_HEAD_CAT, 0);
      $uid = Kolab::GetHeaderValue($headers, X_HEAD_ID);
      $flags = 0;
      if (is_null($uid))
      {
        $uid = uniqid("0x");
        $flags = MEMO_MODIFIED;
        $mod = true;
      }

      $memo = array();
      $memo['memolist_id'] = $this->_user;
      $memo['message_id'] = $msgs[$i];
      $memo['memo_id'] = $uid;
      $memo['desc'] = $desc[0];
      $memo['body'] = $body;
      $memo['category'] = $cat;
      $memo['private'] = "";
      $memo['flags'] = $flags;

      $this->_memos[$uid] = $memo;
    }

    Kolab::CloseIMAPConnection($imap);

    if ($mod)
      $this->store(); // Re-save the non-Mnemo memos to ensure they have their Message IDs set corerctly

    return true;
  }

  function store()
  {
    $added_memos = $this->listMemos(MEMO_ADDED);
    $modified_memos = $this->listMemos(MEMO_MODIFIED);
    $deleted_memos = $this->listMemos(MEMO_DELETED);

    if ((count($added_memos) == 0) && (count($modified_memos) == 0) && (count($deleted_memos) == 0))
      return true;  // No-op

    $imap = Kolab::OpenImapConnection($this->_server, $this->_folder);
    if (!$imap) return PEAR::raiseError('Unable to open IMAP connection.');

    list($user, $pass) = Kolab::GetAuthentication();
    $mailbox = Kolab::MailboxURI($this->_server, $this->_folder);

    foreach ($added_memos as $memo_id => $memo)
    {
      $body = str_replace("\n", MIME_NL, $memo['body']);
      if (!Kolab::AddMessage($imap, $mailbox, $user, 'text/plain', $body, 'Mnemo', array(
        X_HEAD_ID => strval($memo_id),
        X_HEAD_CAT => $memo['category']
      )))
      {
        Kolab::CloseIMAPConnection($imap);
        return PEAR::raiseError('Unable to add memo.');
      }

      $this->setFlag($memo_id, MEMO_ADDED, false);
    }

    foreach ($modified_memos as $memo_id => $memo)
    {
      $mid = $memo['message_id'];
      if (is_null($mid)) continue;
      @imap_delete($imap, $mid);

      $body = str_replace("\n", MIME_NL, $memo['body']);
      if (!Kolab::AddMessage($imap, $mailbox, $user, 'text/plain', $body, 'Mnemo', array(
        X_HEAD_ID => strval($memo_id),
        X_HEAD_CAT => $memo['category']
      )))
      {
        Kolab::CloseIMAPConnection($imap);
        return PEAR::raiseError('Unable to add memo.');
      }

      $this->setFlag($memo_id, MEMO_MODIFIED, false);
    }

    foreach ($deleted_memos as $memo_id => $memo)
    {
      $mid = $memo['message_id'];
      if (is_null($mid)) continue;
      @imap_delete($imap, $mid);

      $this->setFlag($memo_id, MEMO_DELETED, false);
    }

    $this->purgeDeleted();

    Kolab::CloseIMAPConnection($imap);

    return true;
  }
}
