<?php
/**
 * The Notification_Event:: class provides a container for passing
 * messages to Notification_Listener classes.
 *
 * $Horde: horde/lib/Notification/Event.php,v 1.2 2003/02/10 15:48:33 mikec Exp $
 *
 * Copyright 2002-2003 Hans Lellelid <hans@velum.net>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Hans Lellelid <hans@velum.net>
 * @version $Revision: 1.2 $
 * @since   Horde 3.0
 * @package horde.notification
 */
class Notification_Event {

    /**
     * The message being passed.
     * @var string $_message
     * @access private
     */
    var $_message = '';

    /**
     * If passed, sets the message for this event.
     *
     * @param string  $message (optional) The text message for this event.
     * @access public
     */
    function Notification_Event($message = null)
    {
        if (!is_null($message)) {
            $this->setMessage($message);
        }
    }

    /**
     * Sets the text message for this event.
     *
     * @param string  $message   The text message to display.
     * @access public
     */
    function setMessage($message)
    {
        $this->_message = $message;
    }

    /**
     * Gets the text message for this event.
     *
     * @return string   The text message to display.
     * @access public
     */
    function getMessage()
    {
        return $this->_message;
    }

}
