<?php
/**
 * $Horde: horde/lib/Block/iframe.php,v 1.3 2003/08/05 01:46:56 chuck Exp $
 *
 * @package Horde
 */
class Horde_Block_iframe extends Horde_Block {

    /**
     * Constructor.
     */
    function Horde_Block_iframe($params = array())
    {
        $this->_params = $params;
        $this->_app = 'horde';
        $this->_type = 'iframe';
    }

    /**
     * Does this block have any user editable parameters?
     *
     * @return boolean  True is there are editable parameters.
     *                  False if there are not.
     */
    function isEditable()
    {
        return true;
    }

    /**
     * The title to go in this block.
     *
     * @return string   The title text.
     */
    function _title()
    {
        return $this->_params['iframe'];
    }

    /**
     * The content to go in this block.
     *
     * @return string   The content
     */
    function _content()
    {
        require_once HORDE_BASE . '/lib/Browser.php';
        $browser = &Browser::singleton();

        if (!$browser->hasFeature('iframes')) {
            $html = _("Your browser does not support this feature.");
        } else {
            if ($browser->isBrowser('msie')) {
                $height = '';
            } else {
                $height = ' height="100%"';
            }
            $html = '<iframe src="' . htmlspecialchars($this->_params['iframe']) . '" width="100%"' . $height . ' marginheight="0" scrolling="yes" frameborder="0"></iframe>';
        }
        return $html;
    }

}
