<?php

require_once dirname(__FILE__) . '/ipbasic.php';

/**
 * The Auth_ipmap class provides access control based on CIDR masks.
 *
 * Parameters:
 *   NONE
 *
 * $Horde: horde/lib/Auth/ipmap.php,v 1.9 2003/02/11 20:36:08 slusarz Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.9 $
 * @since   Horde 1.3
 * @package horde.auth
 */
class Auth_ipmap extends Auth_ipbasic {

    /**
     * An array of capabilities, so that the driver can report which
     * operations it supports and which it doesn't.
     *
     * @var array $capabilities
     */
    var $capabilities = array('add'         => false,
                              'update'      => false,
                              'remove'      => false,
                              'list'        => false,
                              'transparent' => true,
                              'loginscreen' => false);

    /**
     * Constructs a new IP-mapping authentication object.
     *
     * @access public
     *
     * @param optional array $params  A hash containing parameters.
     */
    function Auth_ipmap($params = array())
    {
        $this->_setParams($params);
    }

    /**
     * Set parameters for the Auth_ipbasic object.
     *
     * @access private
     *
     * @param array $params  A hash containing parameter information.
     */
    function _setParams($params)
    {
    }

}
