<?php
/**
 * $Horde: kronolith/viewevent.php,v 1.22 2003/06/16 23:17:34 chuck Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Text.php';

if (Horde::getFormData('calendar') == '**remote') {
    $event = Kronolith::getRemoteEventObject(Horde::getFormData('remoteCal'), Horde::getFormData('eventID'));
} else {
    $calendar->open(Horde::getFormData('calendar'));
    $event = &$calendar->getEventObject(Horde::getFormData('eventID'));
    if ($event) {
        $share = &$shares->getShare($event->getCalendar());
    }
}
if (!$event) {
    if (($url = Horde::getFormData('url')) === null) {
        $url = Horde::applicationUrl($prefs->getValue('defaultview') . '.php', true);
    }
    header('Location: ' . $url);
    exit;
}

$category = $event->getCategory();
$description = $event->getDescription();
$location = $event->getLocation();

if ($conf['metadata']['keywords']) {
    include_once KRONOLITH_BASE . '/config/keywords.php';
    $keyword_list = array();
    foreach ($keywords as $cat => $list) {
        $sub_list = array();
        foreach ($list as $entry) {
            if ($event->hasKeyword($entry)) {
                $sub_list[] = htmlspecialchars($entry);
            }
        }
        if (count($sub_list)) {
            $keyword_list[$cat] = $sub_list;
        }
    }
}

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $year = Horde::getFormData('year', date('Y'));
}

$title = sprintf(_("View %s"), $event->getTitle());

require KRONOLITH_TEMPLATES . '/common-header.inc';

$print_view = (boolean)Horde::getFormData('print');
if ($print_view) {
    require_once $registry->getParam('templates', 'horde') . '/javascript/print.js';
} else {
    $print_link = Horde::addParameter(Horde::selfURL(true), 'print', 'true');
    if ($browser->hasFeature('javascript')) {
        require_once $registry->getParam('templates', 'horde') . '/javascript/open_print_win.js';
    }

    Kronolith::menu();
}

$mylinks = array();
$isRemote = Horde::getFormData('calendar') == '**remote';

if (!$isRemote && $share->hasPermission(Auth::getAuth(), _PERMS_DELETE, $event->getCreatorID())) {
    $delurl = Horde::addParameter('delevent.php', 'eventID', $event->getID());
    $delurl = Horde::addParameter($delurl, 'calendar', $event->getCalendar());
    $delurl = Horde::addParameter($delurl, 'timestamp', $timestamp);
    $delurl = Horde::applicationUrl($delurl);
    $mylinks[] = Horde::link($delurl, sprintf(_("Delete '%s'"), $event->getTitle()), 'menuitem') . _("Delete") . '</a>';
}

if ($isRemote || $share->hasPermission(Auth::getAuth(), _PERMS_EDIT, $event->getCreatorID())) {
    $editurl = 'editevent.php';
    if (Horde::getFormData('calendar') != '**remote') {
        $editurl = Horde::addParameter($editurl, 'eventID', $event->getID());
    } else {
        $editurl = Horde::addParameter($editurl, 'eventID', $event->eventIndex);
        $editurl = Horde::addParameter($editurl, 'remoteCal', $event->remoteCal);
    }
    $editurl = Horde::addParameter($editurl, 'calendar', Horde::getFormData('calendar'));
    $editurl = Horde::addParameter($editurl, 'timestamp', $timestamp);
    $editurl = Horde::addParameter($editurl, 'url', Horde::selfURL(true));
    $editurl = Horde::applicationUrl($editurl);
    $mylinks[] = Horde::link($editurl, sprintf(_("Edit '%s'"), $event->getTitle()), 'menuitem') . _("Edit") . '</a>';
}

// Only show invite link if they are logged on and have an
// identity with a from_addr
require_once HORDE_BASE . '/lib/Identity.php';
$ident = &new Identity();
$tmp_emails = $ident->getAll('from_addr');
$hasEmail = false;
foreach ($tmp_emails as $tmp_email) {
    if (!empty($tmp_email)) {
        $hasEmail = true;
        break;
    }
}
if ($hasEmail && Auth::getAuth()) {
    $inviteurl = Horde::addParameter('invite.php', 'calendar', Horde::getFormData('calendar'));
    $inviteurl = Horde::addParameter($inviteurl, 'url', Horde::selfURL(true));
    if (Horde::getFormData('calendar') != '**remote') {
        $inviteurl = Horde::addParameter($inviteurl, 'eventID', $event->getID());
    } else {
        $inviteurl = Horde::addParameter($inviteurl, 'eventID', $event->eventIndex);
        $inviteurl = Horde::addParameter($inviteurl, 'remoteCal', $event->remoteCal);
    }

    $inviteurl = Horde::applicationUrl($inviteurl);
    $mylinks[] = Horde::link($inviteurl, sprintf(_("Invite people to '%s'"), $event->getTitle()), 'menuitem') . _("Invite") . '</a>';
}

// Determine owner's name
require_once HORDE_BASE . '/lib/Identity.php';
$owner = $event->getCreatorID(); 
$ident = &new Identity($owner);
$ident->setDefault($ident->getDefault());
$tmp_name = $ident->getValue('fullname');
if (!empty($tmp_name)) {
    $owner = $tmp_name;
}

require KRONOLITH_TEMPLATES . '/view/view.inc';
require KRONOLITH_TEMPLATES . '/common-footer.inc';
