<?php
/**
 * $Horde: kronolith/invite.php,v 1.25 2003/05/22 21:48:29 chuck Exp $
 *
 * Copyright 2002-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$eventID = Horde::getFormData('eventID');
if (is_null($eventID)) {
    $uri = $prefs->getValue('defaultview') . '.php';
    if ($uri == '.php') {
        $uri = 'month.php';
    }
    header('Location: ' . Horde::applicationUrl($uri, true));
}

if (Horde::getFormData('calendar') == '**remote') {
    $event = Kronolith::getRemoteEventObject(Horde::getFormData('remoteCal'), $eventID);
} else {
    $calendar = &Kronolith_Driver::factory($conf['calendar']['driver'], $conf['calendar']['params']);
    $calendar->open(Horde::getFormData('calendar'));
    $event = &$calendar->getEventObject($eventID);
}

require_once HORDE_BASE . '/lib/Identity.php';
$ident = &new Identity();
$identities = $ident->getAll('id');

$actionID = Horde::getFormData('actionID');
switch ($actionID) {
 case 'invite':
     $invitees = Horde::getPost('invitees');
     $identity = Horde::getPost('identity', $ident->getDefault());
     $ident->setDefault($identity);
     if (!empty($invitees)) {
         $email = $ident->getValue('from_addr');
         if (empty($email)) {
             $notification->push(_("You don't have an email address configured in your preferences. You must set one before sending invitations."), 'horde.error');
             break;
         }

         require_once HORDE_BASE . '/lib/Data.php';
         require_once HORDE_BASE . '/lib/Text.php';
         require_once HORDE_BASE . '/lib/MIME.php';
         require_once HORDE_BASE . '/lib/MIME/Headers.php';
         require_once HORDE_BASE . '/lib/MIME/Message.php';

         list($mailbox, $host) = explode('@', $email);
         $from = MIME::rfc822WriteAddress($mailbox, $host, $ident->getValue('fullname'));

         $message = sprintf(_("You have been invited to \"%s\"."), $event->getTitle()) . "\n\n";
         if ($event->getDescription() != '') {
            $message .= _("Here is a more detailed description:") . "\n\n" . $event->getDescription() . "\n\n";
         }
         $message .= _("Attached is an iCalendar file describing this event.");

         $mime = &new MIME_Message();
         $body = &new MIME_Part('text/plain', Text::wrap($message, 80, "\n"));

         $vcs = &Horde_Data::singleton('icalendar');
         $ics = &new MIME_Part('text/calendar',
                               $vcs->exportData(array($event->toiCalendar($ident, $vcs))));
         $ics->setName('invitation.ics');
         $ics->setContentTypeParameter('METHOD', 'PUBLISH');

         $mime->addPart($body);
         $mime->addPart($ics);

         // Build the invitation headers
         $msg_headers = &new MIME_Headers();
         $msg_headers->addReceivedHeader();
         $msg_headers->addMessageIdHeader();
         $msg_headers->addHeader('Date', date('r'));
         $msg_headers->addHeader('From', $from);
         $msg_headers->addHeader('To', $invitees);
         $msg_headers->addHeader('Subject', sprintf(_("You have been invited to %s"), $event->getTitle()));
         $msg_headers->addHeader('User-Agent', 'Kronolith Calendaring System');
         $msg_headers->addMIMEHeaders($mime);

         $status = $mime->send($invitees, $msg_headers);
         if (!is_a($status, 'PEAR_Error')) {
             $notification->push(_("Your invitation was successfully sent."), 'horde.success');
             $url = Horde::getPost('url');
             if (!empty($url)) {
                 header('Location: ' . $url);
             } else {
                 header('Location: ' . Horde::applicationUrl('viewevent.php?eventID=' . $eventID));
             }
             exit;
         } else {
             $notification->push(sprintf(_("There was an error sending your invitation: %s"), $status->getMessage()), 'horde.error');
         }
     }
     break;
}

require KRONOLITH_TEMPLATES . '/common-header.inc';
Kronolith::menu();
require KRONOLITH_TEMPLATES . '/invite/invite.inc';
require KRONOLITH_TEMPLATES . '/common-footer.inc';
