<?php
/**
 * $Horde: horde/index.php,v 2.77 2003/08/15 16:14:58 chuck Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
$horde_configured = (@file_exists(HORDE_BASE . '/config/conf.php') &&
                     @file_exists(HORDE_BASE . '/config/html.php') &&
                     @file_exists(HORDE_BASE . '/config/mime_drivers.php') &&
                     @file_exists(HORDE_BASE . '/config/prefs.php') &&
                     @file_exists(HORDE_BASE . '/config/registry.php'));

if ($horde_configured) {
    require_once HORDE_BASE . '/lib/base.php';

    if ($browser->isMobile()) {
        require HORDE_BASE . '/mobile.php';
        exit;
    } else {
        $url = Horde::getFormData('url');
        $initial_app = $prefs->getValue('initial_application');

        if (!empty($url) && !strstr($url, 'login.php')) {
            $main_page = $url;
        } elseif (!empty($initial_app) && Auth::isAuthenticated()) {
            $main_page = Horde::url($registry->getInitialPage($initial_app));
        } elseif (isset($registry->applications['horde']['initial_page'])) {
            $main_page = Horde::applicationUrl($registry->applications['horde']['initial_page']);
        } elseif (Auth::getAuth()) {
            $main_page = Horde::applicationUrl('portal.php');
        } else {
            $main_page = Horde::applicationUrl('login.php');
        }

        if ($conf['menu']['display'] && Auth::getAuth() && $prefs->getValue('show_sidebar')) {
            if ($browser->hasQuirk('scrollbar_in_way')) {
                $scrollbar = 'yes';
            } else {
                $scrollbar = 'auto';
            }
            require HORDE_TEMPLATES . '/index/frames_index.inc';
        } else {
            header('Location: ' . $main_page);
            exit;
        }
    }
} else {
    require HORDE_BASE . '/templates/index/notconfigured.inc';
}
