<?php
/*
 * $Horde: imp/lib/Maintenance/Task/purge_trash.php,v 1.17 2003/04/18 20:11:48 slusarz Exp $
 *
 * Copyright 2001-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Maintenance module that purges old messages in the Trash folder.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.17 $
 * @since   IMP 2.3.7
 * @package horde.maintenance
 */
class Maintenance_Task_purge_trash extends Maintenance_Task {

    /**
     * Purge old messages in the Trash folder.
     *
     * @access public
     *
     * @return boolean  Whether any messages were purged from the Trash folder.
     */
    function doMaintenance()
    {
        global $imp, $prefs, $notification;

        /* Check to make sure Trash folder is being used by IMP. */
        if ($prefs->getValue('use_trash')) {

            /* Make sure the Trash folder exists. */
            require_once IMP_BASE . '/lib/Folder.php';
            $imp_folder = &IMP_Folder::singleton();
            if ($imp_folder->exists($imp['stream'], IMP::addPreambleString($prefs->getValue('trash_folder')))) {

                /* Initialize purged messages counter. */
                $purge_count = 0;

                /* Get the current UNIX timestamp minus the number of days
                     specified in 'purge_trash_keep'.
                   If a message has a timestamp prior to this value, it
                     will be deleted. */
                $del_time = date("r", time() - ($prefs->getValue('purge_trash_keep') * 86400));

                /* Open the Trash mailbox and get the list of messages older
                   than 'purge_trash_keep' days. */
                require_once IMP_BASE . '/lib/IMAP.php';
                $imp_imap = &IMP_IMAP::singleton();
                $trash_stream = $imp_imap->openIMAPStream(IMP::addPreambleString($prefs->getValue('trash_folder')));
                $msg_ids = @imap_search($trash_stream, "BEFORE \"$del_time\"", SE_UID);

                /* Go through the message list and set the delete flag on all
                     messages. */
                if (!empty($msg_ids)) {
                    foreach ($msg_ids as $val) {
                        imap_delete($trash_stream, $val, FT_UID);
                        $purge_count++;
                    }
                }

                /* Only continue if there are messages to delete. */
                if ($purge_count) {

                    /* Output information message to user. */
                    $notification->push(sprintf(_("Purging %d message(s) from Trash folder."), $purge_count), 'horde.message');

                    /* Expunge messages from the mailbox now. */
                    imap_close($trash_stream, CL_EXPUNGE);

                    return true;

                }

                imap_close($trash_stream);

            }

        }

       return false;
    }

    /**
     * Return information for the maintenance function.
     *
     * @access public
     *
     * @return string  Description of what the operation is going to do during
     *                 this login.
     */
    function describeMaintenance()
    {
        global $prefs;

        return sprintf(_("All messages in your \"%s\" folder older than %s days will be permanently deleted."), $prefs->getValue('trash_folder'), $prefs->getValue('purge_trash_keep'));
    }

}
?>
