<?php
/**
 * $Horde: imp/lib/Maintenance/Task/fetchmail_login.php,v 1.1 2003/02/26 18:12:52 jan Exp $
 *
 * Copyright 2003 Nuno Loureiro <nuno@co.sapo.pt>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * Maintenance module that fetch mail upon login
 *
 * @author  Nuno Loureiro <nuno@co.sapo.pt>
 * @version $Revision: 1.1 $
 * @since   IMP 4.0
 * @package horde.maintenance
 */
class Maintenance_Task_fetchmail_login extends Maintenance_Task {

    /**
     * The style of the maintenance page output.
     *
     * @var integer $display_type
     */
    var $_display_type = MAINTENANCE_OUTPUT_NOTICE;


    /**
     * Fetch email from other accounts.
     *
     * @access public
     */
    function doMaintenance()
    {
        global $prefs;

        /* If the user wants to fetch emails from other accounts on
         *                    login, make sure to get them. */
        if ($prefs->getValue('accounts')) {
            global $imap_protocols;
            require_once IMP_BASE . '/lib/Fetchmail.php';
            $account = &new Account();
            foreach ($account->getAll('loginfetch') as $id => $val) {
                if ($val) {
                    $params = array();
                    $plist = array('server', 'protocol', 'username',
                            'password', 'lmailbox', 'rmailbox',
                            'onlynew', 'del', 'markseen',
                            'loginfetch', 'acctcolor');

                    foreach ($plist as $pval) {
                        $params[$pval] = $account->getValue($pval, $id);
                    }
                    IMP_Fetchmail::fetchMail($params, true);
                }
            }
        }

    }

    /**
     * Returns the summary of the accounts to fetch email from.
     *
     * @access public
     *
     * @return string  The summary of the accounts to fetch email from.
     */
    function describeMaintenance()
    {
        global $prefs;

        $str  = _("You are about to fetch email from the following account(s):");
        $str .= "\n<blockquote>\n";

        if ($prefs->getValue('accounts')) {
            require_once IMP_BASE . '/lib/Fetchmail.php';
            $account = &new Account();
            foreach ($account->getAll('loginfetch') as $id => $val) {
                if ($val) {
                    $str .= " - ". $account->getValue('id', $id) . "<br />\n";
                }
            }
        }

        $str .= "\n</blockquote>\n<b>" . _("Note that this can take some time") . "</b>\n";
        return $str;
    }

}
