<?php
/**
 * The IMP_MIME_Viewer_related class handles multipart/related messages
 * as defined by RFC 2387.
 *
 * $Horde: imp/lib/MIME/Viewer/related.php,v 1.18 2003/06/15 23:41:42 slusarz Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.18 $
 * @since   IMP 4.0
 * @package horde.mime.viewer
 */
class IMP_MIME_Viewer_related extends MIME_Viewer {

    /**
     * Render out the currently set contents.
     *
     * @access public
     *
     * @param array $params  An array with a reference to a MIME_Contents
     *                       object.
     *
     * @return string  The rendered text in HTML.
     */
    function render($params)
    {
        $contents = &$params[0];

        $text = '';

        /* Look at the 'start' parameter to determine which part to start
           with. If no 'start' parameter, use the first part.
           RFC 2387 [3.1] */
        if ($this->mime_part->getContentTypeParameter('start') &&
            ($key = array_search($this->mime_part->getContentTypeParameter('start'), $this->mime_part->getCIDList()))) {
            if (($pos = strrpos($key, '.'))) {
                $id = substr($key, $pos + 1);
            } else {
                $id = $key;
            }
        } else {
            $id = $this->mime_part->getRelativeMimeID(1);
        }
        $start = $this->mime_part->getPart($id);

        /* Only display if the start part (normally text/html) can be displayed
           inline -OR- we are viewing this part as an attachment. */
        if ($contents->canDisplayInline($start) ||
            $contents->viewAsAttachment()) {
            $text = $contents->renderMIMEPart($start);
            $contents->removeIndex($start->getMIMEId());
        }

        return $text;
     }

    /**
     * Return the content-type.
     *
     * @access public
     *
     * @return string  The content-type of the message.
     */
    function getType()
    {
        return 'text/html';
    }

}
