<?php
/*
 * $Horde: imp/fetchmail.php,v 1.31 2003/06/17 07:53:44 slusarz Exp $
 *
 * Copyright 2002-2003 Nuno Loureiro <nuno@co.sapo.pt>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Fetchmail.php';

$account = &new Account();
$result = $to_edit = null;

$actionID = Horde::getFormData('actionID');

// Handle clients without javascript.
if (is_null($actionID)) {
    if (Horde::getPost('edit')) {
        $actionID = 'fetchmail_account_edit';
    } elseif (Horde::getPost('fetch')) {
        $actionID = 'fetchmail_account_fetch';
    } elseif (Horde::getPost('cancel')) {
        exit;
    }
}

/* Run through the action handlers. */
switch ($actionID) {
case 'fetchmail_account_edit':
    $to_edit = Horde::getFormData('account');
    break;

case 'fetchmail_account_fetch':
    $params = array();
    $plist = array('server', 'protocol', 'username', 'password', 'lmailbox',
                   'rmailbox', 'onlynew', 'del', 'markseen', 'loginfetch',
                   'acctcolor');

    foreach ($plist as $val) {
        $params[$val] = Horde::getFormData($val);
    }

    $result = IMP_Fetchmail::fetchMail($params);
    break;
}

$title = _("IMAP/POP3 Accounts");
$js_onLoad = null;
$accounts = $account->getAll('id');

require IMP_TEMPLATES . '/common-header.inc';

if ($prefs->getValue('fetchmail_popup')) {
    $cancel_js = 'window.close();';
} else {
    IMP::menu();

    if (!Horde::getFormData('lmailbox')) {
        $mbox = 'INBOX';
    } else {
        $mbox = Horde::getFormData('lmailbox');
    }
    $cancel_js = 'window.location = \'' . Horde::addParameter(Horde::applicationUrl('mailbox.php'), 'mailbox', $mbox) . '\';';
}

IMP::status();
$prefsPage = 'false';
require IMP_TEMPLATES . '/fetchmail/fetchmail_js.inc';
require IMP_TEMPLATES . '/fetchmail/fetchmail.inc';
require IMP_TEMPLATES . '/common-footer.inc';
