<?php

include_once 'Net/Sieve.php';

class Forwards_Driver_kolab extends Forwards_Driver
{
    var $_params;
    var $err_str;

    function Forwards_Driver_kolab($params = array())
    {
        $this->_params = $params;
    }

    function check_config(&$realm)
    {
        $realm = "default";
        return true;
    }

    function enableForwarding($user, $realm, $pass, $message, $keeplocal)
    {
        $sieve = new Net_Sieve($user . '@' . $realm, $pass);
        if (PEAR::isError($sieve->getError())) {
            $this->err_str = 'Unable to open sieve connection.';
            return false;
        }

        $script = 'redirect "' . $message . '";';

        if (PEAR::isError($sieve->installScript('kmail-vacation.siv', $script, true))) {
            $this->err_str = 'Unable to install sieve forwarding script.';
            return false;
        }

        return true;
    }

    function disableForwarding($user, $realm, $pass)
    {
        $sieve = new Net_Sieve($user . '@' . $realm, $pass);
        if (PEAR::isError($sieve->getError())) {
            $this->err_str = 'Unable to open sieve connection.';
            return false;
        }

        $script = $sieve->getActive();
        if (PEAR::isError($script)) {
            $this->err_str = 'Unable to query active sieve script.';
            return false;
        }

        if ($script == 'kmail-vacation.siv') {
            $fwd = $sieve->getScript($script);
            if (preg_match('/^redirect "[^"]*";/', $fwd) == 0) {
                $this->err_str = 'The active sieve script is not a forwarding instruction. Is a vaction message set?';
                return false;
            }
        } else {
            $this->err_str = 'The active sieve script is not the standard kolab forwarding script.';
            return false;
        }

        if (PEAR::isError($sieve->removeScript($script))) {
            $this->err_str = 'Unable to remove sieve forwarding script.';
            return false;
        }

        return true;
    }

    function isEnabledForwarding($user, $realm, $pass)
    {
        $sieve = new Net_Sieve($user . '@' . $realm, $pass);
        if (PEAR::isError($sieve->getError())) {
            $this->err_str = 'Unable to open sieve connection.';
            return false;
        }

        $script = $sieve->getActive();
        if (PEAR::isError($script)) {
            $this->err_str = 'Unable to query active sieve script.';
            return false;
        }

        if ($script == 'kmail-vacation.siv') {
            $fwd = $sieve->getScript($script);
            if (preg_match('/^redirect "[^"]*";/', $fwd) == 0) {
                $this->err_str = 'The active sieve script is not a forwarding instruction. Is a vaction message set?';
                return false;
            }
        } else {
            $this->err_str = 'The active sieve script is not the standard kolab forwarding script.';
            return false;
        }

        return true;
    }
}

?>
