/*
   SPDX-FileCopyrightText: 2024 Laurent Montel <montel.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "appcategoriesjobtest.h"
#include "apps/appcategoriesjob.h"
#include "ruqola_restapi_helper.h"
QTEST_GUILESS_MAIN(AppCategoriesJobTest)
using namespace RocketChatRestApi;
AppCategoriesJobTest::AppCategoriesJobTest(QObject *parent)
    : QObject(parent)
{
}

void AppCategoriesJobTest::shouldHaveDefaultValue()
{
    AppCategoriesJob job;
    verifyDefaultValue(&job);
    QVERIFY(job.requireHttpAuthentication());
    QVERIFY(!job.hasQueryParameterSupport());
}

void AppCategoriesJobTest::shouldGenerateRequest()
{
    AppCategoriesJob job;
    QNetworkRequest request = QNetworkRequest(QUrl());
    verifyAuthentication(&job, request);
    QCOMPARE(request.url(), QUrl(QStringLiteral("http://www.kde.org/api/apps/categories")));
}

#include "moc_appcategoriesjobtest.cpp"
