#include "uosaiinterface.h"

#include <QtDBus>
#include <QDBusMessage>

using namespace uos_ai;

UosAiInterface::UosAiInterface(QObject *parent)
    : QObject{parent}
{
    qDBusRegisterMetaType<QMap<QString, QString>>();
}

void UosAiInterface::sendFile(const QString &file) const
{
    inputPrompt("", file);
}

void UosAiInterface::summaryFile(const QString &file) const
{
    inputPrompt(tr("Summarize the content of this document"), file);
}

void UosAiInterface::translateFile(const QString &file) const
{
    inputPrompt(tr("Translate the document in its entirety"), file);
}

void UosAiInterface::correctFile(const QString &file) const
{
    inputPrompt(tr("Check for misspelt in this document"), file);
}

void UosAiInterface::addToKnowledgeBase(const QString &file) const
{
    QDBusMessage msg = QDBusMessage::createMethodCall("com.deepin.copilot", "/org/deepin/copilot/chat",
                                                      "org.deepin.copilot.chat", "sendToKnowledgeBase");
    QVariantList params;
    params.append(QStringList{file});
    msg.setArguments(params);

    auto con = QDBusConnection::sessionBus();
    con.asyncCall(msg);
}

void UosAiInterface::inputPrompt(const QString &question, const QString &file) const
{
    QDBusMessage msg = QDBusMessage::createMethodCall("com.deepin.copilot", "/org/deepin/copilot/chat",
                                                      "org.deepin.copilot.chat", "inputPrompt");
    QVariantList params;
    QMap<QString, QString> ext;
    ext.insert("file", file);
    ext.insert("defaultPrompt", question);
    params.append("");
    params.append(QVariant::fromValue(ext));
    msg.setArguments(params);

    auto con = QDBusConnection::sessionBus();
    con.asyncCall(msg);
}
