#ifndef WORDWIZARDWIDGET_H
#define WORDWIZARDWIDGET_H

#include <DWidget>
#include <DBackgroundGroup>

DWIDGET_USE_NAMESPACE

class ThemedLable;
class WordWizardItem;

class WordWizardWidget: public DWidget
{
    Q_OBJECT

public:
    explicit WordWizardWidget(DWidget *parent = nullptr);
    void updateHiddenStatus(bool isHidden);
    QString getTitleName();

signals:
    void signalChangeHiddenStatus(bool isHidden);

private slots:
    void onThemeTypeChanged();

private:
    void initUI();
    DBackgroundGroup *wordWizardWidget();




private:
    ThemedLable *m_pWidgetLabel = nullptr;
    DBackgroundGroup *m_pWordWizardWidget = nullptr;
    WordWizardItem *m_WordWizardItem = nullptr;
};

#endif // WORDWIZARDWIDGET_H
