#include "wordwizarditem.h"

#include <QHBoxLayout>
#include <QVBoxLayout>

#include <DFontSizeManager>

WordWizardItem::WordWizardItem(DWidget *parent)
    : DWidget(parent)
{
    initUI();
}

WordWizardItem::~WordWizardItem()
{

}

void WordWizardItem::initUI()
{
    m_pLabelTheme = new DLabel;
    DFontSizeManager::instance()->bind(m_pLabelTheme, DFontSizeManager::T6, QFont::Medium);
    m_pLabelTheme->setElideMode(Qt::ElideRight);
    m_pLabelSummary = new DLabel;
    DFontSizeManager::instance()->bind(m_pLabelSummary, DFontSizeManager::T8, QFont::Normal);
    m_pLabelSummary->setElideMode(Qt::ElideRight);

    QVBoxLayout *textLayout = new QVBoxLayout;
    textLayout->setContentsMargins(0, 0, 0, 0);
    textLayout->setSpacing(2);
    textLayout->addWidget(m_pLabelTheme, 0, Qt::AlignLeft);
    textLayout->addWidget(m_pLabelSummary, 0, Qt::AlignLeft);

    m_pBtnSwitch = new DSwitchButton;
    QHBoxLayout *mainLayout = new QHBoxLayout(this);
    mainLayout->setContentsMargins(10, 10, 10, 10);
    mainLayout->addLayout(textLayout);
    mainLayout->addStretch();
    mainLayout->addWidget(m_pBtnSwitch, 0, Qt::AlignVCenter);
    connect(m_pBtnSwitch, &DSwitchButton::checkedChanged, this, &WordWizardItem::signalSwitchChanged);

    setLayout(mainLayout);
}

void WordWizardItem::setText(const QString &theme, const QString &summary)
{
    m_pLabelTheme->setText(theme);
    m_pLabelSummary->setText(summary);
}

void WordWizardItem::setSwitchChecked(bool b)
{
    m_pBtnSwitch->setChecked(b);
}


