// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "chatdbusinterface.h"
#include "serverwrapper.h"

#include <QTimer>
#include <QDBusMetaType>

UOSAI_USE_NAMESPACE

ChatDBusInterface::ChatDBusInterface(ServerWrapper *parent)
    : QObject(parent)
    , QDBusContext()
    , m_server(parent)
{
    qDBusRegisterMetaType<QMap<QString, QString>>();
}

// params
// file: 上传文件的路径
// defaultPrompt: 默认提示词，用于暗文显示
void ChatDBusInterface::inputPrompt(const QString &question, const QMap<QString, QString> &params)
{
    if (question.isEmpty() && params.isEmpty())
        return;

    QTimer::singleShot(0, this, [&, question, params]{
        emit m_server->sigInputPrompt(question, params);
    });
}

void ChatDBusInterface::sendToKnowledgeBase(const QStringList &file)
{
    if (file.isEmpty())
        return;

    QTimer::singleShot(0, this, [&, file]{
        emit m_server->sigAddKnowledgeBase(file);
    });
}
