/**
 * Deepin官网
 * deepin的官方网站后台接口
 *
 * The version of the OpenAPI document: 1.0
 * Contact: wurongjie@deepin.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "DHClientApi.h"
#include "DHServerConfiguration.h"
#include <QJsonArray>
#include <QJsonDocument>

namespace DeepinHomeAPI {

DHClientApi::DHClientApi(const int timeOut)
    : _timeOut(timeOut),
      _manager(nullptr),
      _isResponseCompressionEnabled(false),
      _isRequestCompressionEnabled(false) {
    initializeServerConfigs();
}

DHClientApi::~DHClientApi() {
}

void DHClientApi::initializeServerConfigs() {
    //Default server
    QList<DHServerConfiguration> defaultConf = QList<DHServerConfiguration>();
    //varying endpoint server
    defaultConf.append(DHServerConfiguration(
    QUrl("//localhost:8888/api/v1"),
    "No description provided",
    QMap<QString, DHServerVariable>()));
    _serverConfigs.insert("addFeedbackView", defaultConf);
    _serverIndices.insert("addFeedbackView", 0);
    _serverConfigs.insert("clientLogin", defaultConf);
    _serverIndices.insert("clientLogin", 0);
    _serverConfigs.insert("createFeedback", defaultConf);
    _serverIndices.insert("createFeedback", 0);
    _serverConfigs.insert("createFeedbackRelation", defaultConf);
    _serverIndices.insert("createFeedbackRelation", 0);
    _serverConfigs.insert("getBBSToken", defaultConf);
    _serverIndices.insert("getBBSToken", 0);
    _serverConfigs.insert("getBBSURL", defaultConf);
    _serverIndices.insert("getBBSURL", 0);
    _serverConfigs.insert("getFeedback", defaultConf);
    _serverIndices.insert("getFeedback", 0);
    _serverConfigs.insert("getFeedbackRelation", defaultConf);
    _serverIndices.insert("getFeedbackRelation", 0);
    _serverConfigs.insert("getFeedbackReply", defaultConf);
    _serverIndices.insert("getFeedbackReply", 0);
    _serverConfigs.insert("getFeedbackStat", defaultConf);
    _serverIndices.insert("getFeedbackStat", 0);
    _serverConfigs.insert("getLanguageCode", defaultConf);
    _serverIndices.insert("getLanguageCode", 0);
    _serverConfigs.insert("getLoginConfig", defaultConf);
    _serverIndices.insert("getLoginConfig", 0);
    _serverConfigs.insert("getLoginInfo", defaultConf);
    _serverIndices.insert("getLoginInfo", 0);
    _serverConfigs.insert("getMessages", defaultConf);
    _serverIndices.insert("getMessages", 0);
    _serverConfigs.insert("getNodes", defaultConf);
    _serverIndices.insert("getNodes", 0);
    _serverConfigs.insert("getSetting", defaultConf);
    _serverIndices.insert("getSetting", 0);
    _serverConfigs.insert("getTopics", defaultConf);
    _serverIndices.insert("getTopics", 0);
    _serverConfigs.insert("getUserFeedback", defaultConf);
    _serverIndices.insert("getUserFeedback", 0);
    _serverConfigs.insert("preUpload", defaultConf);
    _serverIndices.insert("preUpload", 0);
    _serverConfigs.insert("removeFeedbackRelation", defaultConf);
    _serverIndices.insert("removeFeedbackRelation", 0);
}

/**
* returns 0 on success and -1, -2 or -3 on failure.
* -1 when the variable does not exist and -2 if the value is not defined in the enum and -3 if the operation or server index is not found
*/
int DHClientApi::setDefaultServerValue(int serverIndex, const QString &operation, const QString &variable, const QString &value) {
    auto it = _serverConfigs.find(operation);
    if (it != _serverConfigs.end() && serverIndex < it.value().size()) {
      return _serverConfigs[operation][serverIndex].setDefaultValue(variable,value);
    }
    return -3;
}
void DHClientApi::setServerIndex(const QString &operation, int serverIndex) {
    if (_serverIndices.contains(operation) && serverIndex < _serverConfigs.find(operation).value().size()) {
        _serverIndices[operation] = serverIndex;
    }
}

void DHClientApi::setApiKey(const QString &apiKeyName, const QString &apiKey) {
    _apiKeys.insert(apiKeyName, apiKey);
}

void DHClientApi::setBearerToken(const QString &token) {
    _bearerToken = token;
}

void DHClientApi::setUsername(const QString &username) {
    _username = username;
}

void DHClientApi::setPassword(const QString &password) {
    _password = password;
}


void DHClientApi::setTimeOut(const int timeOut) {
    _timeOut = timeOut;
}

void DHClientApi::setWorkingDirectory(const QString &path) {
    _workingDirectory = path;
}

void DHClientApi::setNetworkAccessManager(QNetworkAccessManager* manager) {
    _manager = manager;
}

/**
    * Appends a new ServerConfiguration to the config map for a specific operation.
    * @param operation The id to the target operation.
    * @param url A string that contains the URL of the server
    * @param description A String that describes the server
    * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
    * returns the index of the new server config on success and -1 if the operation is not found
    */
int DHClientApi::addServerConfiguration(const QString &operation, const QUrl &url, const QString &description, const QMap<QString, DHServerVariable> &variables) {
    if (_serverConfigs.contains(operation)) {
        _serverConfigs[operation].append(DHServerConfiguration(
                    url,
                    description,
                    variables));
        return _serverConfigs[operation].size()-1;
    } else {
        return -1;
    }
}

/**
    * Appends a new ServerConfiguration to the config map for a all operations and sets the index to that server.
    * @param url A string that contains the URL of the server
    * @param description A String that describes the server
    * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
    */
void DHClientApi::setNewServerForAllOperations(const QUrl &url, const QString &description, const QMap<QString, DHServerVariable> &variables) {
#if QT_VERSION >= QT_VERSION_CHECK(5, 12, 0)
    for (auto keyIt = _serverIndices.keyBegin(); keyIt != _serverIndices.keyEnd(); keyIt++) {
        setServerIndex(*keyIt, addServerConfiguration(*keyIt, url, description, variables));
    }
#else
    for (auto &e : _serverIndices.keys()) {
        setServerIndex(e, addServerConfiguration(e, url, description, variables));
    }
#endif
}

/**
    * Appends a new ServerConfiguration to the config map for an operations and sets the index to that server.
    * @param URL A string that contains the URL of the server
    * @param description A String that describes the server
    * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
    */
void DHClientApi::setNewServer(const QString &operation, const QUrl &url, const QString &description, const QMap<QString, DHServerVariable> &variables) {
    setServerIndex(operation, addServerConfiguration(operation, url, description, variables));
}

void DHClientApi::addHeaders(const QString &key, const QString &value) {
    _defaultHeaders.insert(key, value);
}

void DHClientApi::enableRequestCompression() {
    _isRequestCompressionEnabled = true;
}

void DHClientApi::enableResponseCompression() {
    _isResponseCompressionEnabled = true;
}

void DHClientApi::abortRequests() {
    emit abortRequestsSignal();
}

QString DHClientApi::getParamStylePrefix(const QString &style) {
    if (style == "matrix") {
        return ";";
    } else if (style == "label") {
        return ".";
    } else if (style == "form") {
        return "&";
    } else if (style == "simple") {
        return "";
    } else if (style == "spaceDelimited") {
        return "&";
    } else if (style == "pipeDelimited") {
        return "&";
    } else {
        return "none";
    }
}

QString DHClientApi::getParamStyleSuffix(const QString &style) {
    if (style == "matrix") {
        return "=";
    } else if (style == "label") {
        return "";
    } else if (style == "form") {
        return "=";
    } else if (style == "simple") {
        return "";
    } else if (style == "spaceDelimited") {
        return "=";
    } else if (style == "pipeDelimited") {
        return "=";
    } else {
        return "none";
    }
}

QString DHClientApi::getParamStyleDelimiter(const QString &style, const QString &name, bool isExplode) {

    if (style == "matrix") {
        return (isExplode) ? ";" + name + "=" : ",";

    } else if (style == "label") {
        return (isExplode) ? "." : ",";

    } else if (style == "form") {
        return (isExplode) ? "&" + name + "=" : ",";

    } else if (style == "simple") {
        return ",";
    } else if (style == "spaceDelimited") {
        return (isExplode) ? "&" + name + "=" : " ";

    } else if (style == "pipeDelimited") {
        return (isExplode) ? "&" + name + "=" : "|";

    } else if (style == "deepObject") {
        return (isExplode) ? "&" : "none";

    } else {
        return "none";
    }
}

void DHClientApi::addFeedbackView(const QString &id) {
    QString fullPath = QString(_serverConfigs["addFeedbackView"][_serverIndices.value("addFeedbackView")].URL()+"/public/feedback/view/{id}");
    
    
    {
        QString idPathParam("{");
        idPathParam.append("id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"id"+pathSuffix : pathPrefix;
        fullPath.replace(idPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(id)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "POST");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::addFeedbackViewCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::addFeedbackViewCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHFeedback_PublicViewResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit addFeedbackViewSignal(output);
        emit addFeedbackViewSignalFull(worker, output);
    } else {
        emit addFeedbackViewSignalE(output, error_type, error_str);
        emit addFeedbackViewSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::clientLogin(const DHHandlers_ClientLoginRequest &data) {
    QString fullPath = QString(_serverConfigs["clientLogin"][_serverIndices.value("clientLogin")].URL()+"/user/login");
    
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "POST");

    {

        
        QByteArray output = data.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::clientLoginCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::clientLoginCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_ClientLoginResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit clientLoginSignal(output);
        emit clientLoginSignalFull(worker, output);
    } else {
        emit clientLoginSignalE(output, error_type, error_str);
        emit clientLoginSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::createFeedback(const DHFeedback_CreateFeedbackRequest &data) {
    QString fullPath = QString(_serverConfigs["createFeedback"][_serverIndices.value("createFeedback")].URL()+"/user/feedback");
    
    if (_apiKeys.contains("Authorization")) {
        addHeaders("Authorization",_apiKeys.find("Authorization").value());
    }
    
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "POST");

    {

        
        QByteArray output = data.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::createFeedbackCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::createFeedbackCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHFeedback_CreateFeedbackResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit createFeedbackSignal(output);
        emit createFeedbackSignalFull(worker, output);
    } else {
        emit createFeedbackSignalE(output, error_type, error_str);
        emit createFeedbackSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::createFeedbackRelation(const QString &id, const QString &relation) {
    QString fullPath = QString(_serverConfigs["createFeedbackRelation"][_serverIndices.value("createFeedbackRelation")].URL()+"/user/feedback/{id}/{relation}");
    
    if (_apiKeys.contains("Authorization")) {
        addHeaders("Authorization",_apiKeys.find("Authorization").value());
    }
    
    
    {
        QString idPathParam("{");
        idPathParam.append("id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"id"+pathSuffix : pathPrefix;
        fullPath.replace(idPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(id)));
    }
    
    {
        QString relationPathParam("{");
        relationPathParam.append("relation").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "relation", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"relation"+pathSuffix : pathPrefix;
        fullPath.replace(relationPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(relation)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "POST");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::createFeedbackRelationCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::createFeedbackRelationCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHFeedback_UserRelationResposne output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit createFeedbackRelationSignal(output);
        emit createFeedbackRelationSignalFull(worker, output);
    } else {
        emit createFeedbackRelationSignalE(output, error_type, error_str);
        emit createFeedbackRelationSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getBBSToken(const DHHandlers_ClientBBSTokenRequest &data) {
    QString fullPath = QString(_serverConfigs["getBBSToken"][_serverIndices.value("getBBSToken")].URL()+"/public/login/bbs_token");
    
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "POST");

    {

        
        QByteArray output = data.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getBBSTokenCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getBBSTokenCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_ClientBBSTokenResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getBBSTokenSignal(output);
        emit getBBSTokenSignalFull(worker, output);
    } else {
        emit getBBSTokenSignalE(output, error_type, error_str);
        emit getBBSTokenSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getBBSURL(const DHHandlers_BBSURLRequest &data) {
    QString fullPath = QString(_serverConfigs["getBBSURL"][_serverIndices.value("getBBSURL")].URL()+"/public/login/bbs_url");
    
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "POST");

    {

        
        QByteArray output = data.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getBBSURLCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getBBSURLCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_BBSURLResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getBBSURLSignal(output);
        emit getBBSURLSignalFull(worker, output);
    } else {
        emit getBBSURLSignalE(output, error_type, error_str);
        emit getBBSURLSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getFeedback(const double &offset, const double &limit, const ::DeepinHomeAPI::OptionalParam<QString> &type, const ::DeepinHomeAPI::OptionalParam<QList<QString>> &status, const ::DeepinHomeAPI::OptionalParam<QList<QString>> &public_id, const ::DeepinHomeAPI::OptionalParam<QString> &language, const ::DeepinHomeAPI::OptionalParam<QString> &order, const ::DeepinHomeAPI::OptionalParam<QString> &version, const ::DeepinHomeAPI::OptionalParam<QString> &keyword) {
    QString fullPath = QString(_serverConfigs["getFeedback"][_serverIndices.value("getFeedback")].URL()+"/public/feedback");
    
    QString queryPrefix, querySuffix, queryDelimiter, queryStyle;
    if (type.hasValue())
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "type", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("type")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(type.value())));
    }
    if (status.hasValue())
    {
        queryStyle = "form";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "status", true);
        if (status.value().size() > 0) {
            if (QString("multi").indexOf("multi") == 0) {
                for (QString t : status.value()) {
                    if (fullPath.indexOf("?") > 0)
                        fullPath.append(queryPrefix);
                    else
                        fullPath.append("?");
                    fullPath.append("status=").append(::DeepinHomeAPI::toStringValue(t));
                }
            } else if (QString("multi").indexOf("ssv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("status").append(querySuffix);
                qint32 count = 0;
                for (QString t : status.value()) {
                    if (count > 0) {
                        fullPath.append((true)? queryDelimiter : QUrl::toPercentEncoding(queryDelimiter));
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("tsv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("status").append(querySuffix);
                qint32 count = 0;
                for (QString t : status.value()) {
                    if (count > 0) {
                        fullPath.append("\t");
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("csv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("status").append(querySuffix);
                qint32 count = 0;
                for (QString t : status.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("pipes") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("status").append(querySuffix);
                qint32 count = 0;
                for (QString t : status.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("deepObject") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("status").append(querySuffix);
                qint32 count = 0;
                for (QString t : status.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            }
        }
    }
    if (public_id.hasValue())
    {
        queryStyle = "form";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "public_id", true);
        if (public_id.value().size() > 0) {
            if (QString("multi").indexOf("multi") == 0) {
                for (QString t : public_id.value()) {
                    if (fullPath.indexOf("?") > 0)
                        fullPath.append(queryPrefix);
                    else
                        fullPath.append("?");
                    fullPath.append("public_id=").append(::DeepinHomeAPI::toStringValue(t));
                }
            } else if (QString("multi").indexOf("ssv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("public_id").append(querySuffix);
                qint32 count = 0;
                for (QString t : public_id.value()) {
                    if (count > 0) {
                        fullPath.append((true)? queryDelimiter : QUrl::toPercentEncoding(queryDelimiter));
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("tsv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("public_id").append(querySuffix);
                qint32 count = 0;
                for (QString t : public_id.value()) {
                    if (count > 0) {
                        fullPath.append("\t");
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("csv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("public_id").append(querySuffix);
                qint32 count = 0;
                for (QString t : public_id.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("pipes") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("public_id").append(querySuffix);
                qint32 count = 0;
                for (QString t : public_id.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("deepObject") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("public_id").append(querySuffix);
                qint32 count = 0;
                for (QString t : public_id.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            }
        }
    }
    if (language.hasValue())
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "language", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("language")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(language.value())));
    }
    if (order.hasValue())
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "order", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("order")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(order.value())));
    }
    if (version.hasValue())
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "version", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("version")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(version.value())));
    }
    if (keyword.hasValue())
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "keyword", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("keyword")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(keyword.value())));
    }
    
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "offset", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("offset")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(offset)));
    }
    
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "limit", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("limit")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(limit)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getFeedbackCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getFeedbackCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    QList<DHFeedback_PublicListResponse> output;
    QString json(worker->response);
    QByteArray array(json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonArray jsonArray = doc.array();
    for (QJsonValue obj : jsonArray) {
        DHFeedback_PublicListResponse val;
        ::DeepinHomeAPI::fromJsonValue(val, obj);
        output.append(val);
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getFeedbackSignal(output);
        emit getFeedbackSignalFull(worker, output);
    } else {
        emit getFeedbackSignalE(output, error_type, error_str);
        emit getFeedbackSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getFeedbackRelation(const double &offset, const double &limit, const ::DeepinHomeAPI::OptionalParam<QList<QString>> &id, const ::DeepinHomeAPI::OptionalParam<QList<QString>> &relation) {
    QString fullPath = QString(_serverConfigs["getFeedbackRelation"][_serverIndices.value("getFeedbackRelation")].URL()+"/user/feedback/relation");
    
    if (_apiKeys.contains("Authorization")) {
        addHeaders("Authorization",_apiKeys.find("Authorization").value());
    }
    
    QString queryPrefix, querySuffix, queryDelimiter, queryStyle;
    if (id.hasValue())
    {
        queryStyle = "form";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "id", true);
        if (id.value().size() > 0) {
            if (QString("multi").indexOf("multi") == 0) {
                for (QString t : id.value()) {
                    if (fullPath.indexOf("?") > 0)
                        fullPath.append(queryPrefix);
                    else
                        fullPath.append("?");
                    fullPath.append("id=").append(::DeepinHomeAPI::toStringValue(t));
                }
            } else if (QString("multi").indexOf("ssv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id.value()) {
                    if (count > 0) {
                        fullPath.append((true)? queryDelimiter : QUrl::toPercentEncoding(queryDelimiter));
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("tsv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id.value()) {
                    if (count > 0) {
                        fullPath.append("\t");
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("csv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("pipes") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("deepObject") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            }
        }
    }
    if (relation.hasValue())
    {
        queryStyle = "form";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "relation", true);
        if (relation.value().size() > 0) {
            if (QString("multi").indexOf("multi") == 0) {
                for (QString t : relation.value()) {
                    if (fullPath.indexOf("?") > 0)
                        fullPath.append(queryPrefix);
                    else
                        fullPath.append("?");
                    fullPath.append("relation=").append(::DeepinHomeAPI::toStringValue(t));
                }
            } else if (QString("multi").indexOf("ssv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("relation").append(querySuffix);
                qint32 count = 0;
                for (QString t : relation.value()) {
                    if (count > 0) {
                        fullPath.append((true)? queryDelimiter : QUrl::toPercentEncoding(queryDelimiter));
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("tsv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("relation").append(querySuffix);
                qint32 count = 0;
                for (QString t : relation.value()) {
                    if (count > 0) {
                        fullPath.append("\t");
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("csv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("relation").append(querySuffix);
                qint32 count = 0;
                for (QString t : relation.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("pipes") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("relation").append(querySuffix);
                qint32 count = 0;
                for (QString t : relation.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("deepObject") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("relation").append(querySuffix);
                qint32 count = 0;
                for (QString t : relation.value()) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            }
        }
    }
    
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "offset", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("offset")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(offset)));
    }
    
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "limit", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("limit")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(limit)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getFeedbackRelationCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getFeedbackRelationCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    QList<DHFeedback_UserRelationListResponse> output;
    QString json(worker->response);
    QByteArray array(json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonArray jsonArray = doc.array();
    for (QJsonValue obj : jsonArray) {
        DHFeedback_UserRelationListResponse val;
        ::DeepinHomeAPI::fromJsonValue(val, obj);
        output.append(val);
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getFeedbackRelationSignal(output);
        emit getFeedbackRelationSignalFull(worker, output);
    } else {
        emit getFeedbackRelationSignalE(output, error_type, error_str);
        emit getFeedbackRelationSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getFeedbackReply(const QString &id) {
    QString fullPath = QString(_serverConfigs["getFeedbackReply"][_serverIndices.value("getFeedbackReply")].URL()+"/public/feedback/reply");
    
    QString queryPrefix, querySuffix, queryDelimiter, queryStyle;
    
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "id", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("id")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(id)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getFeedbackReplyCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getFeedbackReplyCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    QList<DHFeedback_PublicReplyResponse> output;
    QString json(worker->response);
    QByteArray array(json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonArray jsonArray = doc.array();
    for (QJsonValue obj : jsonArray) {
        DHFeedback_PublicReplyResponse val;
        ::DeepinHomeAPI::fromJsonValue(val, obj);
        output.append(val);
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getFeedbackReplySignal(output);
        emit getFeedbackReplySignalFull(worker, output);
    } else {
        emit getFeedbackReplySignalE(output, error_type, error_str);
        emit getFeedbackReplySignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getFeedbackStat(const QList<QString> &id) {
    QString fullPath = QString(_serverConfigs["getFeedbackStat"][_serverIndices.value("getFeedbackStat")].URL()+"/public/feedback/stat");
    
    QString queryPrefix, querySuffix, queryDelimiter, queryStyle;
    
    {
        queryStyle = "form";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "id", true);
        if (id.size() > 0) {
            if (QString("multi").indexOf("multi") == 0) {
                for (QString t : id) {
                    if (fullPath.indexOf("?") > 0)
                        fullPath.append(queryPrefix);
                    else
                        fullPath.append("?");
                    fullPath.append("id=").append(::DeepinHomeAPI::toStringValue(t));
                }
            } else if (QString("multi").indexOf("ssv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id) {
                    if (count > 0) {
                        fullPath.append((true)? queryDelimiter : QUrl::toPercentEncoding(queryDelimiter));
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("tsv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id) {
                    if (count > 0) {
                        fullPath.append("\t");
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("csv") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("pipes") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            } else if (QString("multi").indexOf("deepObject") == 0) {
                if (fullPath.indexOf("?") > 0)
                    fullPath.append("&");
                else
                    fullPath.append("?").append(queryPrefix).append("id").append(querySuffix);
                qint32 count = 0;
                for (QString t : id) {
                    if (count > 0) {
                        fullPath.append(queryDelimiter);
                    }
                    fullPath.append(::DeepinHomeAPI::toStringValue(t));
                    count++;
                }
            }
        }
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getFeedbackStatCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getFeedbackStatCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    QList<DHFeedback_PublicStatResponse> output;
    QString json(worker->response);
    QByteArray array(json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonArray jsonArray = doc.array();
    for (QJsonValue obj : jsonArray) {
        DHFeedback_PublicStatResponse val;
        ::DeepinHomeAPI::fromJsonValue(val, obj);
        output.append(val);
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getFeedbackStatSignal(output);
        emit getFeedbackStatSignalFull(worker, output);
    } else {
        emit getFeedbackStatSignalE(output, error_type, error_str);
        emit getFeedbackStatSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getLanguageCode(const QString &code) {
    QString fullPath = QString(_serverConfigs["getLanguageCode"][_serverIndices.value("getLanguageCode")].URL()+"/public/language/{code}");
    
    
    {
        QString codePathParam("{");
        codePathParam.append("code").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "code", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"code"+pathSuffix : pathPrefix;
        fullPath.replace(codePathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(code)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getLanguageCodeCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getLanguageCodeCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_LanguageCodeResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getLanguageCodeSignal(output);
        emit getLanguageCodeSignalFull(worker, output);
    } else {
        emit getLanguageCodeSignalE(output, error_type, error_str);
        emit getLanguageCodeSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getLoginConfig() {
    QString fullPath = QString(_serverConfigs["getLoginConfig"][_serverIndices.value("getLoginConfig")].URL()+"/public/login/config");
    
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getLoginConfigCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getLoginConfigCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_LoginConfigResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getLoginConfigSignal(output);
        emit getLoginConfigSignalFull(worker, output);
    } else {
        emit getLoginConfigSignalE(output, error_type, error_str);
        emit getLoginConfigSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getLoginInfo() {
    QString fullPath = QString(_serverConfigs["getLoginInfo"][_serverIndices.value("getLoginInfo")].URL()+"/user/login");
    
    if (_apiKeys.contains("Authorization")) {
        addHeaders("Authorization",_apiKeys.find("Authorization").value());
    }
    
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getLoginInfoCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getLoginInfoCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_ClientUserInfoResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getLoginInfoSignal(output);
        emit getLoginInfoSignalFull(worker, output);
    } else {
        emit getLoginInfoSignalE(output, error_type, error_str);
        emit getLoginInfoSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getMessages(const QString &channel_id, const QString &topic_id, const QString &language) {
    QString fullPath = QString(_serverConfigs["getMessages"][_serverIndices.value("getMessages")].URL()+"/public/channel/{channel_id}/topic/{topic_id}/messages");
    
    
    {
        QString channel_idPathParam("{");
        channel_idPathParam.append("channel_id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "channel_id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"channel_id"+pathSuffix : pathPrefix;
        fullPath.replace(channel_idPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(channel_id)));
    }
    
    {
        QString topic_idPathParam("{");
        topic_idPathParam.append("topic_id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "topic_id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"topic_id"+pathSuffix : pathPrefix;
        fullPath.replace(topic_idPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(topic_id)));
    }
    QString queryPrefix, querySuffix, queryDelimiter, queryStyle;
    
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "language", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("language")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(language)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getMessagesCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getMessagesCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    QList<DHHandlers_ClientMessagesResponse> output;
    QString json(worker->response);
    QByteArray array(json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonArray jsonArray = doc.array();
    for (QJsonValue obj : jsonArray) {
        DHHandlers_ClientMessagesResponse val;
        ::DeepinHomeAPI::fromJsonValue(val, obj);
        output.append(val);
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getMessagesSignal(output);
        emit getMessagesSignalFull(worker, output);
    } else {
        emit getMessagesSignalE(output, error_type, error_str);
        emit getMessagesSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getNodes(const QString &machine_id) {
    QString fullPath = QString(_serverConfigs["getNodes"][_serverIndices.value("getNodes")].URL()+"/public/machine/{machine_id}/node");
    
    
    {
        QString machine_idPathParam("{");
        machine_idPathParam.append("machine_id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "machine_id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"machine_id"+pathSuffix : pathPrefix;
        fullPath.replace(machine_idPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(machine_id)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getNodesCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getNodesCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_NodeSelectResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getNodesSignal(output);
        emit getNodesSignalFull(worker, output);
    } else {
        emit getNodesSignalE(output, error_type, error_str);
        emit getNodesSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getSetting(const QString &key) {
    QString fullPath = QString(_serverConfigs["getSetting"][_serverIndices.value("getSetting")].URL()+"/public/setting/{key}");
    
    
    {
        QString keyPathParam("{");
        keyPathParam.append("key").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "key", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"key"+pathSuffix : pathPrefix;
        fullPath.replace(keyPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(key)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getSettingCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getSettingCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_GetStetingResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getSettingSignal(output);
        emit getSettingSignalFull(worker, output);
    } else {
        emit getSettingSignalE(output, error_type, error_str);
        emit getSettingSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getTopics(const QString &channel_id) {
    QString fullPath = QString(_serverConfigs["getTopics"][_serverIndices.value("getTopics")].URL()+"/public/channel/{channel_id}/topics");
    
    
    {
        QString channel_idPathParam("{");
        channel_idPathParam.append("channel_id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "channel_id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"channel_id"+pathSuffix : pathPrefix;
        fullPath.replace(channel_idPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(channel_id)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getTopicsCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getTopicsCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_PublicTopicsResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getTopicsSignal(output);
        emit getTopicsSignalFull(worker, output);
    } else {
        emit getTopicsSignalE(output, error_type, error_str);
        emit getTopicsSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::getUserFeedback(const double &offset, const double &limit, const ::DeepinHomeAPI::OptionalParam<QString> &type, const ::DeepinHomeAPI::OptionalParam<QString> &status) {
    QString fullPath = QString(_serverConfigs["getUserFeedback"][_serverIndices.value("getUserFeedback")].URL()+"/user/feedback");
    
    if (_apiKeys.contains("Authorization")) {
        addHeaders("Authorization",_apiKeys.find("Authorization").value());
    }
    
    QString queryPrefix, querySuffix, queryDelimiter, queryStyle;
    if (type.hasValue())
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "type", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("type")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(type.value())));
    }
    if (status.hasValue())
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "status", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("status")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(status.value())));
    }
    
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "offset", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("offset")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(offset)));
    }
    
    {
        queryStyle = "";
        if (queryStyle == "")
            queryStyle = "form";
        queryPrefix = getParamStylePrefix(queryStyle);
        querySuffix = getParamStyleSuffix(queryStyle);
        queryDelimiter = getParamStyleDelimiter(queryStyle, "limit", false);
        if (fullPath.indexOf("?") > 0)
            fullPath.append(queryPrefix);
        else
            fullPath.append("?");

        fullPath.append(QUrl::toPercentEncoding("limit")).append(querySuffix).append(QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(limit)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::getUserFeedbackCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::getUserFeedbackCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    QList<DHFeedback_UserListResponse> output;
    QString json(worker->response);
    QByteArray array(json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonArray jsonArray = doc.array();
    for (QJsonValue obj : jsonArray) {
        DHFeedback_UserListResponse val;
        ::DeepinHomeAPI::fromJsonValue(val, obj);
        output.append(val);
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getUserFeedbackSignal(output);
        emit getUserFeedbackSignalFull(worker, output);
    } else {
        emit getUserFeedbackSignalE(output, error_type, error_str);
        emit getUserFeedbackSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::preUpload(const DHHandlers_PreUploadRequest &data) {
    QString fullPath = QString(_serverConfigs["preUpload"][_serverIndices.value("preUpload")].URL()+"/user/upload/pre");
    
    if (_apiKeys.contains("Authorization")) {
        addHeaders("Authorization",_apiKeys.find("Authorization").value());
    }
    
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "POST");

    {

        
        QByteArray output = data.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::preUploadCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::preUploadCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHHandlers_PreUploadResponse output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit preUploadSignal(output);
        emit preUploadSignalFull(worker, output);
    } else {
        emit preUploadSignalE(output, error_type, error_str);
        emit preUploadSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::removeFeedbackRelation(const QString &id, const QString &relation) {
    QString fullPath = QString(_serverConfigs["removeFeedbackRelation"][_serverIndices.value("removeFeedbackRelation")].URL()+"/user/feedback/{id}/{relation}");
    
    if (_apiKeys.contains("Authorization")) {
        addHeaders("Authorization",_apiKeys.find("Authorization").value());
    }
    
    
    {
        QString idPathParam("{");
        idPathParam.append("id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"id"+pathSuffix : pathPrefix;
        fullPath.replace(idPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(id)));
    }
    
    {
        QString relationPathParam("{");
        relationPathParam.append("relation").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "relation", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"relation"+pathSuffix : pathPrefix;
        fullPath.replace(relationPathParam, paramString+QUrl::toPercentEncoding(::DeepinHomeAPI::toStringValue(relation)));
    }
    DHHttpRequestWorker *worker = new DHHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    DHHttpRequestInput input(fullPath, "DELETE");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &DHHttpRequestWorker::on_execution_finished, this, &DHClientApi::removeFeedbackRelationCallback);
    connect(this, &DHClientApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<DHHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void DHClientApi::removeFeedbackRelationCallback(DHHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    DHFeedback_UserRelationResposne output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit removeFeedbackRelationSignal(output);
        emit removeFeedbackRelationSignalFull(worker, output);
    } else {
        emit removeFeedbackRelationSignalE(output, error_type, error_str);
        emit removeFeedbackRelationSignalEFull(worker, error_type, error_str);
    }
}

void DHClientApi::tokenAvailable(){

    oauthToken token;
    switch (_OauthMethod) {
    case 1: //implicit flow
        token = _implicitFlow.getToken(_latestScope.join(" "));
        if(token.isValid()){
            _latestInput.headers.insert("Authorization", "Bearer " + token.getToken());
            _latestWorker->execute(&_latestInput);
        }else{
            _implicitFlow.removeToken(_latestScope.join(" "));
            qDebug() << "Could not retrieve a valid token";
        }
        break;
    case 2: //authorization flow
        token = _authFlow.getToken(_latestScope.join(" "));
        if(token.isValid()){
            _latestInput.headers.insert("Authorization", "Bearer " + token.getToken());
            _latestWorker->execute(&_latestInput);
        }else{
            _authFlow.removeToken(_latestScope.join(" "));
            qDebug() << "Could not retrieve a valid token";
        }
        break;
    case 3: //client credentials flow
        token = _credentialFlow.getToken(_latestScope.join(" "));
        if(token.isValid()){
            _latestInput.headers.insert("Authorization", "Bearer " + token.getToken());
            _latestWorker->execute(&_latestInput);
        }else{
            _credentialFlow.removeToken(_latestScope.join(" "));
            qDebug() << "Could not retrieve a valid token";
        }
        break;
    case 4: //resource owner password flow
        token = _passwordFlow.getToken(_latestScope.join(" "));
        if(token.isValid()){
            _latestInput.headers.insert("Authorization", "Bearer " + token.getToken());
            _latestWorker->execute(&_latestInput);
        }else{
            _credentialFlow.removeToken(_latestScope.join(" "));
            qDebug() << "Could not retrieve a valid token";
        }
        break;
    default:
        qDebug() << "No Oauth method set!";
        break;
    }
}
} // namespace DeepinHomeAPI
