#include <cstdio>
#include <cstdarg>
#include <string.h>
#include <vector>
#include <ctime>
#include "logger.h"

static const char *DEBUG_ENV = "DEBUG_SDK";

Logger::Logger()
{
    char *sdk = getenv(DEBUG_ENV);

    m_enable = (sdk && !strcmp(sdk, "ON"));
}

void Logger::Print(const char *fmt, ...) const
{
    if (m_enable) {
        int ret = 0;
        std::time_t t = std::time(nullptr);
        char time_buf[100] = {0};
        std::strftime(time_buf, sizeof time_buf, "%D %T", std::localtime(&t));

        va_list ap;
        va_list ap_dump;
        va_start(ap, fmt);
        va_copy(ap_dump, ap);
        ret = std::vsnprintf(nullptr, 0, fmt, ap);
        std::vector<char> vecbuff(1 + ret);
        va_end(ap);
        ret = std::vsnprintf(vecbuff.data(), vecbuff.size(), fmt, ap_dump);
        va_end(ap_dump);

        if (ret > 0)
            printf("[%s]:%s\n", time_buf, vecbuff.data());
    }
}
