/*	mainwindow.h
	Copyright (C) 2004-2007 Mark Tyler and Dmitry Groshev

	This file is part of rgbPaint.

	rgbPaint is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	rgbPaint is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with rgbPaint in the file COPYING.
*/


#include <gtk/gtk.h>

/* Keyboard action codes */
#define ACT_QUIT	1
#define ACT_ZOOM_IN	2
#define ACT_ZOOM_OUT	3
#define ACT_ZOOM_01	4
#define ACT_ZOOM_025	5
#define ACT_ZOOM_05	6
#define ACT_ZOOM_1	7
#define ACT_ZOOM_4	8
#define ACT_ZOOM_8	9
#define ACT_ZOOM_12	10
#define ACT_ZOOM_16	11
#define ACT_ZOOM_20	12
#define ACT_VIEW	13
#define ACT_BRCOSA	14
#define ACT_PAN		15
#define ACT_CROP	16
#define ACT_SWAP_AB	17
#define ACT_CMDLINE	18
#define ACT_PATTERN	19
#define ACT_BRUSH	20
#define ACT_PAINT	21
#define ACT_SELECT	22
#define ACT_SEL_2LEFT	23
#define ACT_SEL_2RIGHT	24
#define ACT_SEL_2DOWN	25
#define ACT_SEL_2UP	26
#define ACT_SEL_LEFT	27
#define ACT_SEL_RIGHT	28
#define ACT_SEL_DOWN	29
#define ACT_SEL_UP	30
#define ACT_LR_2LEFT	43
#define ACT_LR_2RIGHT	44
#define ACT_LR_2DOWN	45
#define ACT_LR_2UP	46
#define ACT_LR_LEFT	47
#define ACT_LR_RIGHT	48
#define ACT_LR_DOWN	49
#define ACT_LR_UP	50
#define ACT_ESC		51
#define ACT_SCALE	52
#define ACT_SIZE	53
#define ACT_COMMIT	54
#define ACT_RCLICK	55
#define ACT_ARROW	56
#define ACT_ARROW3	57

int wtf_pressed(GdkEventKey *event);

GtkWidget
	*main_window, *drawing_canvas, *vbox_right, *scrolledwindow_canvas,

	*menu_undo[5], *menu_redo[5], *menu_crop[5],
	*menu_need_marquee[10], *menu_need_selection[20], *menu_need_clipboard[30]
	;

gboolean drag_index;
int files_passed, file_arg_start, drag_index_vals[2], cursor_corner, stamp_start,
	global_argc;
char **global_argv;

void main_init( int window_id );			// Initialise and display the main window
gint delete_event( GtkWidget *widget, GdkEvent *event, gpointer data );

void men_item_state( GtkWidget *menu_items[], gboolean state );
	// Change state of preset menu items

void canvas_size(int *w, int *h);	// Get zoomed canvas size
void main_update_area(int x, int y, int w, int h);	// Update x,y,w,h area of current image
void repaint_canvas( int px, int py, int pw, int ph );		// Redraw area of canvas
void repaint_perim();			// Draw perimeter around mouse cursor
void clear_perim();			// Clear perimeter around mouse cursor
void setup_row(int x0, int width, double czoom, int mw, int xpm, int opac,
	int bpp, png_color *pal);
void render_row(unsigned char *rgb, chanlist base_img, int x, int y,
	chanlist xtra_img);
void overlay_row(unsigned char *rgb, chanlist base_img, int x, int y,
	chanlist xtra_img);
void repaint_paste( int px1, int py1, int px2, int py2 );
void main_render_rgb( unsigned char *rgb, int px, int py, int pw, int ph );

void spot_undo(int mode);		// Take snapshot for undo
void set_cursor();			// Set mouse cursor
void set_cursor_type(GdkCursorType type);	// Set mouse cursor type
int check_for_changes(gchar *type);		// return: 1=STOP, 2=IGNORE, 10=ESCAPE, -10=NOT CHECKED

//	Try to save file + warn if error + return < 0 if fail
int gui_save(char *filename, ls_settings *settings);

void pressed_select_none( GtkMenuItem *menu_item, gpointer user_data );

gint check_zoom_keys(int action);
gint check_zoom_keys_real(int action);

void zoom_in();
void zoom_out();

void notify_changed();		// Image/palette has just changed - update vars as needed
void notify_unchanged();	// Image/palette has just been unchanged (saved) - update vars as needed
void update_titlebar();		// Update filename in titlebar

void force_main_configure();	// Force reconfigure of main drawing area - for centralizing code


void toolbar_icon_event2(GtkWidget *widget, gpointer data);
void men_dis_add( GtkWidget *widget, GtkWidget *menu_items[] );
