% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmissionTrees.R
\name{wiwMedTree}
\alias{wiwMedTree}
\title{Median transmission tree}
\usage{
wiwMedTree(matList, sampled = NULL, weights = NULL)
}
\arguments{
\item{matList}{a list of matrices, each of which is the output of \code{findMRCIs$mrciDepths}}

\item{sampled}{a vector of node IDs which corresponds to those nodes which are sampled cases}

\item{weights}{optional vector of weights to correspond to the entries of matList}
}
\value{
Returns three objects:
\itemize{
\item \code{centre}: the mean of the matList entries, restricted to the sampled cases
\item \code{distances}: for each entry of matList, its distance from \code{centre}
\item \code{mindist}: the minimum of \code{distances}
\item \code{median}: the number of the median entry of matList, i.e. the one(s) which achieve the \code{mindist} from the \code{centre}.
}
}
\description{
Function to find the median of a list of transmission scenarios
}
\examples{
# create some simple "who infected whom" scenarios:
tree1 <- cbind(Infector=1:5,Infectee=2:6) 
tree2 <- cbind(Infector=c(1,5,2,2,3),Infectee=2:6)
tree3 <- cbind(Infector=c(2,2,3,4,5),Infectee=c(1,3,4,5,6)) 
# create list of the MRCI depth matrices:
matList <- lapply(list(tree1,tree2,tree3), function(x) findMRCIs(x)$mrciDepths)

# median tree, assuming all cases are sampled:
wiwMedTree(matList)
# median tree when cases 1, 2 and 4 are sampled:
wiwMedTree(matList, sampled=c(1,2,4))

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
