# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class DeidentificationContent(_model_base.Model):
    """Request body for de-identification operation.

    All required parameters must be populated in order to send to server.

    :ivar input_text: Input text to de-identify. Required.
    :vartype input_text: str
    :ivar operation: Operation to perform on the input. Known values are: "Redact", "Surrogate",
     and "Tag".
    :vartype operation: str or ~azure.health.deidentification.models.OperationType
    :ivar data_type: Data type of the input. "Plaintext"
    :vartype data_type: str or ~azure.health.deidentification.models.DocumentDataType
    :ivar redaction_format: Format of the redacted output. Only valid when OperationType is
     "Redact".
    :vartype redaction_format: str
    """

    input_text: str = rest_field(name="inputText")
    """Input text to de-identify. Required."""
    operation: Optional[Union[str, "_models.OperationType"]] = rest_field()
    """Operation to perform on the input. Known values are: \"Redact\", \"Surrogate\", and \"Tag\"."""
    data_type: Optional[Union[str, "_models.DocumentDataType"]] = rest_field(name="dataType")
    """Data type of the input. \"Plaintext\""""
    redaction_format: Optional[str] = rest_field(name="redactionFormat")
    """Format of the redacted output. Only valid when OperationType is \"Redact\"."""

    @overload
    def __init__(
        self,
        *,
        input_text: str,
        operation: Optional[Union[str, "_models.OperationType"]] = None,
        data_type: Optional[Union[str, "_models.DocumentDataType"]] = None,
        redaction_format: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DeidentificationJob(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """A job containing a batch of documents to de-identify.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of a job. Required.
    :vartype name: str
    :ivar source_location: Storage location to perform the operation on. Required.
    :vartype source_location: ~azure.health.deidentification.models.SourceStorageLocation
    :ivar target_location: Target location to store output of operation. Required.
    :vartype target_location: ~azure.health.deidentification.models.TargetStorageLocation
    :ivar operation: Operation to perform on the input documents. Known values are: "Redact",
     "Surrogate", and "Tag".
    :vartype operation: str or ~azure.health.deidentification.models.OperationType
    :ivar data_type: Data type of the input documents. "Plaintext"
    :vartype data_type: str or ~azure.health.deidentification.models.DocumentDataType
    :ivar redaction_format: Format of the redacted output. Only valid when Operation is Redact.
    :vartype redaction_format: str
    :ivar status: Current status of a job. Required. Known values are: "NotStarted", "Running",
     "Succeeded", "PartialFailed", "Failed", and "Canceled".
    :vartype status: str or ~azure.health.deidentification.models.JobStatus
    :ivar error: Error when job fails in it's entirety.
    :vartype error: ~azure.health.deidentification.models.Error
    :ivar last_updated_at: Date and time when the job was completed.

     If the job is canceled, this is the time when the job was canceled.

     If the job failed, this is the time when the job failed. Required.
    :vartype last_updated_at: ~datetime.datetime
    :ivar created_at: Date and time when the job was created. Required.
    :vartype created_at: ~datetime.datetime
    :ivar started_at: Date and time when the job was started.
    :vartype started_at: ~datetime.datetime
    :ivar summary: Summary of a job. Exists only when the job is completed.
    :vartype summary: ~azure.health.deidentification.models.JobSummary
    """

    name: str = rest_field(visibility=["read"])
    """The name of a job. Required."""
    source_location: "_models.SourceStorageLocation" = rest_field(name="sourceLocation")
    """Storage location to perform the operation on. Required."""
    target_location: "_models.TargetStorageLocation" = rest_field(name="targetLocation")
    """Target location to store output of operation. Required."""
    operation: Optional[Union[str, "_models.OperationType"]] = rest_field()
    """Operation to perform on the input documents. Known values are: \"Redact\", \"Surrogate\", and
     \"Tag\"."""
    data_type: Optional[Union[str, "_models.DocumentDataType"]] = rest_field(name="dataType")
    """Data type of the input documents. \"Plaintext\""""
    redaction_format: Optional[str] = rest_field(name="redactionFormat")
    """Format of the redacted output. Only valid when Operation is Redact."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read"])
    """Current status of a job. Required. Known values are: \"NotStarted\", \"Running\",
     \"Succeeded\", \"PartialFailed\", \"Failed\", and \"Canceled\"."""
    error: Optional["_models.Error"] = rest_field(visibility=["read"])
    """Error when job fails in it's entirety."""
    last_updated_at: datetime.datetime = rest_field(name="lastUpdatedAt", visibility=["read"], format="rfc3339")
    """Date and time when the job was completed.
     
     If the job is canceled, this is the time when the job was canceled.
     
     If the job failed, this is the time when the job failed. Required."""
    created_at: datetime.datetime = rest_field(name="createdAt", visibility=["read"], format="rfc3339")
    """Date and time when the job was created. Required."""
    started_at: Optional[datetime.datetime] = rest_field(name="startedAt", visibility=["read"], format="rfc3339")
    """Date and time when the job was started."""
    summary: Optional["_models.JobSummary"] = rest_field(visibility=["read"])
    """Summary of a job. Exists only when the job is completed."""

    @overload
    def __init__(
        self,
        *,
        source_location: "_models.SourceStorageLocation",
        target_location: "_models.TargetStorageLocation",
        operation: Optional[Union[str, "_models.OperationType"]] = None,
        data_type: Optional[Union[str, "_models.DocumentDataType"]] = None,
        redaction_format: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DeidentificationResult(_model_base.Model):
    """Response body for de-identification operation.

    :ivar output_text: Output text after de-identification. Not available for "Tag" operation.
    :vartype output_text: str
    :ivar tagger_result: Result of the "Tag" operation. Only available for "Tag" Operation.
    :vartype tagger_result: ~azure.health.deidentification.models.PhiTaggerResult
    """

    output_text: Optional[str] = rest_field(name="outputText")
    """Output text after de-identification. Not available for \"Tag\" operation."""
    tagger_result: Optional["_models.PhiTaggerResult"] = rest_field(name="taggerResult")
    """Result of the \"Tag\" operation. Only available for \"Tag\" Operation."""

    @overload
    def __init__(
        self,
        *,
        output_text: Optional[str] = None,
        tagger_result: Optional["_models.PhiTaggerResult"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DocumentDetails(_model_base.Model):
    """Details of a single document in a job.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Id of the document details. Required.
    :vartype id: str
    :ivar input: Location for the input. Required.
    :vartype input: ~azure.health.deidentification.models.DocumentLocation
    :ivar output: Location for the output.
    :vartype output: ~azure.health.deidentification.models.DocumentLocation
    :ivar status: Status of the document. Required. Known values are: "NotStarted", "Running",
     "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.health.deidentification.models.OperationState
    :ivar error: Error when document fails.
    :vartype error: ~azure.health.deidentification.models.Error
    """

    id: str = rest_field(visibility=["read"])
    """Id of the document details. Required."""
    input: "_models.DocumentLocation" = rest_field()
    """Location for the input. Required."""
    output: Optional["_models.DocumentLocation"] = rest_field()
    """Location for the output."""
    status: Union[str, "_models.OperationState"] = rest_field()
    """Status of the document. Required. Known values are: \"NotStarted\", \"Running\", \"Succeeded\",
     \"Failed\", and \"Canceled\"."""
    error: Optional["_models.Error"] = rest_field()
    """Error when document fails."""

    @overload
    def __init__(
        self,
        *,
        input: "_models.DocumentLocation",
        status: Union[str, "_models.OperationState"],
        output: Optional["_models.DocumentLocation"] = None,
        error: Optional["_models.Error"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DocumentLocation(_model_base.Model):
    """Location of a document.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar path: Path of document in storage. Required.
    :vartype path: str
    :ivar etag: The entity tag for this resource. Required.
    :vartype etag: str
    """

    path: str = rest_field()
    """Path of document in storage. Required."""
    etag: str = rest_field(visibility=["read"])
    """The entity tag for this resource. Required."""

    @overload
    def __init__(
        self,
        *,
        path: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Error(_model_base.Model):
    """The error object.

    All required parameters must be populated in order to send to server.

    :ivar code: One of a server-defined set of error codes. Required.
    :vartype code: str
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.health.deidentification.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.health.deidentification.models.InnerError
    """

    code: str = rest_field()
    """One of a server-defined set of error codes. Required."""
    message: str = rest_field()
    """A human-readable representation of the error. Required."""
    target: Optional[str] = rest_field()
    """The target of the error."""
    details: Optional[List["_models.Error"]] = rest_field()
    """An array of details about specific errors that led to this reported error."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["_models.Error"]] = None,
        innererror: Optional["_models.InnerError"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InnerError(_model_base.Model):
    """An object containing more specific information about the error. As per Microsoft One API
    guidelines -
    https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar innererror: Inner error.
    :vartype innererror: ~azure.health.deidentification.models.InnerError
    """

    code: Optional[str] = rest_field()
    """One of a server-defined set of error codes."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """Inner error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class JobSummary(_model_base.Model):
    """Summary metrics of a job.


    :ivar successful: Number of documents that have completed. Required.
    :vartype successful: int
    :ivar failed: Number of documents that have failed. Required.
    :vartype failed: int
    :ivar canceled: Number of documents that have been canceled. Required.
    :vartype canceled: int
    :ivar total: Number of documents total. Required.
    :vartype total: int
    :ivar bytes_processed: Number of bytes processed. Required.
    :vartype bytes_processed: int
    """

    successful: int = rest_field()
    """Number of documents that have completed. Required."""
    failed: int = rest_field()
    """Number of documents that have failed. Required."""
    canceled: int = rest_field()
    """Number of documents that have been canceled. Required."""
    total: int = rest_field()
    """Number of documents total. Required."""
    bytes_processed: int = rest_field(name="bytesProcessed")
    """Number of bytes processed. Required."""

    @overload
    def __init__(
        self,
        *,
        successful: int,
        failed: int,
        canceled: int,
        total: int,
        bytes_processed: int,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PhiEntity(_model_base.Model):
    """PHI Entity tag in the input.


    :ivar category: PHI Category of the entity. Required. Known values are: "Unknown", "Account",
     "Age", "BioID", "City", "CountryOrRegion", "Date", "Device", "Doctor", "Email", "Fax",
     "HealthPlan", "Hospital", "IDNum", "IPAddress", "License", "LocationOther", "MedicalRecord",
     "Organization", "Patient", "Phone", "Profession", "SocialSecurity", "State", "Street", "Url",
     "Username", "Vehicle", and "Zip".
    :vartype category: str or ~azure.health.deidentification.models.PhiCategory
    :ivar offset: Starting index of the location from within the input text. Required.
    :vartype offset: ~azure.health.deidentification.models.StringIndex
    :ivar length: Length of the input text. Required.
    :vartype length: ~azure.health.deidentification.models.StringIndex
    :ivar text: Text of the entity.
    :vartype text: str
    :ivar confidence_score: Confidence score of the category match.
    :vartype confidence_score: float
    """

    category: Union[str, "_models.PhiCategory"] = rest_field()
    """PHI Category of the entity. Required. Known values are: \"Unknown\", \"Account\", \"Age\",
     \"BioID\", \"City\", \"CountryOrRegion\", \"Date\", \"Device\", \"Doctor\", \"Email\", \"Fax\",
     \"HealthPlan\", \"Hospital\", \"IDNum\", \"IPAddress\", \"License\", \"LocationOther\",
     \"MedicalRecord\", \"Organization\", \"Patient\", \"Phone\", \"Profession\",
     \"SocialSecurity\", \"State\", \"Street\", \"Url\", \"Username\", \"Vehicle\", and \"Zip\"."""
    offset: "_models.StringIndex" = rest_field()
    """Starting index of the location from within the input text. Required."""
    length: "_models.StringIndex" = rest_field()
    """Length of the input text. Required."""
    text: Optional[str] = rest_field()
    """Text of the entity."""
    confidence_score: Optional[float] = rest_field(name="confidenceScore")
    """Confidence score of the category match."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.PhiCategory"],
        offset: "_models.StringIndex",
        length: "_models.StringIndex",
        text: Optional[str] = None,
        confidence_score: Optional[float] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PhiTaggerResult(_model_base.Model):
    """Result of the "Tag" operation.


    :ivar entities: List of entities detected in the input. Required.
    :vartype entities: list[~azure.health.deidentification.models.PhiEntity]
    :ivar path: Path to the document in storage.
    :vartype path: str
    :ivar etag: The entity tag for this resource.
    :vartype etag: str
    """

    entities: List["_models.PhiEntity"] = rest_field()
    """List of entities detected in the input. Required."""
    path: Optional[str] = rest_field()
    """Path to the document in storage."""
    etag: Optional[str] = rest_field()
    """The entity tag for this resource."""

    @overload
    def __init__(
        self,
        *,
        entities: List["_models.PhiEntity"],
        path: Optional[str] = None,
        etag: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SourceStorageLocation(_model_base.Model):
    """Storage location.

    All required parameters must be populated in order to send to server.

    :ivar location: URL to storage location. Required.
    :vartype location: str
    :ivar prefix: Prefix to filter path by. Required.
    :vartype prefix: str
    :ivar extensions: List of extensions to filter path by.
    :vartype extensions: list[str]
    """

    location: str = rest_field()
    """URL to storage location. Required."""
    prefix: str = rest_field()
    """Prefix to filter path by. Required."""
    extensions: Optional[List[str]] = rest_field()
    """List of extensions to filter path by."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        prefix: str,
        extensions: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StringIndex(_model_base.Model):
    """String index encoding model.


    :ivar utf8: The offset or length of the substring in UTF-8 encoding. Required.
    :vartype utf8: int
    :ivar utf16: The offset or length of the substring in UTF-16 encoding.

     Primary encoding used by .NET, Java, and JavaScript. Required.
    :vartype utf16: int
    :ivar code_point: The offset or length of the substring in CodePoint encoding.

     Primary encoding used by Python. Required.
    :vartype code_point: int
    """

    utf8: int = rest_field()
    """The offset or length of the substring in UTF-8 encoding. Required."""
    utf16: int = rest_field()
    """The offset or length of the substring in UTF-16 encoding.
     
     Primary encoding used by .NET, Java, and JavaScript. Required."""
    code_point: int = rest_field(name="codePoint")
    """The offset or length of the substring in CodePoint encoding.
     
     Primary encoding used by Python. Required."""

    @overload
    def __init__(
        self,
        *,
        utf8: int,
        utf16: int,
        code_point: int,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TargetStorageLocation(_model_base.Model):
    """Storage location.

    All required parameters must be populated in order to send to server.

    :ivar location: URL to storage location. Required.
    :vartype location: str
    :ivar prefix: Prefix to filter path by. Required.
    :vartype prefix: str
    """

    location: str = rest_field()
    """URL to storage location. Required."""
    prefix: str = rest_field()
    """Prefix to filter path by. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        prefix: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
