# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.apimanagement import ApiManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-apimanagement
# USAGE
    python api_management_create_global_schema1.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ApiManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.global_schema.begin_create_or_update(
        resource_group_name="rg1",
        service_name="apimService1",
        schema_id="schema1",
        parameters={
            "properties": {
                "description": "sample schema description",
                "schemaType": "xml",
                "value": '<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"\r\n           xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"\r\n           targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"\r\n           elementFormDefault="qualified">\r\n <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>\r\n <xsd:complexType name="PurchaseOrderType">\r\n  <xsd:sequence>\r\n   <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>\r\n   <xsd:element name="BillTo" type="tns:USAddress"/>\r\n  </xsd:sequence>\r\n  <xsd:attribute name="OrderDate" type="xsd:date"/>\r\n </xsd:complexType>\r\n\r\n <xsd:complexType name="USAddress">\r\n  <xsd:sequence>\r\n   <xsd:element name="name"   type="xsd:string"/>\r\n   <xsd:element name="street" type="xsd:string"/>\r\n   <xsd:element name="city"   type="xsd:string"/>\r\n   <xsd:element name="state"  type="xsd:string"/>\r\n   <xsd:element name="zip"    type="xsd:integer"/>\r\n  </xsd:sequence>\r\n  <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>\r\n </xsd:complexType>\r\n</xsd:schema>',
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateGlobalSchema1.json
if __name__ == "__main__":
    main()
