/*
 * Copyright (C) 2017 Red Hat Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/**
 * \file invalid-draw-mode.c
 *
 * Additions to OpenGL 4.3 Compatibility Profile, section 14.6.4 ref:
 *    "An INVALID_OPERATION error is generated by Begin or any Draw command if
 *     only one of the front and back polygon mode is FILL_RECTANGLE_NV."
 */

#include "piglit-util-gl.h"

PIGLIT_GL_TEST_CONFIG_BEGIN

config.supports_gl_compat_version = 13;

PIGLIT_GL_TEST_CONFIG_END

GLint prog;

void
piglit_init(int argc, char **argv)
{
	bool pass = true;

	piglit_require_extension("GL_NV_fill_rectangle");

	prog = piglit_build_simple_program(
	    "#version 110\n"
	    "attribute vec4 vertex;\n"
	    "void main() { gl_Position = vertex; }\n",
	    "#version 110\n"
	    "void main() { }\n");

	glUseProgram(prog);
	glViewport(0, 0, piglit_width, piglit_height);
	glPolygonMode(GL_FRONT, GL_FILL_RECTANGLE_NV);

	/* Since we haven't set the mode for GL_BACK, it defaults to
	 * GL_FILL
	 */

	piglit_draw_triangle(0, 0, 0, 0, 0, 0);

	if (piglit_check_gl_error(GL_NO_ERROR))
		pass = false;

	piglit_report_result(pass ? PIGLIT_PASS : PIGLIT_FAIL);
}

enum piglit_result
piglit_display(void)
{
	/* UNREACHED */
	return PIGLIT_FAIL;
}
